/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataAccess;
import org.geotools.data.complex.AppSchemaDataAccessFactory;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.feature.type.Types;
import org.junit.Assert;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class TestFeatureSource
implements Closeable {
    private String schemaBase = "/test-data/index/";
    private String filename = "";
    private String nsUri = "http://www.stations.org/1.0";
    private Name mappedTypeName = Types.typeName(null, (String)"stationsIndexed");
    private AppSchemaDataAccessFactory factory;
    private Map<String, Serializable> params;
    private DataAccess<FeatureType, Feature> dataStore;
    private MappingFeatureSource mappedSource;

    public TestFeatureSource(String schemaBase, String filename, String nsUri, String mappedTypeName) {
        this.schemaBase = schemaBase;
        this.filename = filename;
        this.nsUri = nsUri;
        this.mappedTypeName = Types.typeName(null, (String)mappedTypeName);
        this.initialize();
    }

    protected void initialize() {
        this.factory = new AppSchemaDataAccessFactory();
        this.params = new HashMap<String, Serializable>();
        this.params.put("dbtype", (Serializable)((Object)"app-schema"));
        URL resource = this.getClass().getResource(this.schemaBase + this.filename);
        if (resource == null) {
            Assert.fail((String)("Can't find resouce " + this.schemaBase + this.filename));
        }
        this.params.put("url", resource);
        try {
            this.dataStore = this.factory.createDataStore(this.params);
            this.mappedSource = (MappingFeatureSource)this.dataStore.getFeatureSource(this.mappedTypeName);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        this.dataStore.dispose();
    }

    public String getSchemaBase() {
        return this.schemaBase;
    }

    public String getNsUri() {
        return this.nsUri;
    }

    public DataAccess<FeatureType, Feature> getDataStore() {
        return this.dataStore;
    }

    public MappingFeatureSource getMappedSource() {
        return this.mappedSource;
    }
}

