/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.appschema.filter.NestedAttributeExpression;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.spi.CustomImplementationsFinder;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.xml.sax.helpers.NamespaceSupport;

public class UnmappingFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    private static final Logger LOGGER = Logging.getLogger(UnmappingFilterVisitor.class);
    protected FeatureTypeMapping mappings;
    private static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);

    public UnmappingFilterVisitor(FeatureTypeMapping mappings) {
        this.mappings = mappings;
    }

    private Filter combineOred(List<Filter> combinedFilters) {
        switch (combinedFilters.size()) {
            case 0: {
                throw new IllegalArgumentException("No filters to combine");
            }
            case 1: {
                return combinedFilters.get(0);
            }
        }
        return ff.or(combinedFilters);
    }

    public Expression[][] visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        List leftExpressions = (List)left.accept((ExpressionVisitor)this, null);
        List rightExpressions = (List)right.accept((ExpressionVisitor)this, null);
        if (leftExpressions.isEmpty()) {
            throw new IllegalStateException(String.valueOf(left) + " mapping not found");
        }
        if (rightExpressions.isEmpty()) {
            throw new IllegalStateException(String.valueOf(right) + " mapping not found");
        }
        Expression[][] product = this.buildExpressionsMatrix(leftExpressions, rightExpressions);
        return product;
    }

    private Expression[][] buildExpressionsMatrix(List leftExpressions, List rightExpressions) {
        Expression[][] product = new Expression[leftExpressions.size() * rightExpressions.size()][2];
        int index = 0;
        for (Object leftExpression : leftExpressions) {
            Expression left = (Expression)leftExpression;
            int rightIndex = 0;
            for (Object rightExpression : rightExpressions) {
                Expression right = (Expression)rightExpression;
                product[index += rightIndex][0] = left;
                product[index][1] = right;
                ++rightIndex;
            }
            ++index;
        }
        return product;
    }

    public Expression[][] visitBinarySpatialOp(BinarySpatialOperator filter) {
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        List leftExpressions = (List)left.accept((ExpressionVisitor)this, null);
        List rightExpressions = (List)right.accept((ExpressionVisitor)this, null);
        if (leftExpressions.isEmpty()) {
            throw new IllegalStateException(String.valueOf(left) + " mapping not found");
        }
        if (rightExpressions.isEmpty()) {
            throw new IllegalStateException(String.valueOf(right) + " mapping not found");
        }
        Expression[][] product = this.buildExpressionsMatrix(leftExpressions, rightExpressions);
        return product;
    }

    public List<Filter> visitBinaryLogicOp(BinaryLogicOperator filter) {
        ArrayList<Filter> unrolledFilers = new ArrayList<Filter>();
        try {
            for (Filter next : filter.getChildren()) {
                Filter unrolled = (Filter)next.accept((FilterVisitor)this, null);
                unrolledFilers.add(unrolled);
            }
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return unrolledFilers;
    }

    public Expression[][] visitBinaryExpression(BinaryExpression expression) {
        LOGGER.finest(expression.toString());
        Expression left = expression.getExpression1();
        Expression right = expression.getExpression2();
        List leftExpressions = (List)left.accept((ExpressionVisitor)this, null);
        List rightExpressions = (List)right.accept((ExpressionVisitor)this, null);
        Expression[][] product = this.buildExpressionsMatrix(leftExpressions, rightExpressions);
        return product;
    }

    public Object visit(ExcludeFilter filter, Object arg1) {
        return filter;
    }

    public Object visit(IncludeFilter filter, Object arg1) {
        return filter;
    }

    public Object visit(And filter, Object arg1) {
        List<Filter> list = this.visitBinaryLogicOp((BinaryLogicOperator)filter);
        And unrolled = ff.and(list);
        return unrolled;
    }

    public Object visit(Id filter, Object arg1) {
        Function fe;
        Set fids = filter.getIdentifiers();
        Name target = this.mappings.getTargetFeature().getName();
        String namespace = target.getNamespaceURI();
        if (namespace == null) {
            namespace = "";
        }
        String name = target.getLocalPart();
        Expression fidExpression = null;
        for (AttributeMapping attMapping : this.mappings.getAttributeMappings()) {
            XPathUtil.Step step;
            QName stepName;
            XPathUtil.StepList targetXPath = attMapping.getTargetXPath();
            if (targetXPath.size() > 1 || !namespace.equals((stepName = (step = (XPathUtil.Step)targetXPath.get(0)).getName()).getNamespaceURI()) || !name.equals(stepName.getLocalPart())) continue;
            fidExpression = attMapping.getIdentifierExpression();
            break;
        }
        if (fidExpression == null) {
            throw new IllegalStateException("No FID expression found for type " + String.valueOf(target) + ". Did you mean Expression.NIL?");
        }
        if (Expression.NIL.equals(fidExpression)) {
            return filter;
        }
        if (fidExpression instanceof Function && "getID".equalsIgnoreCase((fe = (Function)fidExpression).getName())) {
            LOGGER.finest("Fid mapping points to same ID as source");
            return filter;
        }
        LOGGER.finest("fid mapping expression is " + String.valueOf(fidExpression));
        Or unrolled = null;
        ArrayList<PropertyIsEqualTo> filters = new ArrayList<PropertyIsEqualTo>();
        try {
            for (Object o : fids) {
                Identifier fid = (Identifier)o;
                PropertyIsEqualTo comparison = ff.equals(fidExpression, (Expression)ff.literal((Object)fid.toString()));
                LOGGER.finest("Adding unmapped fid filter " + String.valueOf(comparison));
                filters.add(comparison);
            }
            unrolled = ff.or(filters);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "unrolling " + String.valueOf(filter), e);
            throw new RuntimeException(e.getMessage());
        }
        LOGGER.finer("unrolled fid filter is " + String.valueOf(unrolled));
        return unrolled;
    }

    public Object visit(Not filter, Object arg1) {
        Filter unrolled = (Filter)filter.getFilter().accept((FilterVisitor)this, null);
        unrolled = ff.not(unrolled);
        return unrolled;
    }

    public Object visit(Or filter, Object arg1) {
        List<Filter> list = this.visitBinaryLogicOp((BinaryLogicOperator)filter);
        Or unrolled = ff.or(list);
        return unrolled;
    }

    public Object visit(PropertyIsBetween filter, Object arg1) {
        Expression expression = filter.getExpression();
        Expression lower = filter.getLowerBoundary();
        Expression upper = filter.getUpperBoundary();
        List expressions = (List)expression.accept((ExpressionVisitor)this, null);
        List lowerExpressions = (List)lower.accept((ExpressionVisitor)this, null);
        List upperExpressions = (List)upper.accept((ExpressionVisitor)this, null);
        int combinedSize = expressions.size() * lowerExpressions.size() * upperExpressions.size();
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(combinedSize);
        for (Object lowerExpression : lowerExpressions) {
            Expression floor = (Expression)lowerExpression;
            for (Object o : expressions) {
                Expression prop = (Expression)o;
                for (Object upperExpression : upperExpressions) {
                    Expression roof = (Expression)upperExpression;
                    PropertyIsBetween newFilter = ff.between(prop, floor, roof, filter.getMatchAction());
                    combinedFilters.add((Filter)newFilter);
                }
            }
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsEqualTo filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            PropertyIsEqualTo unrolled = ff.equal(left, right, filter.isMatchingCase(), filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            PropertyIsNotEqualTo unrolled = ff.notEqual(left, right, filter.isMatchingCase(), filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsGreaterThan filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            PropertyIsGreaterThan unrolled = ff.greater(left, right, filter.isMatchingCase(), filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            PropertyIsGreaterThanOrEqualTo unrolled = ff.greaterOrEqual(left, right, filter.isMatchingCase(), filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsLessThan filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            PropertyIsLessThan unrolled = ff.less(left, right, filter.isMatchingCase(), filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            PropertyIsLessThanOrEqualTo unrolled = ff.lessOrEqual(left, right, filter.isMatchingCase(), filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsLike filter, Object arg1) {
        Expression value = filter.getExpression();
        List unrolledValues = (List)value.accept((ExpressionVisitor)this, null);
        String literal = filter.getLiteral();
        String wildcard = filter.getWildCard();
        String single = filter.getSingleChar();
        String escape = filter.getEscape();
        boolean matchCase = filter.isMatchingCase();
        MultiValuedFilter.MatchAction matchAction = filter.getMatchAction();
        ArrayList<Filter> combined = new ArrayList<Filter>(unrolledValues.size());
        for (Expression sourceValue : unrolledValues) {
            PropertyIsLike newFilter = ff.like(sourceValue, literal, wildcard, single, escape, matchCase, matchAction);
            combined.add((Filter)newFilter);
        }
        Filter unrolled = this.combineOred(combined);
        return unrolled;
    }

    public Object visit(PropertyIsNull filter, Object arg1) {
        Expression nullCheck = filter.getExpression();
        List sourceChecks = (List)nullCheck.accept((ExpressionVisitor)this, null);
        ArrayList<Filter> combined = new ArrayList<Filter>(sourceChecks.size());
        for (Expression sourceValue : sourceChecks) {
            PropertyIsNull newFilter = ff.isNull(sourceValue);
            combined.add((Filter)newFilter);
        }
        Filter unrolled = this.combineOred(combined);
        return unrolled;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("visit(PropertyIsNil filter, Object extraData)");
    }

    public Object visit(BBOX filter, Object arg1) {
        String propertyName = ((PropertyName)filter.getExpression1()).getPropertyName();
        if (propertyName.length() < 1) {
            return filter;
        }
        PropertyName name = ff.property(propertyName);
        List sourceNames = (List)name.accept((ExpressionVisitor)this, null);
        ArrayList<Filter> combined = new ArrayList<Filter>(sourceNames.size());
        for (Expression sourceName : sourceNames) {
            BBOX unrolled = ff.bbox(sourceName, filter.getBounds(), filter.getMatchAction());
            combined.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combined);
        return unrolled;
    }

    public Object visit(Beyond filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Beyond unrolled = ff.beyond(left, right, filter.getDistance(), filter.getDistanceUnits(), filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Contains filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Contains unrolled = ff.contains(left, right, filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Crosses filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Crosses unrolled = ff.crosses(left, right, filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Disjoint filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Disjoint unrolled = ff.disjoint(left, right, filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(DWithin filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            DWithin unrolled = ff.dwithin(left, right, filter.getDistance(), filter.getDistanceUnits(), filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Equals filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Equals unrolled = ff.equal(left, right, filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Intersects filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Intersects unrolled = ff.intersects(left, right, filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Overlaps filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Overlaps unrolled = ff.overlaps(left, right, filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Touches filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Touches unrolled = ff.touches(left, right, filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Within filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Filter> combinedFilters = new ArrayList<Filter>(exps.length);
        for (Expression[] exp : exps) {
            Expression left = exp[0];
            Expression right = exp[1];
            Within unrolled = ff.within(left, right, filter.getMatchAction());
            combinedFilters.add((Filter)unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visitNullFilter(Object arg0) {
        return Filter.EXCLUDE;
    }

    public Object visit(NilExpression expr, Object arg1) {
        return Collections.singletonList(expr);
    }

    public Object visit(Add expr, Object arg1) {
        Expression[][] expressions = this.visitBinaryExpression((BinaryExpression)expr);
        ArrayList<Add> combinedExpressions = new ArrayList<Add>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            Add sourceExpression = ff.add(left, right);
            combinedExpressions.add(sourceExpression);
        }
        return combinedExpressions;
    }

    public Object visit(Divide expr, Object arg1) {
        Expression[][] expressions = this.visitBinaryExpression((BinaryExpression)expr);
        ArrayList<Divide> combinedExpressions = new ArrayList<Divide>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            Divide sourceExpression = ff.divide(left, right);
            combinedExpressions.add(sourceExpression);
        }
        return combinedExpressions;
    }

    public Object visit(Function function, Object arg1) {
        List expressions = function.getParameters();
        ArrayList<Expression> arguments = new ArrayList<Expression>(expressions.size());
        for (Expression mappingExpression : expressions) {
            List sourceExpressions = (List)mappingExpression.accept((ExpressionVisitor)this, null);
            if (sourceExpressions.size() > 1) {
                throw new UnsupportedOperationException("unrolling function arguments that map to more than one source expressions is not supported yet");
            }
            Expression unrolledExpression = (Expression)sourceExpressions.get(0);
            arguments.add(unrolledExpression);
        }
        Expression[] unmapped = new Expression[arguments.size()];
        unmapped = arguments.toArray(unmapped);
        Function unmappedFunction = ff.function(function.getName(), unmapped);
        return Collections.singletonList(unmappedFunction);
    }

    public Object visit(Literal expr, Object arg1) {
        return Collections.singletonList(expr);
    }

    public Object visit(Multiply expr, Object arg1) {
        Expression[][] expressions = this.visitBinaryExpression((BinaryExpression)expr);
        ArrayList<Multiply> combinedExpressions = new ArrayList<Multiply>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            Multiply sourceExpression = ff.multiply(left, right);
            combinedExpressions.add(sourceExpression);
        }
        return combinedExpressions;
    }

    public List<Expression> visit(PropertyName expr, Object arg1) {
        String targetXPath = expr.getPropertyName();
        if ("__DEFAULT_GEOMETRY__".equals(targetXPath)) {
            targetXPath = this.mappings.getDefaultGeometryXPath();
        }
        NamespaceSupport namespaces = this.mappings.getNamespaces();
        AttributeDescriptor root = this.mappings.getTargetFeature();
        List<NestedAttributeMapping> nestedMappings = this.mappings.getNestedMappings();
        XPathUtil.StepList simplifiedSteps = XPath.steps((AttributeDescriptor)root, (String)targetXPath, (NamespaceSupport)namespaces);
        List<Expression> matchingMappings = this.mappings.findMappingsFor(simplifiedSteps, false);
        Iterator<Expression> it = matchingMappings.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        if (!nestedMappings.isEmpty()) {
            for (NestedAttributeMapping nestedMapping : nestedMappings) {
                if (!simplifiedSteps.startsWith(nestedMapping.getTargetXPath())) continue;
                Expression nestedAttributeExpression = CustomImplementationsFinder.find(this.mappings, simplifiedSteps, nestedMapping);
                if (nestedAttributeExpression != null) {
                    matchingMappings.add(nestedAttributeExpression);
                    continue;
                }
                matchingMappings.add((Expression)new NestedAttributeExpression(simplifiedSteps, nestedMapping));
            }
        }
        matchingMappings.remove(Expression.NIL);
        if (matchingMappings.isEmpty()) {
            throw new IllegalArgumentException("Can't find source expression for: " + targetXPath);
        }
        return matchingMappings;
    }

    public Object visit(Subtract expr, Object arg1) {
        Expression[][] expressions = this.visitBinaryExpression((BinaryExpression)expr);
        ArrayList<Subtract> combinedExpressions = new ArrayList<Subtract>(expressions.length);
        for (Expression[] expression : expressions) {
            Expression left = expression[0];
            Expression right = expression[1];
            Subtract sourceExpression = ff.subtract(left, right);
            combinedExpressions.add(sourceExpression);
        }
        return combinedExpressions;
    }

    public Object visit(After after, Object extraData) {
        return this.visit((BinaryTemporalOperator)after, extraData);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visit((BinaryTemporalOperator)anyInteracts, extraData);
    }

    public Object visit(Before before, Object extraData) {
        return this.visit((BinaryTemporalOperator)before, extraData);
    }

    public Object visit(Begins begins, Object extraData) {
        return this.visit((BinaryTemporalOperator)begins, extraData);
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)begunBy, extraData);
    }

    public Object visit(During during, Object extraData) {
        return this.visit((BinaryTemporalOperator)during, extraData);
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)endedBy, extraData);
    }

    public Object visit(Ends ends, Object extraData) {
        return this.visit((BinaryTemporalOperator)ends, extraData);
    }

    public Object visit(Meets meets, Object extraData) {
        return this.visit((BinaryTemporalOperator)meets, extraData);
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)metBy, extraData);
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)overlappedBy, extraData);
    }

    public Object visit(TContains contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.visit((BinaryTemporalOperator)equals, extraData);
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        throw new UnsupportedOperationException("Temporal filters not supported");
    }
}

