/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.spi.CustomAttributeExpressionFactory;
import org.geotools.data.complex.spi.CustomMappingFactory;
import org.geotools.data.complex.util.XPathUtil;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

public final class CustomImplementationsFinder {
    private static List<CustomMappingFactory> mappingsFactories = new ArrayList<CustomMappingFactory>();
    private static List<CustomAttributeExpressionFactory> attributesFactories = new ArrayList<CustomAttributeExpressionFactory>();

    private CustomImplementationsFinder() {
    }

    private static <T> List<T> initFactories(Class<T> type) {
        ServiceLoader<T> loader = ServiceLoader.load(type);
        loader.reload();
        ArrayList<T> factories = new ArrayList<T>();
        for (T aLoader : loader) {
            factories.add(aLoader);
        }
        return factories;
    }

    public static NestedAttributeMapping find(AppSchemaDataAccessConfigurator configuration, Expression idExpression, Expression parentExpression, XPathUtil.StepList targetXPath, boolean isMultiValued, Map<Name, Expression> clientProperties, Expression sourceElement, XPathUtil.StepList sourcePath, NamespaceSupport namespaces) {
        for (CustomMappingFactory factory : mappingsFactories) {
            NestedAttributeMapping mapping = factory.createNestedAttributeMapping(configuration, idExpression, parentExpression, targetXPath, isMultiValued, clientProperties, sourceElement, sourcePath, namespaces);
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }

    public static Expression find(FeatureTypeMapping mappings, XPathUtil.StepList xpath, NestedAttributeMapping nestedMapping) {
        for (CustomAttributeExpressionFactory factory : attributesFactories) {
            Expression attributeExpression = factory.createNestedAttributeExpression(mappings, xpath, nestedMapping);
            if (attributeExpression == null) continue;
            return attributeExpression;
        }
        return null;
    }

    static {
        mappingsFactories = CustomImplementationsFinder.initFactories(CustomMappingFactory.class);
        attributesFactories = CustomImplementationsFinder.initFactories(CustomAttributeExpressionFactory.class);
    }
}

