/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.joining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.geotools.data.Query;
import org.geotools.data.complex.FeatureTypeMapping;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;

public class JoiningQuery
extends Query {
    protected List<QueryJoin> queryJoins;
    private boolean isSubset;
    private boolean isDenormalised;
    protected List<String> ids;
    FeatureTypeMapping rootMapping;

    public JoiningQuery(JoiningQuery query) {
        super((Query)query);
        this.setQueryJoins(query.getQueryJoins());
        this.setSubset(query.isSubset);
        this.isDenormalised = query.isDenormalised;
        this.ids = query.ids;
    }

    public JoiningQuery(Query query) {
        super(query);
        this.ids = new ArrayList<String>();
    }

    public JoiningQuery() {
        this.ids = new ArrayList<String>();
    }

    public void setQueryJoins(List<QueryJoin> queryJoins) {
        this.queryJoins = queryJoins;
    }

    public List<QueryJoin> getQueryJoins() {
        if (this.queryJoins == null) {
            return Collections.emptyList();
        }
        return this.queryJoins;
    }

    public void setSubset(boolean isSubset) {
        this.isSubset = isSubset;
    }

    public boolean isSubset() {
        return this.isSubset;
    }

    public boolean hasIdColumn() {
        return !this.ids.isEmpty();
    }

    public void addId(String pn) {
        this.ids.add(pn);
    }

    public List<String> getIds() {
        return this.ids;
    }

    public boolean isDenormalised() {
        return this.isDenormalised;
    }

    public void setDenormalised(boolean isDenormalised) {
        this.isDenormalised = isDenormalised;
    }

    public FeatureTypeMapping getRootMapping() {
        return this.rootMapping;
    }

    public void setRootMapping(FeatureTypeMapping rootMapping) {
        this.rootMapping = rootMapping;
    }

    public static class QueryJoin
    extends JoiningQuery {
        protected String joiningTypeName;
        protected Expression foreignKeyName;
        protected Expression joiningKeyName;
        protected SortBy[] sortBy;

        public String getJoiningTypeName() {
            return this.joiningTypeName;
        }

        public void setJoiningTypeName(String joiningTypeName) {
            this.joiningTypeName = joiningTypeName;
        }

        public Expression getForeignKeyName() {
            return this.foreignKeyName;
        }

        public void setForeignKeyName(Expression foreignKeyName) {
            this.foreignKeyName = foreignKeyName;
        }

        public Expression getJoiningKeyName() {
            return this.joiningKeyName;
        }

        public void setJoiningKeyName(Expression joiningKeyName) {
            this.joiningKeyName = joiningKeyName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            QueryJoin queryJoin = (QueryJoin)((Object)o);
            return Objects.equals(this.joiningTypeName, queryJoin.joiningTypeName) && Objects.equals(this.foreignKeyName, queryJoin.foreignKeyName) && Objects.equals(this.joiningKeyName, queryJoin.joiningKeyName) && Arrays.equals(this.sortBy, queryJoin.sortBy);
        }

        public int hashCode() {
            int result = Objects.hash(this.joiningTypeName, this.foreignKeyName, this.joiningKeyName);
            result = 31 * result + Arrays.hashCode(this.sortBy);
            return result;
        }
    }
}

