/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.appschema.filter.BBoxTest;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public class ArithmeticFilterTest
extends AppSchemaTestSupport {
    private static FilterFactoryImpl ff;
    private static DataAccess<FeatureType, Feature> dataAccess;
    private static FeatureSource<FeatureType, Feature> fSource;

    @BeforeClass
    public static void onetimeSetUp() throws Exception {
        String GSML_URI = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        ff = new FilterFactoryImplNamespaceAware(namespaces);
        Name FEATURE_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeature");
        String schemaBase = "/test-data/";
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        URL url = BBoxTest.class.getResource("/test-data/MappedFeatureAsOccurrence.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        dataAccess = DataAccessFinder.getDataStore(dsParams);
        fSource = dataAccess.getFeatureSource(FEATURE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithArithmeticOperator() throws IOException {
        PropertyIsEqualTo arithmeticMultiplyFilter = ff.equals((Expression)ff.multiply((Expression)ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(2)), (Expression)ff.literal(400));
        PropertyIsEqualTo arithmeticDivideFilter = ff.equals((Expression)ff.divide((Expression)ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(2)), (Expression)ff.literal(100));
        PropertyIsEqualTo arithmeticAdditionFilter = ff.equals((Expression)ff.add((Expression)ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(100)), (Expression)ff.literal(300));
        PropertyIsEqualTo arithmeticSubtractionFilter = ff.equals((Expression)ff.subtract((Expression)ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(100)), (Expression)ff.literal(100));
        FeatureCollection features = fSource.getFeatures();
        PropertyName positionalAccuracy = ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue");
        try (FeatureIterator iterator = features.features();){
            Feature f = iterator.next();
            Property val = (Property)positionalAccuracy.evaluate((Object)f);
            System.out.println(val.getValue());
            Assert.assertTrue((boolean)arithmeticMultiplyFilter.evaluate((Object)f));
            Assert.assertTrue((boolean)arithmeticDivideFilter.evaluate((Object)f));
            Assert.assertTrue((boolean)arithmeticAdditionFilter.evaluate((Object)f));
            Assert.assertTrue((boolean)arithmeticSubtractionFilter.evaluate((Object)f));
        }
    }
}

