/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter.expression;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URL;
import org.geotools.data.complex.config.AppSchemaFeatureTypeRegistry;
import org.geotools.data.complex.expression.FeaturePropertyAccessorFactory;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.EmfComplexFeatureReader;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.util.factory.Hints;
import org.geotools.xsd.SchemaIndex;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaFeaturePropertyAccessorTest
extends AppSchemaTestSupport {
    private static final String GSMLNS = "http://www.cgi-iugs.org/xml/GeoSciML/2";
    private static final String XLINKNS = "http://www.w3.org/1999/xlink";
    private static final String schemaBase = "/test-data/";
    static final NamespaceSupport GSMLNAMESPACES = new NamespaceSupport(){
        {
            this.declarePrefix("gsml", AppSchemaFeaturePropertyAccessorTest.GSMLNS);
            this.declarePrefix("xlink", AppSchemaFeaturePropertyAccessorTest.XLINKNS);
        }
    };

    private SchemaIndex loadSchema(String location) throws IOException {
        EmfComplexFeatureReader reader = EmfComplexFeatureReader.newInstance();
        URL catalogLocation = this.getClass().getResource("/test-data/mappedPolygons.oasis.xml");
        reader.setResolver(catalogLocation);
        return reader.parse(new URL(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPolymorphism() throws Exception {
        SchemaIndex schemaIndex = this.loadSchema("http://schemas.opengis.net/GeoSciML/Gsml.xsd");
        AppSchemaFeatureTypeRegistry typeRegistry = new AppSchemaFeatureTypeRegistry();
        try {
            typeRegistry.addSchemas(schemaIndex);
            Name typeName = Types.typeName((String)GSMLNS, (String)"MappedFeatureType");
            ComplexType mf = (ComplexType)typeRegistry.getAttributeType(typeName);
            Assert.assertNotNull((Object)mf);
            Assert.assertTrue((boolean)(mf instanceof FeatureType));
            AttributeExpressionImpl ex = new AttributeExpressionImpl("gsml:specification/gsml:GeologicUnit/gsml:preferredAge/gsml:GeologicEvent/gsml:eventAge/gsml:CGI_TermRange/gsml:upper/gsml:CGI_TermValue/gsml:value", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)GSMLNAMESPACES));
            Object o = ex.evaluate((Object)mf);
            Assert.assertNotNull((Object)o);
            Assert.assertTrue((boolean)(o instanceof PropertyDescriptor));
            ex = new AttributeExpressionImpl("gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology/@xlink:href", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)GSMLNAMESPACES));
            o = ex.evaluate((Object)mf);
            Assert.assertNotNull((Object)o);
            Assert.assertTrue((boolean)o.equals(Types.typeName((String)XLINKNS, (String)"href")));
            ex = new AttributeExpressionImpl("gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology/@foo:bar", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)GSMLNAMESPACES));
            o = ex.evaluate((Object)mf);
            Assert.assertNull((Object)o);
        }
        finally {
            typeRegistry.disposeSchemaIndexes();
        }
    }
}

