/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.util;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.gml3.GMLSchema;
import org.geotools.util.Converters;
import org.geotools.xs.XSSchema;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;

public class ComplexAttributeConverterFactoryTest
extends TestCase {
    public void testLeafComplexAttribute() {
        ArrayList<AttributeImpl> attributes = new ArrayList<AttributeImpl>();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(XSSchema.STRING_TYPE, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        attributes.add(new AttributeImpl((Object)"rini", (AttributeDescriptor)descriptor, null));
        ComplexAttributeImpl gmlName = new ComplexAttributeImpl(attributes, GMLSchema.CODETYPE_TYPE, null);
        String nameString = (String)Converters.convert((Object)gmlName, String.class);
        ComplexAttributeConverterFactoryTest.assertEquals((String)"rini", (String)nameString);
    }

    public void testParentComplexAttribute() {
        ArrayList<AttributeImpl> attributes = new ArrayList<AttributeImpl>();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(XSSchema.STRING_TYPE, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        attributes.add(new AttributeImpl((Object)"rini", (AttributeDescriptor)descriptor, null));
        ComplexAttributeImpl gmlName = new ComplexAttributeImpl(attributes, GMLSchema.CODETYPE_TYPE, null);
        ArrayList<ComplexAttributeImpl> parentAttributes = new ArrayList<ComplexAttributeImpl>();
        parentAttributes.add(gmlName);
        ComplexAttributeImpl parentAtt = new ComplexAttributeImpl(parentAttributes, GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);
        String nameString = (String)Converters.convert((Object)parentAtt, String.class);
        ComplexAttributeConverterFactoryTest.assertEquals((String)parentAtt.toString(), (String)nameString);
        ComplexAttributeConverterFactoryTest.assertNotSame((Object)"rini", (Object)nameString);
    }

    public void testFeatureId() throws Exception {
        FeatureId id = (FeatureId)Converters.convert((Object)"blah", FeatureId.class);
        ComplexAttributeConverterFactoryTest.assertNotNull((Object)id);
        ComplexAttributeConverterFactoryTest.assertEquals((String)id.getID(), (String)"blah");
    }

    public void testGeometry() {
        GeometryAttributeImpl geoatt;
        Geometry geometry2;
        GeometryCollection geometry = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING)).createGeometryCollection();
        ComplexAttributeConverterFactoryTest.assertTrue((geometry == (geometry2 = (Geometry)Converters.convert((Object)(geoatt = new GeometryAttributeImpl((Object)geometry, (GeometryDescriptor)new GeometryDescriptorImpl((GeometryType)new GeometryTypeImpl((Name)new NameImpl(""), GeometryCollection.class, null, false, false, null, null, null), (Name)new NameImpl(""), 0, 0, false, null), null)), Geometry.class)) ? 1 : 0) != 0);
    }

    public void testAttributeConversion() {
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(XSSchema.DOUBLE_TYPE, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        AttributeImpl attribute = new AttributeImpl((Object)35.0, (AttributeDescriptor)descriptor, null);
        Object result = Converters.convert((Object)attribute, Double.class);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Double.class));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)35.0));
        result = Converters.convert((Object)attribute, String.class);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"35.0"));
    }

    public void testAttributeListConversion() {
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(XSSchema.INTEGER_TYPE, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        AttributeImpl attribute1 = new AttributeImpl((Object)35, (AttributeDescriptor)descriptor, null);
        AttributeImpl attribute2 = new AttributeImpl((Object)40, (AttributeDescriptor)descriptor, null);
        ArrayList<AttributeImpl> attributes = new ArrayList<AttributeImpl>();
        attributes.add(attribute1);
        attributes.add(attribute2);
        Object result = Converters.convert(attributes, String.class);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"35, 40"));
        result = Converters.convert(attributes, Integer.class);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.nullValue());
    }
}

