/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.util;

import java.util.List;
import org.geotools.appschema.util.IndexQueryUtils;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.TestFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class IndexQueryUtilsTest {
    @Test
    public void testCheckAllPropertiesIndexedXpath() {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            Assert.assertTrue((boolean)IndexQueryUtils.checkAllPropertiesIndexed((List)IndexQueryUtils.getAttributesOnFilter((Filter)this.totallyIndexedFilterXpath()), (FeatureTypeMapping)fsource.getMappedSource().getMapping()));
            Assert.assertFalse((boolean)IndexQueryUtils.checkAllPropertiesIndexed((List)IndexQueryUtils.getAttributesOnFilter((Filter)this.partialIndexedFilterXpath()), (FeatureTypeMapping)fsource.getMappedSource().getMapping()));
        }
    }

    @Test
    public void testEqualsXpath() {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            AttributeMapping attMap = fsource.getMappedSource().getMapping().getAttributeMapping("st:Station/st:name");
            Assert.assertNotNull((Object)attMap);
        }
    }

    private Filter totallyIndexedFilter() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        And filter = ff.and((Filter)ff.equals((Expression)ff.property("ID"), (Expression)ff.literal((Object)"st.1")), (Filter)ff.like((Expression)ff.property("NAME"), "*fer*"));
        return filter;
    }

    private Filter partialIndexedFilter() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        And filter = ff.and((Filter)ff.equals((Expression)ff.property("ID"), (Expression)ff.literal((Object)"st.1")), (Filter)ff.like((Expression)ff.property("LOCATION_NAME"), "*fer*"));
        return filter;
    }

    private Filter totallyIndexedFilterXpath() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        And filter = ff.and((Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.1")), (Filter)ff.like((Expression)ff.property("st:Station/st:name"), "*fer*"));
        return filter;
    }

    private Filter partialIndexedFilterXpath() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        And filter = ff.and((Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.1")), (Filter)ff.like((Expression)ff.property("st:Station/st:location/st:name"), "*fer*"));
        return filter;
    }
}

