/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.data.complex.config.SourceDataStore;
import org.geotools.data.complex.config.TypeMapping;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.type.Name;

public class AppSchemaDataAccessRegistryTest
extends AppSchemaTestSupport {
    public static final Logger LOGGER = Logging.getLogger(AppSchemaDataAccessRegistryTest.class);
    private static final String GSMLNS = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
    private static final Name MAPPED_FEATURE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeature");
    private static final Name GEOLOGIC_UNIT = Types.typeName((String)"myGeologicUnit");
    private static final Name COMPOSITION_PART = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CompositionPart");
    private static final Name CGI_TERM_VALUE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CGI_TermValue");
    private static final Name CONTROLLED_CONCEPT = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"ControlledConcept");
    private static final String schemaBase = "/test-data/";
    private static AppSchemaDataAccess guDataAccess;
    private static AppSchemaDataAccess cpDataAccess;
    private static AppSchemaDataAccess mfDataAccess;
    private static AppSchemaDataAccess cgiDataAccess;
    private static AppSchemaDataAccess ccDataAccess;
    private static TypeMapping dtoMappingName;
    private static TypeMapping dtoNoMappingName;
    private static AppSchemaDataAccessDTO config;

    @Test
    public void testRegisterAndUnregisterDataAccess() throws Exception {
        AppSchemaDataAccessRegistryTest.loadDataAccesses();
        this.checkRegisteredDataAccess(mfDataAccess, MAPPED_FEATURE, false);
        this.checkRegisteredDataAccess(guDataAccess, GEOLOGIC_UNIT, false);
        this.checkRegisteredDataAccess(cpDataAccess, COMPOSITION_PART, true);
        this.checkRegisteredDataAccess(cgiDataAccess, CGI_TERM_VALUE, true);
        this.checkRegisteredDataAccess(ccDataAccess, CONTROLLED_CONCEPT, true);
        this.unregister((DataAccess)mfDataAccess, MAPPED_FEATURE);
        this.unregister((DataAccess)guDataAccess, GEOLOGIC_UNIT);
        this.unregister((DataAccess)cpDataAccess, COMPOSITION_PART);
        this.unregister((DataAccess)cgiDataAccess, CGI_TERM_VALUE);
        this.unregister((DataAccess)ccDataAccess, CONTROLLED_CONCEPT);
    }

    @Test
    public void testThrowDataSourceException() throws Exception {
        Name typeName = Types.typeName((String)GSMLNS, (String)"DoesNotExist");
        boolean handledException = false;
        try {
            AppSchemaDataAccessRegistry.getMappingByElement((Name)typeName);
        }
        catch (DataSourceException e) {
            LOGGER.info(e.toString());
            handledException = true;
            Assert.assertTrue((boolean)e.getMessage().startsWith("Feature type " + typeName + " not found"));
        }
        Assert.assertTrue((String)"Expected a DataSourceException to have been thrown and handled", (boolean)handledException);
    }

    public static void loadDataAccesses() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = AppSchemaDataAccessRegistryTest.class.getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mfDataAccess = (AppSchemaDataAccess)DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        url = AppSchemaDataAccessRegistryTest.class.getResource("/test-data/GeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        guDataAccess = (AppSchemaDataAccess)DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)guDataAccess);
        cpDataAccess = (AppSchemaDataAccess)DataAccessRegistry.getDataAccess((Name)COMPOSITION_PART);
        Assert.assertNotNull((Object)cpDataAccess);
        cgiDataAccess = (AppSchemaDataAccess)DataAccessRegistry.getDataAccess((Name)CGI_TERM_VALUE);
        Assert.assertNotNull((Object)cgiDataAccess);
        ccDataAccess = (AppSchemaDataAccess)DataAccessRegistry.getDataAccess((Name)CONTROLLED_CONCEPT);
        Assert.assertNotNull((Object)ccDataAccess);
    }

    @BeforeClass
    public static void oneTimeSetUp() {
        String TARGET_ELEMENT_NAME = "gsml:MappedFeature";
        String MAPPING_NAME = "MAPPING_NAME_ONE";
        String SOURCE_ID = "MappedFeature";
        String MAPPING_FILE = "MappedFeaturePropertyfile";
        HashSet mappings = new HashSet();
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = AppSchemaDataAccessRegistryTest.class.getResource(schemaBase);
        Assert.assertNotNull((Object)url);
        final SourceDataStore ds = new SourceDataStore();
        ds.setId("MappedFeature");
        dsParams.put("directory", URLs.urlToFile((URL)url).getPath());
        ds.setParams(dsParams);
        config = new AppSchemaDataAccessDTO();
        config.setSourceDataStores((List)new ArrayList(){
            {
                this.add(ds);
            }
        });
        config.setBaseSchemasUrl(url.toExternalForm());
        config.setNamespaces((Map)new HashMap<String, String>(){
            {
                this.put("gsml", AppSchemaDataAccessRegistryTest.GSMLNS);
            }
        });
        config.setTargetSchemasUris((List)new ArrayList<String>(){
            {
                this.add("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd");
            }
        });
        config.setCatalog("mappedPolygons.oasis.xml");
        dtoMappingName = new TypeMapping();
        dtoMappingName.setMappingName("MAPPING_NAME_ONE");
        dtoMappingName.setSourceDataStore("MappedFeature");
        dtoMappingName.setSourceTypeName("MappedFeaturePropertyfile");
        dtoMappingName.setTargetElementName("gsml:MappedFeature");
        dtoNoMappingName = new TypeMapping();
        dtoNoMappingName.setSourceDataStore("MappedFeature");
        dtoNoMappingName.setSourceTypeName("MappedFeaturePropertyfile");
        dtoNoMappingName.setTargetElementName("gsml:MappedFeature");
    }

    private void checkRegisteredDataAccess(AppSchemaDataAccess dataAccess, Name typeName, boolean isNonFeature) throws IOException {
        FeatureTypeMapping mapping = AppSchemaDataAccessRegistry.getMappingByName((Name)typeName);
        Assert.assertNotNull((Object)mapping);
        Assert.assertEquals((Object)dataAccess.getMappingByName(typeName).equals(mapping), (Object)true);
        if (isNonFeature) {
            Assert.assertTrue((boolean)(mapping.getTargetFeature().getType() instanceof NonFeatureTypeProxy));
        }
        FeatureSource source = AppSchemaDataAccessRegistry.getMappingByName((Name)typeName).getSource();
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((Object)mapping.getSource(), (Object)source);
        FeatureSource mappedSource = DataAccessRegistry.getFeatureSource((Name)typeName);
        Assert.assertNotNull((Object)mappedSource);
        Assert.assertTrue((boolean)mappedSource.getDataStore().equals(dataAccess));
    }

    private void unregister(DataAccess dataAccess, Name typeName) throws IOException {
        dataAccess.dispose();
        boolean notFound = false;
        try {
            FeatureTypeMapping featureTypeMapping = AppSchemaDataAccessRegistry.getMappingByElement((Name)typeName);
        }
        catch (DataSourceException e) {
            notFound = true;
            Assert.assertTrue((boolean)e.getMessage().startsWith("Feature type " + typeName + " not found"));
        }
        if (!notFound) {
            Assert.fail((String)"Expecting DataSourceException but didn't occur. Deregistering data access fails.");
        }
        notFound = false;
        try {
            FeatureSource e = AppSchemaDataAccessRegistry.getSimpleFeatureSource((Name)typeName);
        }
        catch (DataSourceException e) {
            notFound = true;
            Assert.assertTrue((boolean)e.getMessage().startsWith("Feature type " + typeName + " not found"));
        }
        if (!notFound) {
            Assert.fail((String)"Expecting DataSourceException but didn't occur. Deregistering data access fails.");
        }
    }

    @Test
    public void testDuplicateKey() throws IOException {
        AppSchemaDataAccess e2;
        boolean threwException = false;
        HashSet<TypeMapping> mappings = new HashSet<TypeMapping>();
        TypeMapping duplicate = new TypeMapping();
        duplicate.setMappingName(dtoMappingName.getMappingName());
        duplicate.setSourceDataStore(dtoMappingName.getSourceDataStore());
        duplicate.setSourceTypeName(dtoMappingName.getSourceTypeName());
        duplicate.setTargetElementName(dtoMappingName.getTargetElementName());
        mappings.add(dtoMappingName);
        mappings.add(duplicate);
        config.setTypeMappings(mappings);
        try {
            AppSchemaDataAccess appSchemaDataAccess = new AppSchemaDataAccess(AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config));
        }
        catch (DataSourceException e2) {
            Assert.assertTrue((boolean)e2.getMessage().startsWith("Duplicate mappingName or targetElement across FeatureTypeMapping instances detected."));
            threwException = true;
        }
        Assert.assertTrue((boolean)threwException);
        threwException = false;
        duplicate = new TypeMapping();
        duplicate.setMappingName(dtoNoMappingName.getTargetElementName());
        duplicate.setSourceDataStore(dtoNoMappingName.getSourceDataStore());
        duplicate.setSourceTypeName(dtoNoMappingName.getSourceTypeName());
        duplicate.setTargetElementName(dtoNoMappingName.getTargetElementName());
        mappings.clear();
        mappings.add(duplicate);
        mappings.add(dtoNoMappingName);
        config.setTypeMappings(mappings);
        Assert.assertTrue((boolean)config.getTypeMappings().containsAll(mappings));
        try {
            e2 = new AppSchemaDataAccess(AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config));
        }
        catch (DataSourceException e3) {
            Assert.assertTrue((boolean)e3.getMessage().startsWith("Duplicate mappingName or targetElement across FeatureTypeMapping instances detected."));
            threwException = true;
        }
        Assert.assertTrue((boolean)threwException);
        threwException = false;
        duplicate = new TypeMapping();
        duplicate.setSourceDataStore(dtoNoMappingName.getSourceDataStore());
        duplicate.setSourceTypeName(dtoNoMappingName.getSourceTypeName());
        duplicate.setTargetElementName(dtoNoMappingName.getTargetElementName());
        mappings.clear();
        mappings.add(duplicate);
        mappings.add(dtoNoMappingName);
        config.setTypeMappings(mappings);
        Assert.assertTrue((boolean)config.getTypeMappings().containsAll(mappings));
        try {
            e2 = new AppSchemaDataAccess(AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config));
        }
        catch (DataSourceException e4) {
            Assert.assertTrue((boolean)e4.getMessage().startsWith("Duplicate mappingName or targetElement across FeatureTypeMapping instances detected."));
            threwException = true;
        }
        Assert.assertTrue((boolean)threwException);
    }

    @Test
    public void testUniqueKey() throws IOException {
        HashSet<TypeMapping> mappings = new HashSet<TypeMapping>();
        TypeMapping duplicate = new TypeMapping();
        duplicate.setMappingName(dtoMappingName.getTargetElementName());
        duplicate.setSourceDataStore(dtoMappingName.getSourceDataStore());
        duplicate.setSourceTypeName(dtoMappingName.getSourceTypeName());
        duplicate.setTargetElementName(dtoMappingName.getTargetElementName());
        mappings.add(dtoMappingName);
        mappings.add(duplicate);
        config.setTypeMappings(mappings);
        AppSchemaDataAccess da = new AppSchemaDataAccess(AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config));
        Assert.assertNotNull((Object)da);
        da.dispose();
        mappings.clear();
        mappings.add(dtoMappingName);
        mappings.add(dtoNoMappingName);
        config.setTypeMappings(mappings);
        Assert.assertTrue((boolean)config.getTypeMappings().containsAll(mappings));
        da = new AppSchemaDataAccess(AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config));
        Assert.assertNotNull((Object)da);
        da.dispose();
    }
}

