/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.complex.AttributeCreateOrderList;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class AttributeCreateOrderListTest
extends AppSchemaTestSupport {
    private static final String ROOT_LABEL = "root";
    private AttributeCreateOrderList at;
    private List<AttributeMapping> unProcessedList;

    @Test
    public void testEmptyTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<AttributeMapping>();
        this.processTestData();
    }

    @Test
    public void testSimpleTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<AttributeMapping>();
        this.createAttribute(ROOT_LABEL, "child1");
        this.createAttribute(ROOT_LABEL, "child2");
        this.createAttribute("child1", "grandChild1");
        this.createAttribute("child1", "grandChild2");
        this.createAttribute("child2", "grandChild3");
        this.processTestData();
    }

    @Test
    public void testComplexTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<AttributeMapping>();
        this.createAttribute(ROOT_LABEL, "child1");
        this.createAttribute(ROOT_LABEL, "child2");
        this.createAttribute(ROOT_LABEL, "child3");
        this.createAttribute("child1", "grandChild1");
        this.createAttribute("child1", "grandChild2");
        this.createAttribute("child2", "grandChild3");
        this.createAttribute("child2", "grandChild4");
        this.createAttribute("child2", "grandChild5");
        this.createAttribute("grandChild5", "greatGrandChild6");
        this.createAttribute("grandChild5", "greatGrandChild7");
        this.createAttribute("greatGrandChild7", "greatGreatGrandChild8");
        this.processTestData();
    }

    @Test
    public void testInvalidTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<AttributeMapping>();
        this.createAttribute(ROOT_LABEL, "child1");
        this.createAttribute(ROOT_LABEL, "child2");
        this.createAttribute("child1", "grandChild1");
        this.createAttribute("child1", "grandChild2");
        this.createAttribute("xxxx", "grandChild3");
        try {
            this.processTestData();
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidRootInTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<AttributeMapping>();
        try {
            this.createAttribute("child1", "child1");
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void processTestData() {
        int size = this.unProcessedList.size();
        Iterator it = this.at.iterator();
        HashSet<String> retrievedElements = new HashSet<String>();
        retrievedElements.add(ROOT_LABEL);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            AttributeMapping tam = (AttributeMapping)it.next();
            retrievedElements.add(tam.getLabel());
            if (tam.getLabel().equals(ROOT_LABEL)) continue;
            Assert.assertTrue((boolean)retrievedElements.contains(tam.getParentLabel()));
            this.unProcessedList.remove(tam);
        }
        Assert.assertEquals((long)count, (long)size);
        Assert.assertTrue((boolean)this.unProcessedList.isEmpty());
    }

    private void createAttribute(String parentlabel, String childLabel) {
        AttributeMapping tam = new AttributeMapping(null, null, null);
        tam.setParentLabel(parentlabel);
        tam.setLabel(childLabel);
        this.at.put(tam);
        this.unProcessedList.add(tam);
    }
}

