/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.geotools.data.complex.IndexesTest;
import org.geotools.data.complex.PartialIndexedMappingFeatureIterator;
import org.geotools.data.complex.TestFeatureSource;
import org.geotools.data.util.FeatureStreams;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class PartialIndexedMappingFeatureIteratorTest
extends IndexesTest {
    @Test
    public void testPartialInstance() throws IOException {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            FeatureCollection fcoll = fsource.getMappedSource().getFeatures(this.partialIndexedFilter_2idxfilterResults());
            FeatureIterator iterator = fcoll.features();
            Assert.assertTrue((boolean)(iterator instanceof PartialIndexedMappingFeatureIterator));
            List features = FeatureStreams.toFeatureStream((FeatureCollection)fcoll).collect(Collectors.toList());
            Assert.assertEquals((long)features.size(), (long)6L);
            Assert.assertEquals((Object)((Feature)features.get(0)).getIdentifier().getID(), (Object)"st.1");
            Assert.assertEquals((Object)((Feature)features.get(1)).getIdentifier().getID(), (Object)"st.2");
            Assert.assertEquals((Object)((Feature)features.get(2)).getIdentifier().getID(), (Object)"st.5");
            Assert.assertEquals((Object)((Feature)features.get(3)).getIdentifier().getID(), (Object)"st.6");
            Assert.assertEquals((Object)((Feature)features.get(4)).getIdentifier().getID(), (Object)"st.10");
            Assert.assertEquals((Object)((Feature)features.get(5)).getIdentifier().getID(), (Object)"st.11");
        }
    }

    @Override
    protected Filter partialIndexedFilter_2idxfilterResults() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Filter[] filterArray = new Filter[3];
        Objects.requireNonNull(this);
        PropertyIsEqualTo propertyIsEqualTo = ff.equals((Expression)ff.property("st:Station/st:name"), (Expression)ff.literal((Object)"station11"));
        Objects.requireNonNull(this);
        filterArray[0] = ff.or((Filter)propertyIsEqualTo, (Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.1")));
        filterArray[1] = ff.like((Expression)ff.property("st:Station/st:location/st:name"), "*America*");
        Objects.requireNonNull(this);
        PropertyIsEqualTo propertyIsEqualTo2 = ff.equals((Expression)ff.property("st:Station/st:name"), (Expression)ff.literal((Object)"station10"));
        Objects.requireNonNull(this);
        filterArray[2] = ff.or((Filter)propertyIsEqualTo2, (Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.2")));
        List<Filter> filters = Arrays.asList(filterArray);
        Or filter = ff.or(filters);
        return filter;
    }
}

