/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public class PropSelectionTest
extends AppSchemaTestSupport {
    private static final String schemaBase = "/test-data/";
    static final String GSMLNS = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
    static final String GMLNS = "http://www.opengis.net/gml";
    static final Name GEOLOGIC_UNIT = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"GeologicUnit");
    static final Name MAPPED_FEATURE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeature");
    private FeatureSource<FeatureType, Feature> mfSource;
    private FilterFactory2 ff;

    @Before
    public void setUp() throws Exception {
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", GSMLNS);
        namespaces.declarePrefix("gml", GMLNS);
        this.ff = new FilterFactoryImplNamespaceAware(namespaces);
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = PropSelectionTest.class.getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        url = PropSelectionTest.class.getResource("/test-data/GeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        dsParams = new HashMap();
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess guDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)guDataAccess);
        this.mfSource = mfDataAccess.getFeatureSource(MAPPED_FEATURE);
    }

    @Test
    public void testPropertyNameSelection() throws IOException {
        Feature feature;
        PropertyName propertyName1 = this.ff.property("gsml:specification/gsml:GeologicUnit/gml:description");
        PropertyName propertyName2 = this.ff.property("gsml:specification/gsml:GeologicUnit/gsml:occurrence");
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        properties.add(propertyName1);
        Query query = new Query();
        query.setProperties(properties);
        FeatureCollection mfCollection = this.mfSource.getFeatures(query);
        FeatureIterator iterator = mfCollection.features();
        int i = 0;
        while (iterator.hasNext()) {
            feature = iterator.next();
            Assert.assertNotNull((Object)propertyName1.evaluate((Object)feature));
            Assert.assertNull((Object)propertyName2.evaluate((Object)feature));
            ++i;
        }
        Assert.assertEquals((long)4L, (long)i);
        properties = new ArrayList();
        properties.add(propertyName2);
        query.setProperties(properties);
        mfCollection = this.mfSource.getFeatures(query);
        iterator = mfCollection.features();
        i = 0;
        while (iterator.hasNext()) {
            feature = iterator.next();
            Assert.assertNotNull((Object)propertyName2.evaluate((Object)feature));
            Assert.assertNull((Object)propertyName1.evaluate((Object)feature));
            ++i;
        }
        Assert.assertEquals((long)4L, (long)i);
    }
}

