/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.util.LinkedList;
import java.util.List;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.feature.type.UniqueNameFeatureTypeFactoryImpl;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.TypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public class TestData {
    public static final Name WATERSAMPLE_TYPENAME = Types.typeName((String)"wq_ir_results");

    private TestData() {
    }

    public static FeatureType createComplexWaterQualityType() {
        UniqueNameFeatureTypeFactoryImpl tfac = new UniqueNameFeatureTypeFactoryImpl();
        TypeBuilder builder = new TypeBuilder((FeatureTypeFactory)tfac);
        AttributeType detdesc = builder.name("determinand_description").bind(String.class).attribute();
        AttributeType result = builder.name("result").bind(Float.class).attribute();
        builder.setName("measurement");
        builder.addAttribute("determinand_description", detdesc);
        builder.addAttribute("result", result);
        ComplexType MEASUREMENT = builder.complex();
        AttributeType sitename = builder.name("sitename").bind(String.class).attribute();
        AttributeType anzlic_no = builder.name("anzlic_no").bind(String.class).attribute();
        AttributeType project_no = builder.name("project_no").bind(String.class).attribute();
        GeometryType location = builder.name("location").bind(Point.class).geometry();
        builder.setName("wq_plus");
        builder.addAttribute("sitename", sitename);
        builder.addAttribute("anzlic_no", anzlic_no);
        builder.addAttribute("project_no", project_no);
        builder.cardinality(0, Integer.MAX_VALUE);
        builder.addAttribute("measurement", (AttributeType)MEASUREMENT);
        builder.cardinality(1, 1);
        builder.addAttribute("location", (AttributeType)location);
        FeatureType wq_plusType = builder.feature();
        return wq_plusType;
    }

    public static FeatureType createComplexWaterSampleType() {
        UniqueNameFeatureTypeFactoryImpl tfac = new UniqueNameFeatureTypeFactoryImpl();
        TypeBuilder builder = new TypeBuilder((FeatureTypeFactory)tfac);
        AttributeType parameter = builder.name("parameter").bind(String.class).attribute();
        AttributeType value = builder.name("value").bind(Double.class).attribute();
        builder.setName("measurement");
        builder.addAttribute("parameter", parameter);
        builder.addAttribute("value", value);
        ComplexType MEASUREMENT = builder.complex();
        builder.setName("sample");
        builder.cardinality(0, Integer.MAX_VALUE);
        builder.addAttribute("measurement", (AttributeType)MEASUREMENT);
        FeatureType sampleType = builder.feature();
        return sampleType;
    }

    public static List createMappingsColumnsAndValues(AttributeDescriptor targetFeature) throws Exception {
        LinkedList<AttributeMapping> mappings = new LinkedList<AttributeMapping>();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Literal source = ff.literal((Object)"ph");
        String target = "sample/measurement[1]/parameter";
        NamespaceSupport namespaces = new NamespaceSupport();
        AttributeMapping attMapping = new AttributeMapping(null, (Expression)source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces));
        mappings.add(attMapping);
        source = ff.property("ph");
        target = "sample/measurement[1]/value";
        attMapping = new AttributeMapping(null, (Expression)source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces));
        mappings.add(attMapping);
        source = ff.literal((Object)"temp");
        target = "sample/measurement[2]/parameter";
        attMapping = new AttributeMapping(null, (Expression)source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces));
        mappings.add(attMapping);
        source = ff.property("temp");
        target = "sample/measurement[2]/value";
        attMapping = new AttributeMapping(null, (Expression)source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces));
        mappings.add(attMapping);
        source = ff.literal((Object)"turbidity");
        target = "sample/measurement[3]/parameter";
        attMapping = new AttributeMapping(null, (Expression)source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces));
        mappings.add(attMapping);
        source = ff.property("turbidity");
        target = "sample/measurement[3]/value";
        attMapping = new AttributeMapping(null, (Expression)source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces));
        mappings.add(attMapping);
        return mappings;
    }

    public static FeatureTypeMapping createMappingsGroupByStation(MemoryDataStore simpleStore) throws Exception {
        Name sourceTypeName = WATERSAMPLE_TYPENAME;
        SimpleFeatureSource wsSource = simpleStore.getFeatureSource(sourceTypeName);
        FeatureType targetType = TestData.createComplexWaterQualityType();
        UniqueNameFeatureTypeFactoryImpl tf = new UniqueNameFeatureTypeFactoryImpl();
        AttributeDescriptor targetFeature = tf.createAttributeDescriptor((AttributeType)targetType, targetType.getName(), 0, Integer.MAX_VALUE, true, null);
        LinkedList<AttributeMapping> mappings = new LinkedList<AttributeMapping>();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName id = ff.property("station_no");
        Expression source = Expression.NIL;
        String target = "wq_plus";
        NamespaceSupport namespaces = new NamespaceSupport();
        mappings.add(new AttributeMapping((Expression)id, source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces)));
        source = ff.property("sitename");
        target = "wq_plus/sitename";
        mappings.add(new AttributeMapping(null, source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces)));
        source = ff.property("anzlic_no");
        target = "wq_plus/anzlic_no";
        mappings.add(new AttributeMapping(null, source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces)));
        source = ff.property("project_no");
        target = "wq_plus/project_no";
        mappings.add(new AttributeMapping(null, source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces)));
        id = ff.property("id[1]");
        source = null;
        target = "wq_plus/measurement";
        mappings.add(new AttributeMapping((Expression)id, source, null, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces), null, true, null));
        source = ff.property("determinand_description");
        target = "wq_plus/measurement/determinand_description";
        mappings.add(new AttributeMapping(null, source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces)));
        source = ff.property("results_value");
        target = "wq_plus/measurement/result";
        mappings.add(new AttributeMapping(null, source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces)));
        source = ff.property("location");
        target = "wq_plus/location";
        mappings.add(new AttributeMapping(null, source, XPath.steps((AttributeDescriptor)targetFeature, (String)target, (NamespaceSupport)namespaces)));
        return new FeatureTypeMapping((FeatureSource)wsSource, targetFeature, mappings, namespaces);
    }

    public static MemoryDataStore createDenormalizedWaterQualityResults() throws Exception {
        MemoryDataStore dataStore = new MemoryDataStore();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(WATERSAMPLE_TYPENAME.getLocalPart());
        builder.add("station_no", String.class);
        builder.add("sitename", String.class);
        builder.add("anzlic_no", String.class);
        builder.add("project_no", String.class);
        builder.add("id", String.class);
        builder.add("sample_collection_date", String.class);
        builder.add("determinand_description", String.class);
        builder.add("results_value", Float.class);
        builder.add("location", Point.class);
        SimpleFeatureType type = builder.buildFeatureType();
        dataStore.createSchema(type);
        int NUM_STATIONS = 10;
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        for (int groupValue = 1; groupValue <= 10; ++groupValue) {
            for (int measurement = 1; measurement <= groupValue; ++measurement) {
                String fid = type.getName().getLocalPart() + "." + groupValue + "." + measurement;
                fb.add((Object)("station_no." + groupValue));
                fb.add((Object)("sitename" + groupValue));
                fb.add((Object)("anzlic_no" + groupValue));
                fb.add((Object)("project_no" + groupValue));
                String sufix = "_" + groupValue + "_" + measurement;
                fb.add((Object)("id" + sufix));
                fb.add((Object)("sample_collection_date" + sufix));
                fb.add((Object)("determinand_description" + sufix));
                fb.add((Object)Float.valueOf(groupValue + "." + measurement));
                fb.add((Object)gf.createPoint(new Coordinate((double)groupValue, (double)groupValue)));
                SimpleFeature f = fb.buildFeature(fid);
                dataStore.addFeature(f);
            }
        }
        return dataStore;
    }
}

