/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.appschema.resolver.xml.AppSchemaConfiguration;
import org.geotools.data.complex.config.AppSchemaFeatureTypeRegistry;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeImpl;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.EmfComplexFeatureReader;
import org.geotools.gml3.GML;
import org.geotools.gml3.complex.GmlFeatureTypeRegistryConfiguration;
import org.geotools.gml3.v3_2.GMLConfiguration;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.xml.resolver.SchemaCatalog;
import org.geotools.xml.resolver.SchemaResolver;
import org.geotools.xs.XS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;

public class EmfAppSchemaReaderTest
extends AppSchemaTestSupport {
    private static final String NS_URI = "http://online.socialchange.net.au";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseSimpleFeatureType() throws Exception {
        String res = "/test-data/simpleFeature.xsd";
        URL resource = this.getClass().getResource(res);
        SchemaIndex schemaIndex = EmfComplexFeatureReader.newInstance().parse(resource);
        AppSchemaFeatureTypeRegistry parsedTypes = new AppSchemaFeatureTypeRegistry();
        try {
            parsedTypes.addSchemas(schemaIndex);
            Name typeName = Types.typeName((String)NS_URI, (String)"simpleFeatureType");
            AttributeType type = parsedTypes.getAttributeType(typeName);
            Assert.assertNotNull((Object)type);
            Assert.assertTrue((String)type.getClass().getName(), (boolean)(type instanceof ComplexType));
            Assert.assertTrue((boolean)(type.getUserData().get(XSDTypeDefinition.class) instanceof XSDComplexTypeDefinition));
            ComplexType ft = (ComplexType)type;
            String local = ft.getName().getLocalPart();
            String uri = ft.getName().getNamespaceURI();
            Assert.assertEquals((Object)"simpleFeatureType", (Object)local);
            Assert.assertEquals((Object)NS_URI, (Object)uri);
            List<PropertyDescriptor> attributes = Arrays.asList(((ComplexFeatureTypeImpl)ft).getTypeDescriptors().toArray(new PropertyDescriptor[0]));
            Assert.assertEquals((long)8L, (long)attributes.size());
            AttributeDescriptor descriptor = (AttributeDescriptor)attributes.get(5);
            Name name = Types.typeName((String)NS_URI, (String)"the_geom");
            typeName = Types.typeName((String)"http://www.opengis.net/gml", (String)"GeometryPropertyType");
            this.assertSimpleAttribute(descriptor, name, typeName, Geometry.class, 1, 1);
            descriptor = (AttributeDescriptor)attributes.get(6);
            name = Types.typeName((String)NS_URI, (String)"stringAtt");
            typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.STRING.getLocalPart());
            this.assertSimpleAttribute(descriptor, name, typeName, String.class, 1, 1);
            descriptor = (AttributeDescriptor)attributes.get(7);
            name = Types.typeName((String)NS_URI, (String)"intAtt");
            typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.INT.getLocalPart());
            this.assertSimpleAttribute(descriptor, name, typeName, Integer.class, 1, 1);
        }
        finally {
            parsedTypes.disposeSchemaIndexes();
        }
    }

    private void assertSimpleAttribute(AttributeDescriptor descriptor, Name name, Name typeName, Class<?> binding, int minOccurs, int maxOccurs) {
        Assert.assertEquals((Object)name, (Object)descriptor.getName());
        Assert.assertEquals((long)minOccurs, (long)descriptor.getMinOccurs());
        Assert.assertEquals((long)maxOccurs, (long)descriptor.getMaxOccurs());
        Assert.assertTrue((boolean)(descriptor.getUserData().get(XSDElementDeclaration.class) instanceof XSDElementDeclaration));
        AttributeType type = descriptor.getType();
        Assert.assertNotNull((Object)type);
        Assert.assertFalse((boolean)(type instanceof ComplexType));
        Assert.assertEquals((Object)typeName, (Object)type.getName());
        Assert.assertEquals(binding, (Object)type.getBinding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplexFeatureType() throws Exception {
        String res = "/test-data/complexFeature.xsd";
        URL resource = this.getClass().getResource(res);
        SchemaIndex schemaIndex = EmfComplexFeatureReader.newInstance().parse(resource);
        AppSchemaFeatureTypeRegistry typeRegistry = new AppSchemaFeatureTypeRegistry();
        try {
            typeRegistry.addSchemas(schemaIndex);
            Name typeName = Types.typeName((String)NS_URI, (String)"wq_plus_Type");
            AttributeType type = typeRegistry.getAttributeType(typeName);
            Assert.assertTrue((boolean)(type instanceof FeatureType));
            Assert.assertFalse((boolean)(type instanceof SimpleFeatureType));
            Assert.assertEquals((Object)typeName, (Object)type.getName());
            Assert.assertTrue((boolean)(type.getUserData().get(XSDTypeDefinition.class) instanceof XSDComplexTypeDefinition));
            FeatureType wq_plus_Type = (FeatureType)type;
            Assert.assertNotNull((Object)wq_plus_Type.getSuper());
            typeName = Types.typeName((String)"http://www.opengis.net/gml", (String)GML.AbstractFeatureType.getLocalPart());
            Assert.assertEquals((Object)typeName, (Object)wq_plus_Type.getSuper().getName());
            Assert.assertNotNull((Object)wq_plus_Type.getDescriptors());
            Assert.assertEquals((long)8L, (long)((ComplexFeatureTypeImpl)wq_plus_Type).getTypeDescriptors().size());
            Name name = Types.typeName((String)NS_URI, (String)"wq_plus");
            AttributeDescriptor wqPlusDescriptor = typeRegistry.getDescriptor(name, null);
            Assert.assertNotNull((Object)wqPlusDescriptor);
            Assert.assertEquals((Object)name, (Object)wqPlusDescriptor.getName());
            Assert.assertSame((Object)wq_plus_Type, (Object)wqPlusDescriptor.getType());
            Assert.assertTrue((boolean)(wqPlusDescriptor.getUserData().get(XSDElementDeclaration.class) instanceof XSDElementDeclaration));
            typeName = Types.typeName((String)NS_URI, (String)"measurementType");
            type = typeRegistry.getAttributeType(typeName);
            Assert.assertTrue((boolean)(type instanceof ComplexType));
            Assert.assertFalse((boolean)(type instanceof FeatureType));
            Assert.assertTrue((boolean)(type.getUserData().get(XSDTypeDefinition.class) instanceof XSDComplexTypeDefinition));
            ComplexType measurementType = (ComplexType)type;
            Assert.assertEquals((Object)typeName, (Object)measurementType.getName());
            Assert.assertTrue((boolean)measurementType.isIdentified());
            Assert.assertFalse((boolean)measurementType.isAbstract());
            Assert.assertEquals((long)2L, (long)measurementType.getDescriptors().size());
            name = Types.typeName((String)NS_URI, (String)"measurement");
            AttributeDescriptor descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)wq_plus_Type, (Name)name);
            Assert.assertNotNull((Object)descriptor);
            Assert.assertEquals((Object)name, (Object)descriptor.getName());
            Assert.assertNotNull((Object)descriptor.getType());
            Assert.assertSame((Object)measurementType, (Object)descriptor.getType());
            Assert.assertEquals((long)0L, (long)descriptor.getMinOccurs());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)descriptor.getMaxOccurs());
            Assert.assertTrue((boolean)(descriptor.getUserData().get(XSDElementDeclaration.class) instanceof XSDElementDeclaration));
            name = Types.typeName((String)NS_URI, (String)"result");
            descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)measurementType, (Name)name);
            typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.FLOAT.getLocalPart());
            this.assertSimpleAttribute(descriptor, name, typeName, Float.class, 1, 1);
            name = Types.typeName((String)NS_URI, (String)"determinand_description");
            descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)measurementType, (Name)name);
            typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.STRING.getLocalPart());
            this.assertSimpleAttribute(descriptor, name, typeName, String.class, 1, 1);
            name = Types.typeName((String)NS_URI, (String)"the_geom");
            descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)wq_plus_Type, (Name)name);
            typeName = Types.typeName((String)"http://www.opengis.net/gml", (String)GML.PointPropertyType.getLocalPart());
            this.assertSimpleAttribute(descriptor, name, typeName, Point.class, 1, 1);
            name = Types.typeName((String)NS_URI, (String)"sitename");
            descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)wq_plus_Type, (Name)name);
            typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.STRING.getLocalPart());
            this.assertSimpleAttribute(descriptor, name, typeName, String.class, 1, Integer.MAX_VALUE);
        }
        finally {
            typeRegistry.disposeSchemaIndexes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleAttributeFromComplexDeclaration() throws Exception {
        String res = "/test-data/complexFeature.xsd";
        URL resource = this.getClass().getResource(res);
        SchemaIndex schemaIndex = EmfComplexFeatureReader.newInstance().parse(resource);
        AppSchemaFeatureTypeRegistry registry = new AppSchemaFeatureTypeRegistry();
        try {
            registry.addSchemas(schemaIndex);
            Name tcl = Types.typeName((String)NS_URI, (String)"TypedCategoryListType");
            AttributeType typedCategoryListType = registry.getAttributeType(tcl);
            Assert.assertNotNull((Object)typedCategoryListType);
            Assert.assertTrue((boolean)(typedCategoryListType instanceof ComplexType));
            AttributeType superType = typedCategoryListType.getSuper();
            Assert.assertNotNull((Object)superType);
            Name superName = superType.getName();
            Assert.assertEquals((Object)XS.STRING.getNamespaceURI(), (Object)superName.getNamespaceURI());
            Assert.assertEquals((Object)XS.STRING.getLocalPart(), (Object)superName.getLocalPart());
            Assert.assertNotNull(typedCategoryListType.getUserData().get(XSDTypeDefinition.class));
        }
        finally {
            registry.disposeSchemaIndexes();
        }
    }

    @Test
    public void findGml31Configuration() {
        AppSchemaConfiguration configuration = new AppSchemaConfiguration("urn:cgi:xmlns:CGI:GeoSciML:2.0", "http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", new SchemaResolver());
        Configuration gmlConfiguration = GmlFeatureTypeRegistryConfiguration.findGmlConfiguration((Configuration)configuration);
        Assert.assertNotNull((Object)gmlConfiguration);
        Assert.assertEquals((Object)new org.geotools.gml3.GMLConfiguration(), (Object)gmlConfiguration);
    }

    @Test
    public void findGml32Configuration() {
        AppSchemaConfiguration configuration = new AppSchemaConfiguration("urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0", "https://www.seegrid.csiro.au/subversion/GeoSciML/branches/3.0.0_rc1_gml3.2/geosciml-core/3.0.0/xsd/geosciml-core.xsd", new SchemaResolver());
        Configuration gmlConfiguration = GmlFeatureTypeRegistryConfiguration.findGmlConfiguration((Configuration)configuration);
        Assert.assertNotNull((Object)gmlConfiguration);
        Assert.assertEquals((Object)new GMLConfiguration(), (Object)gmlConfiguration);
    }

    @Test
    public void testNonGMLConfiguration() {
        SchemaCatalog catalog = SchemaCatalog.build((URL)this.getClass().getResource("/test-data/mappedPolygons.oasis.xml"));
        AppSchemaConfiguration configuration = new AppSchemaConfiguration("http://www.opengis.net/swe/2.0", "http://schemas.opengis.net/sweCommon/2.0/swe.xsd", new SchemaResolver(catalog));
        Configuration gmlConfiguration = GmlFeatureTypeRegistryConfiguration.findGmlConfiguration((Configuration)configuration);
        Assert.assertNull((Object)gmlConfiguration);
    }
}

