/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.geotools.data.complex.config.AppSchemaFeatureTypeRegistry;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.EmfComplexFeatureReader;
import org.geotools.gml3.GMLSchema;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.xsd.SchemaIndex;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyType;

public class XPathTest
extends AppSchemaTestSupport {
    private static final String COMPLEX_WITH_TEXT_CONTENT_SCHEMA_LOCATION = "/test-data/complexWithTextContent.xsd";
    private static final String URI = "http://www.geotools.org/appschema/test";
    private static EmfComplexFeatureReader reader;

    @BeforeClass
    public static void oneTimeSetUp() {
        reader = EmfComplexFeatureReader.newInstance();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    @Test
    public void testIsSimpleContentType() {
        Assert.assertTrue((boolean)Types.isSimpleContentType((PropertyType)GMLSchema.CODETYPE_TYPE));
        Assert.assertTrue((boolean)Types.isSimpleContentType((PropertyType)GMLSchema.MEASURETYPE_TYPE));
        Assert.assertFalse((boolean)Types.isSimpleContentType((PropertyType)GMLSchema.POINTTYPE_TYPE));
        Assert.assertFalse((boolean)Types.isSimpleContentType((PropertyType)GMLSchema.POINTPROPERTYTYPE_TYPE));
        Assert.assertFalse((boolean)Types.isSimpleContentType((PropertyType)GMLSchema.ABSTRACTFEATURETYPE_TYPE));
        Assert.assertFalse((boolean)Types.isSimpleContentType((PropertyType)GMLSchema.ABSTRACTFEATURECOLLECTIONTYPE_TYPE));
    }

    @Test
    public void testCanHaveTextContent() throws Exception {
        SchemaIndex schemaIndex = reader.parse(this.getClass().getResource(COMPLEX_WITH_TEXT_CONTENT_SCHEMA_LOCATION));
        XSDElementDeclaration unrestrictedElDecl = schemaIndex.getElementDeclaration(new QName(URI, "unrestrictedEl"));
        Assert.assertNotNull((Object)unrestrictedElDecl);
        XSDElementDeclaration restrictedElDecl = schemaIndex.getElementDeclaration(new QName(URI, "restrictedEl"));
        Assert.assertNotNull((Object)restrictedElDecl);
        AppSchemaFeatureTypeRegistry typeRegistry = new AppSchemaFeatureTypeRegistry();
        typeRegistry.addSchemas(schemaIndex);
        Name unrestrictedTypeName = Types.typeName((String)URI, (String)"UnrestrictedType");
        ComplexType unrestrictedType = (ComplexType)typeRegistry.getAttributeType(unrestrictedTypeName);
        Assert.assertNotNull((Object)unrestrictedType);
        Assert.assertTrue((boolean)Types.canHaveTextContent((PropertyType)unrestrictedType));
        Name restrictedTypeName = Types.typeName((String)URI, (String)"RestrictedType");
        ComplexType restrictedType = (ComplexType)typeRegistry.getAttributeType(restrictedTypeName);
        Assert.assertNotNull((Object)restrictedType);
        Assert.assertFalse((boolean)Types.canHaveTextContent((PropertyType)restrictedType));
    }
}

