/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

final class HttpStaticServer {
    private static final Logger LOGGER = Logging.getLogger(HttpStaticServer.class);
    private final Map<String, String> resources = new HashMap<String, String>();
    private final ServerConnector connector;
    private final Server server = new Server((ThreadPool)new QueuedThreadPool(7));

    HttpStaticServer() {
        this.connector = new ServerConnector(this.server);
        this.connector.setPort(0);
        this.server.setConnectors(new Connector[]{this.connector});
        this.server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                for (Map.Entry resource : HttpStaticServer.this.resources.entrySet()) {
                    if (target == null || !target.equalsIgnoreCase("/" + (String)resource.getKey())) continue;
                    response.setContentType("text/xml");
                    response.setStatus(200);
                    baseRequest.setHandled(true);
                    try (ByteArrayInputStream input = new ByteArrayInputStream(((String)resource.getValue()).getBytes());){
                        IOUtils.copy((InputStream)input, (OutputStream)response.getOutputStream());
                        return;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Error writing HTTP response.", exception);
                    }
                }
                response.setStatus(404);
                baseRequest.setHandled(true);
            }
        });
    }

    void putResource(String resourceName, String resourcePath) {
        try (InputStream input = this.getClass().getResourceAsStream(resourcePath);){
            if (input == null) {
                throw new RuntimeException(String.format("Resource '%s' with path '%s' not found.", resourceName, resourcePath));
            }
            String resource = IOUtils.toString((InputStream)input, (String)"UTF-8");
            String relativePath = URLs.urlToFile((URL)URLs.getParentUrl((URL)this.getClass().getResource(resourcePath))).getPath();
            resource = resource.replace("{relative}", relativePath);
            resource = resource.replace("{host}", this.getHost());
            resource = resource.replace("{port}", String.valueOf(this.getPort()));
            this.resources.put(resourceName, resource);
            LOGGER.info(String.format("Resource %s added.", this.buildUrl(resourceName)));
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error registering resource '%s' with path '%s'.", resourceName, resourcePath), exception);
        }
    }

    void start() {
        try {
            this.server.start();
            LOGGER.info(String.format("HTTP static server started '%s:%d'.", this.getHost(), this.getPort()));
        }
        catch (Exception exception) {
            throw new RuntimeException("Error starting the HTTP server.", exception);
        }
    }

    void stop() {
        try {
            this.server.stop();
            LOGGER.info("HTTP static server stopped.");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error stopping the HTTP server.", exception);
        }
    }

    String getHost() {
        String host = this.connector.getHost();
        if (host == null) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                throw new RuntimeException("Error get local host name.");
            }
        }
        return host;
    }

    int getPort() {
        int port = this.connector.getLocalPort();
        if (port < 0) {
            throw new RuntimeException("Server not started or stopped.");
        }
        return port;
    }

    String buildUrl(String resourceName) {
        return String.format("http://%s:%d/%s", this.getHost(), this.getPort(), resourceName);
    }

    void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException exception) {
            LOGGER.info("HTTP static server stop.");
            Thread.currentThread().interrupt();
        }
    }
}

