/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.complex.AbstractStationsTest;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ClientPropertiesNoDuplicatesTest
extends AbstractStationsTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ClientPropertiesNoDuplicatesTest.loadDataAccesses();
    }

    protected static void loadDataAccesses() throws Exception {
        measurementsDataAccess = ClientPropertiesNoDuplicatesTest.loadDataAccess("measurementsDefaultGeometry.xml");
        stationsDataAccess = ClientPropertiesNoDuplicatesTest.loadDataAccess("stationsDefaultGeometry.xml");
    }

    @Test
    public void testGMLEncodingProperties() throws IOException {
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_WITH_MEASUREMENTS_CODE_FEATURE);
        GMLConfiguration gml31Config = new GMLConfiguration();
        Encoder encoder = new Encoder((Configuration)gml31Config);
        Id filter = ff.id(new FeatureId[]{ff.featureId("st.1")});
        FeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)ClientPropertiesNoDuplicatesTest.size(fc));
        try (FeatureIterator it = fc.features();){
            Feature station1 = it.next();
            Assert.assertEquals((Object)"st.1", (Object)station1.getIdentifier().toString());
            Document dom = encoder.encodeAsDOM((Object)station1, GML.featureMember);
            List<Element> measurements = this.getElementsFromDocumentUsingXpath(dom, "//st:StationWithMeasurementCode/st:measurements");
            Assert.assertFalse((boolean)measurements.isEmpty());
            Assert.assertFalse((boolean)measurements.get(0).hasAttribute("codename"));
            measurements = this.getElementsFromDocumentUsingXpath(dom, "//st:StationWithMeasurementCode/st:measurements/ms:MeasurementCode");
            Assert.assertFalse((boolean)measurements.isEmpty());
            Assert.assertTrue((boolean)measurements.get(0).hasAttribute("codename"));
            Assert.assertFalse((boolean)measurements.get(0).hasAttribute("code"));
            List<Element> names = this.getElementsFromDocumentUsingXpath(dom, "//st:StationWithMeasurementCode/st:measurements/ms:MeasurementCode/ms:name");
            Assert.assertFalse((boolean)names.isEmpty());
            Assert.assertTrue((boolean)names.get(0).hasAttribute("code"));
        }
        catch (TransformerException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        STATIONS_SCHEMA_BASE = "/test-data/stations-nestednogml/";
    }
}

