/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter.expression;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.factory.Hints;

public class FormatDateTimezoneFunction
implements Function {
    public static final FunctionName NAME = new FunctionNameImpl("FormatDateTimezone", new String[]{"pattern", "date", "timezone"});
    private final Literal fallback;
    private final List<Expression> parameters;

    public FormatDateTimezoneFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public FormatDateTimezoneFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Hints.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        if (this.parameters.size() != 3) {
            throw new RuntimeException(this.getName() + ": wrong number of parameters (" + this.parameters.size() + " not 3)");
        }
        for (Expression p : this.parameters) {
            if (p.evaluate(object) != null) continue;
            return null;
        }
        String pattern = (String)this.parameters.get(0).evaluate(object, String.class);
        Date date = (Date)this.parameters.get(1).evaluate(object, Date.class);
        if (date == null) {
            throw new RuntimeException(this.getName() + ": could not parse date: " + (String)this.parameters.get(1).evaluate(object, String.class));
        }
        TimeZone timezone = TimeZone.getTimeZone((String)this.parameters.get(2).evaluate(object, String.class));
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(timezone);
        return (T)dateFormat.format(date);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public String getName() {
        return NAME.getName();
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }
}

