/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.DataUtilities;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.factory.CommonFactoryFinder;
import org.xml.sax.helpers.NamespaceSupport;

public final class IndexQueryUtils {
    private IndexQueryUtils() {
    }

    public static List<String> getAttributesOnSort(Query query) {
        ArrayList<String> result = new ArrayList<String>();
        if (query.getSortBy() == null) {
            return result;
        }
        for (int i = 0; i < query.getSortBy().length; ++i) {
            result.add(query.getSortBy()[i].getPropertyName().getPropertyName());
        }
        return result;
    }

    public static List<String> getAttributesOnFilter(Filter filter) {
        String[] attrs = DataUtilities.attributeNames((Filter)filter);
        return new ArrayList<String>(Arrays.asList(attrs));
    }

    public static boolean isExpressionEmpty(Expression expression) {
        return expression == null || Expression.NIL.equals(expression);
    }

    public static boolean equalsProperty(AttributeMapping mapping, String propertyName) {
        return IndexQueryUtils.equalsPropertyExpression(mapping.getSourceExpression(), propertyName) || IndexQueryUtils.equalsPropertyExpression(mapping.getIdentifierExpression(), propertyName);
    }

    public static boolean equalsXpath(FeatureTypeMapping mapping, AttributeMapping attMapping, String xpath) {
        XPathUtil.StepList simplifiedSteps = XPath.steps((AttributeDescriptor)mapping.getTargetFeature(), (String)xpath, (NamespaceSupport)mapping.getNamespaces());
        return Objects.equals(attMapping.getTargetXPath(), simplifiedSteps);
    }

    public static boolean equalsPropertyExpression(Expression expression, String propertyName) {
        if (IndexQueryUtils.isExpressionEmpty(expression)) {
            return false;
        }
        String[] name = DataUtilities.attributeNames((Expression)expression);
        if (name.length != 1) {
            return false;
        }
        return Objects.equals(name[0], propertyName);
    }

    public static boolean checkAllPropertiesIndexed(List<String> properties, FeatureTypeMapping mapping) {
        return !properties.stream().anyMatch(p -> mapping.getIndexAttributeName((String)p) == null);
    }

    public static Filter buildIdInExpressionOr(List<String> ids, FeatureTypeMapping mapping) {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        ArrayList idFilters = new ArrayList();
        ids.forEach(idStr -> idFilters.add(ff.equals((Expression)ff.property(mapping.getTargetFeature().getName().getLocalPart()), (Expression)ff.literal(idStr))));
        return ff.or(idFilters);
    }

    public static Filter buildIdInExpressionFunction(List<String> ids, FeatureTypeMapping mapping) {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        ArrayList<PropertyName> idExpressions = new ArrayList<PropertyName>();
        String rootXpath = XPath.rootElementSteps((AttributeDescriptor)mapping.getTargetFeature(), (NamespaceSupport)mapping.getNamespaces()).toString();
        idExpressions.add(ff.property(rootXpath));
        ids.forEach(idStr -> idExpressions.add((PropertyName)ff.literal(idStr)));
        return ff.equals((Expression)ff.function("in", idExpressions.toArray(new Expression[0])), (Expression)ff.literal(true));
    }

    public static Filter buildIdInExpression(List<String> ids, FeatureTypeMapping mapping) {
        return IndexQueryUtils.buildIdInExpressionFunction(ids, mapping);
    }

    public static AttributeMapping getIndexedAttribute(FeatureTypeMapping mapping, String xpath) {
        AttributeMapping atm = mapping.getAttributeMapping(xpath);
        if (atm != null && StringUtils.isNotEmpty((CharSequence)atm.getIndexField())) {
            return atm;
        }
        XPathUtil.StepList stepList = XPath.steps((AttributeDescriptor)mapping.getTargetFeature(), (String)xpath, (NamespaceSupport)mapping.getNamespaces());
        String relXpath = stepList.toString();
        for (NestedAttributeMapping nm : mapping.getNestedMappings()) {
            AttributeMapping at;
            String nestedXpath = nm.getTargetXPath().toString();
            if (!relXpath.startsWith(nestedXpath)) continue;
            String subXpath = relXpath.substring(nestedXpath.length() + 1, relXpath.length());
            FeatureTypeMapping ft = null;
            try {
                ft = nm.getFeatureTypeMapping(null);
            }
            catch (IOException e) {
                Logger.getLogger(IndexQueryUtils.class.getName()).log(Level.FINE, null, e);
            }
            if (ft == null || !StringUtils.isNotBlank((CharSequence)subXpath) || (at = IndexQueryUtils.getIndexedAttribute(ft, subXpath)) == null || !StringUtils.isNotBlank((CharSequence)at.getIndexField())) continue;
            return at;
        }
        return null;
    }
}

