/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.util.Collections;
import java.util.Map;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.complex.config.MultipleValue;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.util.Utilities;

public class AttributeMapping {
    private Expression identifierExpression;
    protected Expression sourceExpression;
    protected XPathUtil.StepList targetXPath;
    private boolean isMultiValued;
    private boolean encodeIfEmpty;
    private boolean isList;
    AttributeType targetNodeInstance;
    private Map<Name, Expression> clientProperties;
    private String label;
    private String parentLabel;
    private String instancePath;
    private String sourceIndex;
    private final MultipleValue multipleValue;
    private String indexField;

    public AttributeMapping(Expression idExpression, Expression sourceExpression, XPathUtil.StepList targetXPath) {
        this(idExpression, sourceExpression, null, targetXPath, null, false, null);
    }

    public AttributeMapping(Expression idExpression, Expression sourceExpression, String sourceIndex, XPathUtil.StepList targetXPath, AttributeType targetNodeInstance, boolean isMultiValued, Map<Name, Expression> clientProperties) {
        this(idExpression, sourceExpression, sourceIndex, targetXPath, targetNodeInstance, isMultiValued, clientProperties, null);
    }

    public AttributeMapping(Expression idExpression, Expression sourceExpression, String sourceIndex, XPathUtil.StepList targetXPath, AttributeType targetNodeInstance, boolean isMultiValued, Map<Name, Expression> clientProperties, MultipleValue multipleValue) {
        this(idExpression, sourceExpression, sourceIndex, targetXPath, targetNodeInstance, isMultiValued, clientProperties, multipleValue, null);
    }

    public AttributeMapping(Expression idExpression, Expression sourceExpression, String sourceIndex, XPathUtil.StepList targetXPath, AttributeType targetNodeInstance, boolean isMultiValued, Map<Name, Expression> clientProperties, MultipleValue multipleValue, String indexField) {
        this.identifierExpression = idExpression == null ? Expression.NIL : idExpression;
        this.sourceExpression = sourceExpression == null ? Expression.NIL : sourceExpression;
        this.isMultiValued = isMultiValued;
        if (this.sourceExpression == null) {
            this.sourceExpression = Expression.NIL;
        }
        this.sourceIndex = sourceIndex;
        this.targetXPath = targetXPath;
        this.targetNodeInstance = targetNodeInstance;
        this.clientProperties = clientProperties == null ? Collections.emptyMap() : clientProperties;
        this.multipleValue = multipleValue;
        if (multipleValue != null) {
            this.isMultiValued = true;
            this.sourceExpression = multipleValue;
        }
        this.indexField = indexField;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public boolean encodeIfEmpty() {
        return this.encodeIfEmpty;
    }

    public boolean isList() {
        return this.isList;
    }

    public Expression getSourceExpression() {
        return this.sourceExpression;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public XPathUtil.StepList getTargetXPath() {
        return this.targetXPath;
    }

    public AttributeType getTargetNodeInstance() {
        return this.targetNodeInstance;
    }

    public boolean isNestedAttribute() {
        return false;
    }

    public String getLabel() {
        return this.label;
    }

    public String getParentLabel() {
        return this.parentLabel;
    }

    public String getInstanceXpath() {
        return this.instancePath;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setParentLabel(String label) {
        this.parentLabel = label;
    }

    public void setInstanceXpath(String instancePath) {
        this.instancePath = instancePath;
    }

    public void setEncodeIfEmpty(boolean encodeIfEmpty) {
        this.encodeIfEmpty = encodeIfEmpty;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeMapping)) {
            return false;
        }
        AttributeMapping other = (AttributeMapping)o;
        return Utilities.equals((Object)this.identifierExpression, (Object)other.identifierExpression) && Utilities.equals((Object)this.sourceExpression, (Object)other.sourceExpression) && Utilities.equals((Object)this.targetXPath, (Object)other.targetXPath) && Utilities.equals((Object)this.targetNodeInstance, (Object)other.targetNodeInstance) && Utilities.equals((boolean)this.isList, (boolean)other.isList) && Utilities.equals((boolean)this.isMultiValued, (boolean)other.isMultiValued) && Utilities.equals(this.clientProperties, other.clientProperties) && Utilities.equals((Object)this.label, (Object)other.label) && Utilities.equals((Object)this.parentLabel, (Object)other.parentLabel);
    }

    public int hashCode() {
        return 37 * this.identifierExpression.hashCode() + 37 * this.sourceExpression.hashCode() ^ this.targetXPath.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AttributeMapping[");
        sb.append("sourceExpression='").append(this.sourceExpression).append("', targetXPath='").append(this.targetXPath);
        if (this.targetNodeInstance != null) {
            sb.append(", target instance type=").append(this.targetNodeInstance);
        }
        sb.append("']");
        return sb.toString();
    }

    public Map<Name, Expression> getClientProperties() {
        return this.clientProperties == null ? Collections.emptyMap() : this.clientProperties;
    }

    public Expression getIdentifierExpression() {
        return this.identifierExpression;
    }

    public void setIdentifierExpression(Expression identifierExpression) {
        this.identifierExpression = identifierExpression;
    }

    public MultipleValue getMultipleValue() {
        return this.multipleValue;
    }

    public String getIndexField() {
        return this.indexField;
    }

    public void setIndexField(String indexField) {
        this.indexField = indexField;
    }
}

