/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.appschema.filter.FilterFactoryImplReportInvalidProperty;
import org.geotools.data.DataUtilities;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.MultipleValue;
import org.geotools.data.complex.filter.MultipleValueExtractor;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.visitor.CapabilitiesFilterSplitter;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;

public final class JdbcMultipleValue
extends AttributeExpressionImpl
implements MultipleValue {
    private static AtomicInteger ID = new AtomicInteger(0);
    private final FilterFactory filterFactory = new FilterFactoryImplReportInvalidProperty();
    private String sourceColumn;
    private String targetTable;
    private String targetColumn;
    private Expression targetValue;
    private FeatureTypeMapping featureTypeMapping;
    private AttributeMapping attributeMapping;
    private String[] properties;
    private final String id = "mv_" + ID.incrementAndGet();

    public JdbcMultipleValue() {
        super((String)null);
    }

    public String getSourceColumn() {
        return this.sourceColumn;
    }

    public void setSourceColumn(String sourceColumn) {
        this.sourceColumn = sourceColumn;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getTargetColumn() {
        return this.targetColumn;
    }

    public void setTargetColumn(String targetColumn) {
        this.targetColumn = targetColumn;
    }

    public Expression getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String targetValue) {
        try {
            this.targetValue = AppSchemaDataAccessConfigurator.parseOgcCqlExpression(targetValue, this.filterFactory);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error parsing target value expression '%s'.", targetValue), exception);
        }
    }

    public FeatureTypeMapping getFeatureTypeMapping() {
        return this.featureTypeMapping;
    }

    @Override
    public void setFeatureTypeMapping(FeatureTypeMapping featureTypeMapping) {
        this.featureTypeMapping = featureTypeMapping;
    }

    public AttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    @Override
    public void setAttributeMapping(AttributeMapping attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    public String[] getProperties() {
        if (this.properties == null) {
            ArrayList<String> propertiesList = new ArrayList<String>();
            String[] attributesProperties = DataUtilities.attributeNames((Expression)this.getTargetValue());
            propertiesList.addAll(Arrays.asList(attributesProperties));
            propertiesList.add(this.targetColumn);
            for (Map.Entry<Name, Expression> entry : this.attributeMapping.getClientProperties().entrySet()) {
                String[] clientProperties = DataUtilities.attributeNames((Expression)entry.getValue());
                propertiesList.addAll(Arrays.asList(clientProperties));
            }
            this.properties = propertiesList.toArray(new String[propertiesList.size()]);
        }
        return this.properties;
    }

    @Override
    public List<Object> getValues(Feature features, AttributeMapping attributeMapping) {
        throw new RuntimeException("Explicitly handled in App-Schema");
    }

    public Object evaluate(Object object) {
        return null;
    }

    public <T> T evaluate(Object object, Class<T> context) {
        return null;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        if (visitor instanceof PostPreProcessFilterSplittingVisitor || visitor instanceof CapabilitiesFilterSplitter || visitor instanceof MultipleValueExtractor) {
            return visitor.visit((PropertyName)this, null);
        }
        return this.targetValue.accept(visitor, extraData);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JdbcMultipleValue that = (JdbcMultipleValue)o;
        return Objects.equals(this.sourceColumn, that.sourceColumn) && Objects.equals(this.targetTable, that.targetTable) && Objects.equals(this.targetColumn, that.targetColumn) && Objects.equals(this.targetValue, that.targetValue);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceColumn, this.targetTable, this.targetColumn, this.targetValue);
    }

    public String toString() {
        return this.targetValue.toString();
    }
}

