/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.complex.config.AttributeMapping;
import org.geotools.util.CheckedArrayList;
import org.geotools.util.logging.Logging;

public class TypeMapping
implements Serializable {
    private static final Logger LOGGER = Logging.getLogger(TypeMapping.class);
    private static final long serialVersionUID = 1444252634598922057L;
    private String sourceDataStore;
    private String sourceTypeName;
    private String indexDataStore;
    private String indexTypeName;
    private String itemXpath;
    private boolean isXmlDataStore;
    private boolean isDenormalised = true;
    private boolean isDenormalisedSet = false;
    private String targetElementName;
    private String defaultGeometryXPath;
    private List<AttributeMapping> attributeMappings = Collections.emptyList();
    private String mappingName;

    public List<AttributeMapping> getAttributeMappings() {
        return new ArrayList<AttributeMapping>(this.attributeMappings);
    }

    public void setAttributeMappings(List<AttributeMapping> attributeMappings) {
        this.attributeMappings = new CheckedArrayList(AttributeMapping.class);
        if (attributeMappings != null) {
            this.attributeMappings.addAll(attributeMappings);
        }
    }

    public String getSourceDataStore() {
        return this.sourceDataStore;
    }

    public void setSourceDataStore(String sourceDataStore) {
        this.sourceDataStore = sourceDataStore;
    }

    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getTargetElementName() {
        return this.targetElementName;
    }

    public void setTargetElementName(String targetElementName) {
        this.targetElementName = targetElementName;
    }

    public String getDefaultGeometryXPath() {
        return this.defaultGeometryXPath;
    }

    public void setDefaultGeometryXPath(String defaultGeometryXPath) {
        this.defaultGeometryXPath = defaultGeometryXPath;
    }

    public String getItemXpath() {
        return this.itemXpath;
    }

    public void setItemXpath(String itemXpath) {
        this.itemXpath = itemXpath;
    }

    public void setXmlDataStore(String isXmlDataStore) {
        this.isXmlDataStore = Boolean.parseBoolean(isXmlDataStore);
    }

    public boolean isXmlDataStore() {
        return this.isXmlDataStore;
    }

    public boolean isDenormalised() {
        if (!this.isDenormalisedSet) {
            LOGGER.info("isDenormalised is not set in app-schema mapping file for: " + (this.mappingName == null ? this.targetElementName : this.mappingName) + ".\nSetting isDenormalised can result in more efficient SQL queries.");
        }
        return this.isDenormalised;
    }

    public void setIsDenormalised(String isDenormalised) {
        this.isDenormalisedSet = true;
        this.isDenormalised = Boolean.parseBoolean(isDenormalised);
    }

    public void setMappingName(String mappingName) {
        this.mappingName = mappingName;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public String getIndexDataStore() {
        return this.indexDataStore;
    }

    public void setIndexDataStore(String indexDataStore) {
        this.indexDataStore = indexDataStore;
    }

    public String getIndexTypeName() {
        return this.indexTypeName;
    }

    public void setIndexTypeName(String indexTypeName) {
        this.indexTypeName = indexTypeName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TypeMappingDTO[");
        if (this.mappingName != null) {
            sb.append("mappingName=").append(this.mappingName).append(",\n ");
        }
        sb.append("sourceDataStore=").append(this.sourceDataStore).append(",\n sourceTypeName=").append(this.sourceTypeName).append(",\n targetElementName=").append(this.targetElementName).append(",\n attributeMappings=").append(this.attributeMappings).append("]");
        return sb.toString();
    }
}

