/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.appschema.filter.BBoxTest;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class ArithmeticFilterTest
extends AppSchemaTestSupport {
    private static FilterFactoryImpl ff;
    private static DataAccess<FeatureType, Feature> dataAccess;
    private static FeatureSource<FeatureType, Feature> fSource;

    @BeforeClass
    public static void onetimeSetUp() throws Exception {
        String GSML_URI = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        ff = new FilterFactoryImplNamespaceAware(namespaces);
        Name FEATURE_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeature");
        String schemaBase = "/test-data/";
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        URL url = BBoxTest.class.getResource("/test-data/MappedFeatureAsOccurrence.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        dataAccess = DataAccessFinder.getDataStore(dsParams);
        fSource = dataAccess.getFeatureSource(FEATURE_TYPE);
    }

    @Test
    public void testWithArithmeticOperator() throws IOException {
        PropertyIsEqualTo arithmeticMultiplyFilter = ff.equals((Expression)ff.multiply((Expression)ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(2)), (Expression)ff.literal(400));
        PropertyIsEqualTo arithmeticDivideFilter = ff.equals((Expression)ff.divide((Expression)ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(2)), (Expression)ff.literal(100));
        PropertyIsEqualTo arithmeticAdditionFilter = ff.equals((Expression)ff.add((Expression)ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(100)), (Expression)ff.literal(300));
        PropertyIsEqualTo arithmeticSubtractionFilter = ff.equals((Expression)ff.subtract((Expression)ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(100)), (Expression)ff.literal(100));
        FeatureCollection features = fSource.getFeatures();
        PropertyName positionalAccuracy = ff.property("gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue");
        try (FeatureIterator iterator = features.features();){
            Feature f = iterator.next();
            Assert.assertTrue((boolean)(positionalAccuracy.evaluate((Object)f) instanceof Property));
            Assert.assertTrue((boolean)arithmeticMultiplyFilter.evaluate((Object)f));
            Assert.assertTrue((boolean)arithmeticDivideFilter.evaluate((Object)f));
            Assert.assertTrue((boolean)arithmeticAdditionFilter.evaluate((Object)f));
            Assert.assertTrue((boolean)arithmeticSubtractionFilter.evaluate((Object)f));
        }
    }
}

