/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.geotools.appschema.util.InterpolationProperties;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InterpolationPropertiesTest
extends AppSchemaTestSupport {
    public static final String IDENTIFIER = "interpolation-properties-test";
    public static final String TEST_PROPERTY = "interpolation-properties-test.test.property";
    public static final String TEST_SYSTEM_PROPERTY = "interpolation-properties-test.test.system.property";
    public static final String TEST_SYSTEM_PROPERTY_VALUE = "system";
    public static final String TEST_FILE_SYSTEM_PROPERTY = "interpolation-properties-test-file-identifier.properties";

    @Before
    public void setUp() throws Exception {
        System.setProperty(TEST_SYSTEM_PROPERTY, TEST_SYSTEM_PROPERTY_VALUE);
        System.setProperty(TEST_FILE_SYSTEM_PROPERTY, URLs.urlToFile((URL)InterpolationProperties.class.getResource("/interpolation-properties-test.file.properties")).getPath());
    }

    @Test
    public void testInterpolate() {
        Properties properties = new Properties();
        properties.put("foo.x", "123");
        properties.put("foo.y", "abc");
        properties.put("foo.z", "bar");
        InterpolationProperties props = new InterpolationProperties(properties);
        String result = props.interpolate("123ajh${foo.z} akl ${foo.y}${foo.y} laskj ${foo.x}\nfoo.x${foo.x}${foo.x} ${foo.z}${foo.y}");
        Assert.assertEquals((Object)"123ajhbar akl abcabc laskj 123\nfoo.x123123 barabc", (Object)result);
    }

    @Test
    public void testInterpolateNonexistent() {
        boolean interpolatedNonexistentProperty = false;
        try {
            InterpolationProperties props = new InterpolationProperties(new Properties());
            props.interpolate("123 ${does.not.exist} 456");
            interpolatedNonexistentProperty = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)interpolatedNonexistentProperty);
    }

    @Test
    public void testLoadPropertiesFromClasspath() {
        InterpolationProperties props = new InterpolationProperties(IDENTIFIER);
        Assert.assertEquals((Object)"found-on-classpath", (Object)props.getProperty(TEST_PROPERTY));
        this.checkSystemProperties(props);
    }

    @Test
    public void testLoadPropertiesDoesNotExist() {
        InterpolationProperties props = new InterpolationProperties("interpolation-properties-test.does-not-exist");
        Assert.assertNull((Object)props.getProperty(TEST_PROPERTY));
        this.checkSystemProperties(props);
    }

    @Test
    public void testLoadPropertiesFromFile() {
        InterpolationProperties props = new InterpolationProperties(TEST_FILE_SYSTEM_PROPERTY.replace(".properties", ""));
        Assert.assertEquals((Object)"found-in-file", (Object)props.getProperty(TEST_PROPERTY));
        this.checkSystemProperties(props);
    }

    private void checkSystemProperties(InterpolationProperties properties) {
        Assert.assertNotNull((Object)properties.getProperty(TEST_SYSTEM_PROPERTY));
        Assert.assertEquals((Object)properties.getProperty(TEST_SYSTEM_PROPERTY), (Object)TEST_SYSTEM_PROPERTY_VALUE);
        Assert.assertNotNull((Object)properties.getProperty("java.version"));
        Assert.assertNotEquals((Object)"should-be-overridden", (Object)properties.getProperty("java.version"));
    }

    @Test
    public void testReadAll() {
        String s = "line one\nline two\n";
        ByteArrayInputStream input = new ByteArrayInputStream("line one\nline two\n".getBytes());
        Assert.assertEquals((Object)s, (Object)InterpolationProperties.readAll((InputStream)input));
    }
}

