/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.complex.IndexesTest;
import org.geotools.data.complex.TestFeatureSource;
import org.geotools.data.complex.TotalIndexedMappingFeatureIterator;
import org.geotools.data.util.FeatureStreams;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.Assert;
import org.junit.Test;

public class TotalIndexedMappingFeatureIteratorTest
extends IndexesTest {
    @Test
    public void testTotalInstance() throws IOException {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            FeatureCollection fcoll = fsource.getMappedSource().getFeatures(this.totalIndexedFilterCase());
            try (FeatureIterator iterator = fcoll.features();){
                Assert.assertTrue((boolean)(iterator instanceof TotalIndexedMappingFeatureIterator));
                List<Feature> features = FeatureStreams.toFeatureStream((FeatureCollection)fcoll).collect(Collectors.toList());
                Assert.assertEquals((long)features.size(), (long)4L);
                Assert.assertTrue((boolean)this.checkExists(features, "st.1"));
                Assert.assertTrue((boolean)this.checkExists(features, "st.2"));
                Assert.assertTrue((boolean)this.checkExists(features, "st.10"));
                Assert.assertTrue((boolean)this.checkExists(features, "st.11"));
            }
        }
    }

    @Test
    public void testGetFid() throws IOException {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            FeatureCollection fcoll = fsource.getMappedSource().getFeatures(this.totalIndexedFilterCase());
            try (FeatureIterator iterator = fcoll.features();){
                Assert.assertTrue((boolean)(iterator instanceof TotalIndexedMappingFeatureIterator));
                TotalIndexedMappingFeatureIterator titer = (TotalIndexedMappingFeatureIterator)iterator;
                Assert.assertEquals((Object)"ID", (Object)titer.getFidAttrMap().getIndexField());
            }
        }
    }

    private Filter totalIndexedFilterCase() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Filter[] filterArray = new Filter[2];
        Objects.requireNonNull(this);
        PropertyIsEqualTo propertyIsEqualTo = ff.equals((Expression)ff.property("st:Station/st:name"), (Expression)ff.literal((Object)"station11"));
        Objects.requireNonNull(this);
        filterArray[0] = ff.or((Filter)propertyIsEqualTo, (Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.1")));
        Objects.requireNonNull(this);
        PropertyIsEqualTo propertyIsEqualTo2 = ff.equals((Expression)ff.property("st:Station/st:name"), (Expression)ff.literal((Object)"station10"));
        Objects.requireNonNull(this);
        filterArray[1] = ff.or((Filter)propertyIsEqualTo2, (Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.2")));
        List<Filter> filters = Arrays.asList(filterArray);
        Or filter = ff.or(filters);
        return filter;
    }

    private boolean checkExists(List<Feature> features, String id) {
        for (Feature feature : features) {
            if (!feature.getIdentifier().getID().equals(id)) continue;
            return true;
        }
        return false;
    }
}

