/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.complex.TestFeatureSource;
import org.geotools.data.complex.filter.IndexedFilterDetectorVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class IndexedFilterDetectorVisitorTest
extends AppSchemaTestSupport {
    @Test
    public void testPartialIndexedFilter() {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            IndexedFilterDetectorVisitor visitor = new IndexedFilterDetectorVisitor(fsource.getMappedSource().getMapping());
            Filter filter = this.partialIndexedFilter();
            filter.accept((FilterVisitor)visitor, null);
            Assert.assertEquals(visitor.getIndexedFilters().get(0), (Object)this.totallyIndexedFilter());
            Assert.assertEquals((Object)visitor.getParentLogicOperator(), (Object)this.partialIndexedFilter());
        }
    }

    @Test
    public void testPartialIndexedFilter_with2idxSubfilters() {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            IndexedFilterDetectorVisitor visitor = new IndexedFilterDetectorVisitor(fsource.getMappedSource().getMapping());
            Filter filter = this.partialIndexedFilter_2idxfilterResults();
            filter.accept((FilterVisitor)visitor, null);
            Assert.assertEquals((long)2L, (long)visitor.getIndexedFilters().size());
            Assert.assertEquals((Object)visitor.getParentLogicOperator(), (Object)this.partialIndexedFilter_2idxfilterResults());
        }
    }

    private Filter partialIndexedFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        And filter = ff.and(this.totallyIndexedFilter(), (Filter)ff.like((Expression)ff.property("st:location/st:name"), "*fer*"));
        return filter;
    }

    private Filter totallyIndexedFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Or filter = ff.or((Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.1")), (Filter)ff.like((Expression)ff.property("st:Station/st:name"), "*fer*"));
        return filter;
    }

    private Filter totallyIndexedFilter2() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Or filter = ff.or((Filter)ff.equals((Expression)ff.property("st:Station/st:name"), (Expression)ff.literal((Object)"fer")), (Filter)ff.like((Expression)ff.property("st:Station/st:name"), "*mariela*"));
        return filter;
    }

    private Filter partialIndexedFilter_2idxfilterResults() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        List<Filter> filters = Arrays.asList(this.totallyIndexedFilter(), ff.like((Expression)ff.property("st:location/st:name"), "*fer*"), this.totallyIndexedFilter2());
        And filter = ff.and(filters);
        return filter;
    }
}

