/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.appschema.filter.NestedAttributeExpression;
import org.geotools.appschema.jdbc.JdbcMultipleValueEncoder;
import org.geotools.appschema.jdbc.JoiningJDBCFeatureSource;
import org.geotools.appschema.jdbc.NamespaceAwareAttributeRenameVisitor;
import org.geotools.appschema.jdbc.WrappedFilterToSql;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.JdbcMultipleValue;
import org.geotools.data.complex.filter.FeatureChainedAttributeVisitor;
import org.geotools.data.complex.filter.UnmappingFilterVisitor;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.util.factory.Hints;
import org.xml.sax.helpers.NamespaceSupport;

public class NestedFilterToSQL
extends FilterToSQL {
    FeatureTypeMapping rootMapping;
    FilterToSQL original;
    FilterFactory ff;
    private boolean rootBinaryOperator = true;
    private String selectClause;
    private boolean replaceOrWithUnion = false;

    public NestedFilterToSQL(FeatureTypeMapping rootMapping, FilterToSQL original) {
        this.rootMapping = rootMapping;
        this.original = original;
        this.ff = new FilterFactoryImplNamespaceAware(rootMapping.getNamespaces());
    }

    public void encode(Filter filter) throws FilterToSQLException {
        if (this.out == null) {
            throw new FilterToSQLException("Can't encode to a null writer.");
        }
        this.original.setWriter(this.out);
        JdbcMultipleValueEncoder encoder = new JdbcMultipleValueEncoder(this.rootMapping, this.out);
        filter = (Filter)filter.accept((FilterVisitor)encoder, null);
        if (this.original.getCapabilities().fullySupports(filter)) {
            try {
                if (!this.inline) {
                    this.out.write("WHERE ");
                }
                filter.accept((FilterVisitor)this, null);
            }
            catch (IOException ioe) {
                throw new FilterToSQLException("Problem writing filter: ", (Throwable)ioe);
            }
        } else {
            throw new FilterToSQLException("Filter type not supported");
        }
    }

    private void encodeMultipleValueJoin(FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor nestedAttribute, JDBCDataStore store, StringBuffer sql) {
        FeatureTypeMapping featureMapping = nestedAttribute.getFeatureTypeOwningAttribute();
        AttributeMapping mapping = featureMapping.getAttributeMapping(nestedAttribute.getAttributePath());
        if (mapping == null || !mapping.isMultiValued() || !(mapping.getMultipleValue() instanceof JdbcMultipleValue)) {
            return;
        }
        JdbcMultipleValue multipleValue = (JdbcMultipleValue)mapping.getMultipleValue();
        sql.append(" LEFT JOIN ");
        String alias = String.valueOf(multipleValue.getId());
        try {
            store.encodeAliasedTableName(multipleValue.getTargetTable(), sql, null, alias);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        sql.append(" ON ");
        store.dialect.encodeColumnName(null, nestedAttribute.getLastLink().getAlias(), sql);
        sql.append(".");
        store.dialect.encodeColumnName(null, multipleValue.getSourceColumn(), sql);
        sql.append(" = ");
        store.dialect.encodeTableName(alias, sql);
        sql.append(".");
        store.dialect.encodeColumnName(null, multipleValue.getTargetColumn(), sql);
        sql.append(" ");
    }

    protected Object visitNestedFilter(Filter filter, Object extraData, String xpath) {
        try {
            FeatureChainedAttributeVisitor nestedMappingsExtractor = new FeatureChainedAttributeVisitor(this.rootMapping);
            nestedMappingsExtractor.visit(this.ff.property(xpath), null);
            List<FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor> attributes = nestedMappingsExtractor.getFeatureChainedAttributes();
            if (!attributes.isEmpty()) {
                if (attributes.size() > 1) {
                    this.out.write("(");
                }
                boolean first = true;
                for (FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor nestedAttrDescr : attributes) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.write(" OR ");
                    }
                    this.encodeChainedAttribute(filter, xpath, nestedAttrDescr);
                }
                if (attributes.size() > 1) {
                    this.out.write(")");
                }
            }
            return extraData;
        }
        catch (IOException | SQLException | FilterToSQLException ioe) {
            throw new RuntimeException("Problem writing filter: ", ioe);
        }
    }

    private void encodeChainedAttribute(Filter filter, String xpath, FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor nestedAttrDescr) throws IOException, SQLException, FilterToSQLException {
        int numMappings = nestedAttrDescr.chainSize();
        if (numMappings > 0 && nestedAttrDescr.isJoiningEnabled()) {
            this.out.write("EXISTS (");
            FeatureChainedAttributeVisitor.FeatureChainLink lastMappingStep = nestedAttrDescr.getLastLink();
            StringBuffer sql = this.encodeSelectKeyFrom(lastMappingStep);
            JDBCDataStore store = (JDBCDataStore)lastMappingStep.getFeatureTypeMapping().getSource().getDataStore();
            this.encodeMultipleValueJoin(nestedAttrDescr, store, sql);
            for (int i = numMappings - 2; i > 0; --i) {
                FeatureChainedAttributeVisitor.FeatureChainLink mappingStep = nestedAttrDescr.getLink(i);
                if (!mappingStep.hasNestedFeature()) continue;
                FeatureTypeMapping parentFeature = mappingStep.getFeatureTypeMapping();
                store = (JDBCDataStore)parentFeature.getSource().getDataStore();
                String parentTableName = parentFeature.getSource().getSchema().getName().getLocalPart();
                sql.append(" INNER JOIN ");
                store.encodeTableName(parentTableName, sql, null);
                sql.append(" ");
                store.dialect.encodeTableName(mappingStep.getAlias(), sql);
                sql.append(" ON ");
                this.encodeJoinCondition(nestedAttrDescr, i, sql);
            }
            if (nestedAttrDescr.getAttributePath() != null) {
                this.createWhereClause(filter, xpath, nestedAttrDescr, sql);
                sql.append(" AND ");
            } else {
                sql.append(" WHERE ");
            }
            this.encodeJoinCondition(nestedAttrDescr, 0, sql);
            this.out.write(sql.toString());
            this.out.write(")");
        }
    }

    private void encodeJoinCondition(FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor nestedAttrDescr, int stepIdx, StringBuffer sql) throws SQLException, IOException, FilterToSQLException {
        FeatureChainedAttributeVisitor.FeatureChainLink parentStep = nestedAttrDescr.getLink(stepIdx);
        FeatureChainedAttributeVisitor.FeatureChainLink nestedStep = nestedAttrDescr.getLink(stepIdx + 1);
        FeatureTypeMapping parentFeature = parentStep.getFeatureTypeMapping();
        JDBCDataStore store = (JDBCDataStore)parentFeature.getSource().getDataStore();
        NestedAttributeMapping nestedFeatureAttr = parentStep.getNestedFeatureAttribute();
        FeatureTypeMapping nestedFeature = nestedFeatureAttr.getFeatureTypeMapping(null);
        String parentTableName = parentFeature.getSource().getSchema().getName().getLocalPart();
        String parentTableAlias = parentStep.getAlias();
        WrappedFilterToSql parentToSQL = this.createFilterToSQL(parentFeature);
        parentToSQL.setSqlNameEscape("");
        Expression parentExpression = nestedFeatureAttr.getSourceExpression();
        String parentTableColumn = parentToSQL.encodeToString(parentExpression);
        String nestedTableAlias = nestedStep.getAlias();
        WrappedFilterToSql nestedFilterToSQL = this.createFilterToSQL(parentFeature);
        nestedFilterToSQL.setSqlNameEscape("");
        Expression nestedExpr = nestedFeatureAttr.getMapping(nestedFeature).getSourceExpression();
        String nestedTableColumn = nestedFilterToSQL.encodeToString(nestedExpr);
        if (stepIdx == 0) {
            this.encodeColumnName(store, parentTableColumn, parentTableName, sql, null);
        } else {
            this.encodeAliasedColumnName(store, parentTableColumn, parentTableAlias, sql, null);
        }
        sql.append(" = ");
        this.encodeAliasedColumnName(store, nestedTableColumn, nestedTableAlias, sql, null);
    }

    private StringBuffer encodeSelectKeyFrom(FeatureChainedAttributeVisitor.FeatureChainLink lastMappingStep) throws SQLException {
        FeatureTypeMapping lastTypeMapping = lastMappingStep.getFeatureTypeMapping();
        JDBCDataStore store = (JDBCDataStore)lastTypeMapping.getSource().getDataStore();
        SimpleFeatureType lastType = (SimpleFeatureType)lastTypeMapping.getSource().getSchema();
        PrimaryKey key = null;
        try {
            key = store.getPrimaryKey(lastType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        StringBuffer sqlKeys = new StringBuffer();
        for (PrimaryKeyColumn col : key.getColumns()) {
            String colName = col.getName();
            sqlKeys.append(",");
            this.encodeAliasedColumnName(store, colName, lastMappingStep.getAlias(), sqlKeys, null);
        }
        if (sqlKeys.length() <= 0) {
            sql.append("*");
        } else {
            sql.append(sqlKeys.substring(1));
        }
        sql.append(" FROM ");
        store.encodeTableName(lastType.getTypeName(), sql, null);
        sql.append(" ");
        store.dialect.encodeTableName(lastMappingStep.getAlias(), sql);
        return sql;
    }

    private void createWhereClause(Filter filter, String nestedProperty, FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor nestedAttrDescr, StringBuffer sql) throws FilterToSQLException {
        FeatureChainedAttributeVisitor.FeatureChainLink lastLink = nestedAttrDescr.getLastLink();
        String simpleProperty = nestedAttrDescr.getAttributePath().toString();
        FeatureTypeMapping featureMapping = lastLink.getFeatureTypeMapping();
        JDBCDataStore store = (JDBCDataStore)featureMapping.getSource().getDataStore();
        FeatureTypeMapping featureMappingForUnrolling = nestedAttrDescr.getFeatureTypeOwningAttribute();
        NamespaceAwareAttributeRenameVisitor duplicate = new NamespaceAwareAttributeRenameVisitor(nestedProperty, simpleProperty);
        Filter duplicated = (Filter)filter.accept((FilterVisitor)duplicate, null);
        Filter unrolled = this.unrollFilter(duplicated, featureMappingForUnrolling);
        JoiningJDBCFeatureSource.JoiningFieldEncoder fieldEncoder = new JoiningJDBCFeatureSource.JoiningFieldEncoder(lastLink.getAlias(), store);
        WrappedFilterToSql filterToSQL = this.createFilterToSQL(featureMapping);
        filterToSQL.setFieldEncoder(fieldEncoder);
        String encodedFilter = filterToSQL.encodeToString(unrolled);
        sql.append(" ").append(encodedFilter);
    }

    private WrappedFilterToSql createFilterToSQL(FeatureTypeMapping featureMapping) {
        JDBCDataStore store = (JDBCDataStore)featureMapping.getSource().getDataStore();
        SimpleFeatureType sourceType = (SimpleFeatureType)featureMapping.getSource().getSchema();
        FilterToSQL filterToSQL = null;
        if (store.getSQLDialect() instanceof PreparedStatementSQLDialect) {
            PreparedFilterToSQL preparedFilterToSQL = store.createPreparedFilterToSQL(sourceType);
            preparedFilterToSQL.setPrepareEnabled(false);
            filterToSQL = preparedFilterToSQL;
        } else {
            filterToSQL = store.createFilterToSQL(sourceType);
        }
        return new WrappedFilterToSql(featureMapping, filterToSQL);
    }

    private void encodeColumnName(JDBCDataStore store, String colName, String typeName, StringBuffer sql, Hints hints) throws SQLException {
        store.encodeTableName(typeName, sql, hints);
        sql.append(".");
        store.dialect.encodeColumnName(null, colName, sql);
    }

    private void encodeAliasedColumnName(JDBCDataStore store, String colName, String typeName, StringBuffer sql, Hints hints) throws SQLException {
        store.dialect.encodeTableName(typeName, sql);
        sql.append(".");
        store.dialect.encodeColumnName(null, colName, sql);
    }

    public Object visit(BBOX filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Contains filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Touches filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Intersects filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Overlaps filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Within filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Crosses filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Disjoint filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Equals filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Beyond filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(Or filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"OR");
    }

    protected Object visit(BinaryLogicOperator filter, Object extraData) {
        String operator = (String)extraData;
        if (!this.replaceOrWithUnion || "AND".equalsIgnoreCase(operator) || this.selectClause == null || !this.rootBinaryOperator) {
            this.rootBinaryOperator = false;
            return super.visit(filter, extraData);
        }
        if ("OR".equalsIgnoreCase(operator)) {
            this.rootBinaryOperator = false;
            try {
                Iterator list = filter.getChildren().iterator();
                while (list.hasNext()) {
                    ((Filter)list.next()).accept((FilterVisitor)this, extraData);
                    if (!list.hasNext()) continue;
                    this.out.write(" UNION " + this.selectClause + " ");
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("io problem writing filter", ioe);
            }
        }
        return extraData;
    }

    public Object visit(DWithin filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsBetween filter, Object extraData) throws RuntimeException {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public Object visit(PropertyIsNull filter, Object extraData) throws RuntimeException {
        NestedAttributeExpression nestedAttr = this.getNestedAttributeExpression(filter);
        if (nestedAttr == null) {
            return this.original.visit(filter, extraData);
        }
        return this.visitNestedFilter((Filter)filter, extraData, nestedAttr.getPropertyName());
    }

    public static boolean isNestedFilter(Filter filter) {
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        filter.accept((FilterVisitor)extractor, null);
        return NestedFilterToSQL.hasNestedAttributes(extractor.getPropertyNameSet());
    }

    private static boolean hasNestedAttributes(Set<PropertyName> propertyNames) {
        for (PropertyName property : propertyNames) {
            if (!(property instanceof NestedAttributeExpression)) continue;
            return true;
        }
        return false;
    }

    private <T extends Filter> NestedAttributeExpression getNestedAttributeExpression(T filter) {
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        filter.accept((FilterVisitor)extractor, null);
        Set propertyNames = extractor.getPropertyNameSet();
        for (PropertyName property : propertyNames) {
            if (!(property instanceof NestedAttributeExpression)) continue;
            return (NestedAttributeExpression)property;
        }
        return null;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    private Filter unrollFilter(Filter complexFilter, FeatureTypeMapping mappings) {
        UnmappingFilterVisitorExcludingNestedMappings visitor = new UnmappingFilterVisitorExcludingNestedMappings(mappings);
        Filter unrolledFilter = (Filter)complexFilter.accept((FilterVisitor)visitor, null);
        return unrolledFilter;
    }

    public boolean isReplaceOrWithUnion() {
        return this.replaceOrWithUnion;
    }

    public void setReplaceOrWithUnion(boolean replaceOrWithUnion) {
        this.replaceOrWithUnion = replaceOrWithUnion;
    }

    private class UnmappingFilterVisitorExcludingNestedMappings
    extends UnmappingFilterVisitor {
        public UnmappingFilterVisitorExcludingNestedMappings(FeatureTypeMapping mappings) {
            super(mappings);
        }

        @Override
        public List<Expression> visit(PropertyName expr, Object arg1) {
            String targetXPath = expr.getPropertyName();
            NamespaceSupport namespaces = this.mappings.getNamespaces();
            AttributeDescriptor root = this.mappings.getTargetFeature();
            XPathUtil.StepList simplifiedSteps = XPath.steps((AttributeDescriptor)root, (String)targetXPath, (NamespaceSupport)namespaces);
            List<Expression> matchingMappings = this.mappings.findMappingsFor(simplifiedSteps, false);
            if (matchingMappings.isEmpty()) {
                throw new IllegalArgumentException("Can't find source expression for: " + targetXPath);
            }
            return matchingMappings;
        }
    }
}

