/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Repository;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.appschema.util.InterpolationProperties;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class DataAccessRegistry
implements Repository {
    private static final long serialVersionUID = -373404928035022963L;
    private static final Logger LOGGER = Logging.getLogger(DataAccessRegistry.class);
    protected static volatile DataAccessRegistry theRegistry = null;
    protected InterpolationProperties properties = null;
    protected List<DataAccess<FeatureType, Feature>> registry = new ArrayList<DataAccess<FeatureType, Feature>>();

    protected DataAccessRegistry() {
    }

    public static DataAccessRegistry getInstance() {
        if (theRegistry == null) {
            theRegistry = new DataAccessRegistry();
        }
        return theRegistry;
    }

    public synchronized FeatureSource<FeatureType, Feature> featureSource(Name name) throws IOException {
        for (DataAccess<FeatureType, Feature> dataAccess : this.registry) {
            if (!dataAccess.getNames().contains(name)) continue;
            if (dataAccess instanceof AppSchemaDataAccess) {
                return ((AppSchemaDataAccess)dataAccess).getFeatureSourceByName(name);
            }
            return dataAccess.getFeatureSource(name);
        }
        this.throwDataSourceException(name);
        return null;
    }

    public synchronized DataAccess<FeatureType, Feature> access(Name name) {
        try {
            return this.featureSource(name).getDataStore();
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataStore dataStore(Name name) {
        throw new UnsupportedOperationException("Simple feature DataStores not supported by app-schema registry.");
    }

    public List<DataStore> getDataStores() {
        throw new UnsupportedOperationException("Simple feature DataStores not supported by app-schema registry.");
    }

    public synchronized void registerAccess(DataAccess<FeatureType, Feature> dataAccess) {
        this.registry.add(dataAccess);
    }

    public synchronized void unregisterAccess(DataAccess<FeatureType, Feature> dataAccess) {
        this.registry.remove(dataAccess);
        if (dataAccess instanceof AppSchemaDataAccess) {
            AppSchemaDataAccess asda = (AppSchemaDataAccess)dataAccess;
            if (!asda.hidden && asda.url != null) {
                try {
                    this.disposeHiddenDataAccessInstances(asda.url);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Exception occurred disposing unused data access instances", e);
                }
            }
        }
    }

    private void disposeHiddenDataAccessInstances(URL url) throws IOException {
        ArrayList<DataAccess<FeatureType, Feature>> copyRegistry = new ArrayList<DataAccess<FeatureType, Feature>>(this.registry);
        for (DataAccess dataAccess : copyRegistry) {
            if (!(dataAccess instanceof AppSchemaDataAccess)) continue;
            AppSchemaDataAccess asda = (AppSchemaDataAccess)dataAccess;
            if (!asda.hidden || asda.parentUrl == null || !asda.parentUrl.equals(url)) continue;
            asda.dispose();
        }
    }

    public synchronized void disposeAndUnregisterAll() {
        ArrayList<DataAccess<FeatureType, Feature>> copyRegistry = new ArrayList<DataAccess<FeatureType, Feature>>(this.registry);
        for (DataAccess dataAccess : copyRegistry) {
            dataAccess.dispose();
        }
        this.registry.clear();
    }

    public synchronized boolean hasAccessName(Name name) throws IOException {
        for (DataAccess<FeatureType, Feature> dataAccess : this.registry) {
            if (!dataAccess.getNames().contains(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasAppSchemaAccessName(Name name) throws IOException {
        for (DataAccess<FeatureType, Feature> dataAccess : this.registry) {
            if (!(dataAccess instanceof AppSchemaDataAccess) || !((AppSchemaDataAccess)dataAccess).hasName(name) && !((AppSchemaDataAccess)dataAccess).hasElement(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized FeatureTypeMapping mappingByName(Name name) throws IOException {
        for (DataAccess<FeatureType, Feature> dataAccess : this.registry) {
            if (!(dataAccess instanceof AppSchemaDataAccess) || !((AppSchemaDataAccess)dataAccess).hasName(name)) continue;
            return ((AppSchemaDataAccess)dataAccess).getMappingByName(name);
        }
        this.throwDataSourceException(name);
        return null;
    }

    public synchronized FeatureTypeMapping mappingByElement(Name name) throws IOException {
        for (DataAccess<FeatureType, Feature> dataAccess : this.registry) {
            if (!(dataAccess instanceof AppSchemaDataAccess) || !((AppSchemaDataAccess)dataAccess).hasElement(name)) continue;
            return ((AppSchemaDataAccess)dataAccess).getMappingByNameOrElement(name);
        }
        this.throwDataSourceException(name);
        return null;
    }

    public synchronized boolean hasAppSchemaTargetElement(Name name) throws IOException {
        for (DataAccess<FeatureType, Feature> dataAccess : this.registry) {
            if (!(dataAccess instanceof AppSchemaDataAccess) || !Arrays.asList(((AppSchemaDataAccess)dataAccess).getTypeNames()).contains(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized InterpolationProperties getProperties() {
        if (this.properties == null) {
            this.properties = new InterpolationProperties("app-schema");
        }
        return this.properties;
    }

    public synchronized void clearProperties() {
        this.properties = null;
    }

    public static FeatureSource<FeatureType, Feature> getFeatureSource(Name featureTypeName) throws IOException {
        return DataAccessRegistry.getInstance().featureSource(featureTypeName);
    }

    public static DataAccess<FeatureType, Feature> getDataAccess(Name featureTypeName) throws IOException {
        return DataAccessRegistry.getInstance().featureSource(featureTypeName).getDataStore();
    }

    public static void register(DataAccess<FeatureType, Feature> dataAccess) {
        DataAccessRegistry.getInstance().registerAccess(dataAccess);
    }

    public static void unregister(DataAccess<FeatureType, Feature> dataAccess) {
        DataAccessRegistry.getInstance().unregisterAccess(dataAccess);
    }

    public static void unregisterAndDisposeAll() {
        DataAccessRegistry.getInstance().disposeAndUnregisterAll();
    }

    public static boolean hasName(Name featureTypeName) throws IOException {
        return DataAccessRegistry.getInstance().hasAccessName(featureTypeName);
    }

    protected void throwDataSourceException(Name featureTypeName) throws IOException {
        ArrayList typeNames = new ArrayList();
        for (DataAccess<FeatureType, Feature> featureTypeFeatureDataAccess : this.registry) {
            typeNames.addAll(featureTypeFeatureDataAccess.getNames());
        }
        throw new DataSourceException("Feature type " + featureTypeName + " not found. Has the data access been registered in DataAccessRegistry? Available: " + ((Object)typeNames).toString());
    }

    public Feature findFeature(FeatureId id, Hints hints) throws IOException {
        for (DataAccess<FeatureType, Feature> dataAccess : this.registry) {
            Feature feature;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            if (!(dataAccess instanceof AppSchemaDataAccess) || (feature = ((AppSchemaDataAccess)dataAccess).findFeature(id, hints)) == null) continue;
            return feature;
        }
        return null;
    }
}

