/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Consumer;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.visitor.UniqueVisitor;

public interface IndexIdIterator
extends Iterator<String>,
Closeable {

    public static class IndexUniqueVisitorIterator
    implements IndexIdIterator {
        protected static final int STEP_LOAD = 1000;
        public static Consumer<UniqueVisitor> uniqueVisitorBuildHook;
        private FeatureCollection<SimpleFeatureType, SimpleFeature> fc;
        private Query idQuery;
        private String idFieldName;
        private int start;
        private int max;
        private UniqueVisitor visitor;
        private Iterator visitorIterator;
        private int currentVisitorStart;
        private int currentMax;
        private String nextValue = null;
        private int counter = 0;

        public IndexUniqueVisitorIterator(FeatureCollection<SimpleFeatureType, SimpleFeature> fc, Query idQuery, String idFieldName) {
            this.fc = fc;
            this.idQuery = idQuery;
            this.idFieldName = idFieldName;
            this.start = idQuery.getStartIndex() != null ? idQuery.getStartIndex() : 0;
            this.max = idQuery.getMaxFeatures();
            this.currentVisitorStart = this.start;
            this.currentMax = this.max;
            this.initVisitor();
        }

        private void initVisitor() {
            this.visitor = new UniqueVisitor(new String[]{this.idFieldName});
            this.visitor.setStartIndex(this.currentVisitorStart);
            this.visitor.setMaxFeatures(Math.min(1000, this.currentMax));
            if (uniqueVisitorBuildHook != null) {
                uniqueVisitorBuildHook.accept(this.visitor);
            }
            try {
                this.fc.accepts((FeatureVisitor)this.visitor, (ProgressListener)new NullProgressListener());
                this.visitorIterator = this.visitor.getUnique().iterator();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String getNextFromVisitor() {
            if (this.counter >= this.idQuery.getMaxFeatures()) {
                return null;
            }
            if (this.visitorIterator.hasNext()) {
                ++this.counter;
                return (String)this.visitorIterator.next();
            }
            int nextStart = this.currentVisitorStart + 1000;
            if (nextStart <= this.start + this.max - 1) {
                this.currentVisitorStart = nextStart;
                this.currentMax -= 1000;
                this.initVisitor();
                if (!this.visitorIterator.hasNext()) {
                    return null;
                }
                ++this.counter;
                return (String)this.visitorIterator.next();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != null) {
                return true;
            }
            this.nextValue = this.getNextFromVisitor();
            return this.nextValue != null;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                String value = this.nextValue;
                this.nextValue = null;
                return value;
            }
            return null;
        }

        @Override
        public void close() {
        }
    }

    public static class IndexFeatureIdIterator
    implements IndexIdIterator {
        private FeatureIterator<? extends Feature> indexIterator;

        public IndexFeatureIdIterator(FeatureIterator<? extends Feature> indexIterator) {
            this.indexIterator = indexIterator;
        }

        @Override
        public boolean hasNext() {
            return this.indexIterator.hasNext();
        }

        @Override
        public String next() {
            return this.simplifyIndentifier(this.indexIterator.next());
        }

        @Override
        public void close() {
            this.indexIterator.close();
        }

        protected String simplifyIndentifier(Feature feature) {
            String schemaPart = feature.getType().getName().getLocalPart() + ".";
            String fid = feature.getIdentifier().getID();
            if (fid.startsWith(schemaPart)) {
                return fid.substring(schemaPart.length());
            }
            return fid;
        }
    }
}

