/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.util.List;
import java.util.stream.Collectors;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.appschema.util.IndexQueryUtils;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.IndexCombinedFilterTransformerVisitor;
import org.geotools.data.complex.filter.SchemaIndexedFilterDetectorVisitor;
import org.geotools.data.util.FeatureStreams;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Filters;

public class IndexQueryManager {
    protected final FeatureTypeMapping mapping;
    protected final Query query;
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    public IndexQueryManager(FeatureTypeMapping mapping, Query query) {
        this.mapping = mapping;
        this.query = query;
    }

    public boolean isIndexDrivenIteratorCase() {
        return !this.getIndexMode().equals((Object)QueryIndexCoverage.NONE);
    }

    public QueryIndexCoverage getIndexMode() {
        if (this.query.equals((Object)Query.ALL) || this.query.equals((Object)Query.FIDS) || this.query.getFilter().equals(Filter.INCLUDE)) {
            return QueryIndexCoverage.NONE;
        }
        List<String> filterAttributes = IndexQueryUtils.getAttributesOnFilter(this.query.getFilter());
        int filterMatchCount = (int)filterAttributes.stream().filter(attr -> this.hasIndex((String)attr)).count();
        List<String> sortAttributes = IndexQueryUtils.getAttributesOnSort(this.query);
        int sortMatchCount = (int)sortAttributes.stream().filter(attr -> this.hasIndex((String)attr)).count();
        if (filterAttributes.size() == filterMatchCount && sortAttributes.size() == sortMatchCount) {
            return QueryIndexCoverage.ALL;
        }
        if (filterMatchCount > 0 && sortAttributes.size() == sortMatchCount) {
            return QueryIndexCoverage.PARTIAL;
        }
        return QueryIndexCoverage.NONE;
    }

    protected boolean hasIndex(String propertyName) {
        return this.mapping.getIndexAttributeName(propertyName) != null;
    }

    public static class PartialIndexQueryManager
    extends IndexQueryManager {
        private BinaryLogicOperator indexedParentLogicOperator;
        private List<Filter> indexedFilters;
        private Query indexQuery;

        public PartialIndexQueryManager(FeatureTypeMapping mapping, Query query) {
            super(mapping, query);
            this.initDetection();
        }

        protected void initDetection() {
            SchemaIndexedFilterDetectorVisitor visitor = new SchemaIndexedFilterDetectorVisitor(this.mapping);
            this.query.getFilter().accept((FilterVisitor)visitor, null);
            this.indexedParentLogicOperator = visitor.getParentLogicOperator();
            this.indexedFilters = visitor.getIndexedFilters();
            this.buildIndexQuery();
        }

        private void buildIndexQuery() {
            Query idsQuery = new Query(this.query);
            idsQuery.setFilter(this.buildIndexFilter());
            idsQuery.setProperties(Query.NO_PROPERTIES);
            this.indexQuery = idsQuery;
        }

        private Filter buildIndexFilter() {
            List<Filter> dupFilters = this.duplicateFilters(this.indexedFilters);
            BinaryLogicOperator indexFilter = this.createLogicOperator(this.indexedParentLogicOperator, dupFilters);
            return indexFilter;
        }

        private BinaryLogicOperator createLogicOperator(BinaryLogicOperator originalOperator, List<Filter> filters) {
            if (originalOperator instanceof Or) {
                return this.ff.or(filters);
            }
            return this.ff.and(filters);
        }

        private List<Filter> duplicateFilters(List<Filter> filterList) {
            Filters filtersUtil = new Filters();
            return filterList.stream().map(f -> filtersUtil.duplicate(f)).collect(Collectors.toList());
        }

        public Query getIndexQuery() {
            return this.indexQuery;
        }

        public Query buildCombinedQuery(FeatureCollection<? extends FeatureType, ? extends Feature> featureCollection) {
            List<String> ids = FeatureStreams.toFeatureStream(featureCollection).map(Feature::getIdentifier).map(FeatureId::getID).collect(Collectors.toList());
            Filter filter1 = this.buildCombinedFilter(ids);
            Query query1 = new Query(this.query);
            query1.setFilter(filter1);
            return query1;
        }

        public Query buildCombinedQuery(List<String> ids) {
            Filter filter1 = this.buildCombinedFilter(ids);
            Query query1 = new Query(this.query);
            query1.setFilter(filter1);
            return query1;
        }

        private Filter buildCombinedFilter(List<String> ids) {
            Filter idsIn = IndexQueryUtils.buildIdInExpression(ids, this.mapping);
            IndexCombinedFilterTransformerVisitor visitor = new IndexCombinedFilterTransformerVisitor(this.indexedParentLogicOperator, this.indexedFilters, idsIn);
            Filter resultFilter = (Filter)this.query.getFilter().accept((FilterVisitor)visitor, (Object)this.ff);
            return resultFilter;
        }
    }

    public static enum QueryIndexCoverage {
        ALL,
        NONE,
        PARTIAL;

    }
}

