/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.appschema.filter.FilterFactoryImplReportInvalidProperty;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.FeatureTypeMappingFactory;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.AppSchemaFeatureTypeRegistry;
import org.geotools.data.complex.config.DataAccessMap;
import org.geotools.data.complex.config.JdbcMultipleValue;
import org.geotools.data.complex.config.MultipleValue;
import org.geotools.data.complex.config.SourceDataStore;
import org.geotools.data.complex.config.TypeMapping;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.data.complex.expression.FeaturePropertyAccessorFactory;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.spi.CustomImplementationsFinder;
import org.geotools.data.complex.spi.CustomSourceDataStore;
import org.geotools.data.complex.util.EmfComplexFeatureReader;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.complex.xml.XmlFeatureSource;
import org.geotools.data.joining.JoiningNestedAttributeMapping;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JoinPropertyName;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.geotools.xml.resolver.SchemaCache;
import org.geotools.xml.resolver.SchemaCatalog;
import org.geotools.xml.resolver.SchemaResolver;
import org.geotools.xsd.SchemaIndex;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaDataAccessConfigurator {
    private static final Logger LOGGER = Logging.getLogger(AppSchemaDataAccessConfigurator.class);
    public static String PROPERTY_JOINING = "app-schema.joining";
    public static String PROPERTY_ENCODE_NESTED_FILTERS = "app-schema.encodeNestedFilters";
    public static final String PROPERTY_REPLACE_OR_UNION = "app-schema.orUnionReplace";
    private boolean isInclude = false;
    private AppSchemaDataAccessDTO config;
    private AppSchemaFeatureTypeRegistry typeRegistry;
    private DataAccessMap dataStoreMap;
    private FilterFactory ff = new FilterFactoryImplReportInvalidProperty();
    private NamespaceSupport namespaces;
    private Map<String, String> schemaURIs;
    private static final List<String> SAFE_DATASTORE_PARAMS = List.of("url", "directory", "namespace", "dbtype", "jndiReferenceName", "host", "port", "database", "schema", "user");

    public static boolean isJoining() {
        String s = AppSchemaDataAccessRegistry.getAppSchemaProperties().getProperty(PROPERTY_JOINING);
        return s == null || s.equalsIgnoreCase("true");
    }

    public static boolean isJoiningSet() {
        String s = AppSchemaDataAccessRegistry.getAppSchemaProperties().getProperty(PROPERTY_JOINING);
        return s != null;
    }

    public static boolean isOrUnionReplacementEnabled() {
        String orUnionReplacement = AppSchemaDataAccessRegistry.getAppSchemaProperties().getProperty(PROPERTY_REPLACE_OR_UNION);
        return !"false".equalsIgnoreCase(orUnionReplacement);
    }

    public static boolean shouldEncodeNestedFilters() {
        String propValue = AppSchemaDataAccessRegistry.getAppSchemaProperties().getProperty(PROPERTY_ENCODE_NESTED_FILTERS);
        return propValue == null || propValue.equalsIgnoreCase("true");
    }

    private AppSchemaDataAccessConfigurator(AppSchemaDataAccessDTO config, DataAccessMap dataStoreMap, boolean isInclude) {
        this.config = config;
        this.dataStoreMap = dataStoreMap;
        this.isInclude = isInclude;
        this.namespaces = new NamespaceSupport();
        this.declareNamespaces(config);
    }

    private void declareNamespaces(AppSchemaDataAccessDTO config) {
        Map<String, String> nsMap = config.getNamespaces();
        Iterator<Map.Entry<String, String>> iterator = nsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> o;
            Map.Entry<String, String> entry = o = iterator.next();
            String prefix = entry.getKey();
            String namespace = entry.getValue();
            this.namespaces.declarePrefix(prefix, namespace);
        }
        HashSet evaluatedURLs = new HashSet();
        config.getIncludes().forEach(filename -> this.processNamespaces(config.getBaseSchemasUrl(), (String)filename, evaluatedURLs));
    }

    private void processNamespaces(String baseURL, String filename, Set<String> evaluatedURLs) {
        try {
            XMLConfigDigester configReader = new XMLConfigDigester();
            URI baseUri = new URL(baseURL).toURI();
            URL url = baseUri.resolve(filename).toURL();
            if (evaluatedURLs.contains(url.toExternalForm())) {
                return;
            }
            evaluatedURLs.add(url.toExternalForm());
            AppSchemaDataAccessDTO config = configReader.parse(url);
            Iterator<Object> iterator = config.getNamespaces().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> stringStringEntry;
                Map.Entry<String, String> entry = stringStringEntry = iterator.next();
                String prefix = entry.getKey();
                String namespace = entry.getValue();
                if (this.namespaces.getURI(prefix) != null) continue;
                this.namespaces.declarePrefix(prefix, namespace);
            }
            if (config.getIncludes() != null && !config.getIncludes().isEmpty()) {
                for (String fname : config.getIncludes()) {
                    this.processNamespaces(config.getBaseSchemasUrl(), fname, evaluatedURLs);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<FeatureTypeMapping> buildMappings(AppSchemaDataAccessDTO config, boolean isInclude) throws IOException {
        return AppSchemaDataAccessConfigurator.buildMappings(config, new DataAccessMap(), isInclude);
    }

    public static Set<FeatureTypeMapping> buildMappings(AppSchemaDataAccessDTO config) throws IOException {
        return AppSchemaDataAccessConfigurator.buildMappings(config, new DataAccessMap(), false);
    }

    public static Set<FeatureTypeMapping> buildMappings(AppSchemaDataAccessDTO config, DataAccessMap sourceDataStoreMap, boolean isInclude) throws IOException {
        AppSchemaDataAccessConfigurator mappingsBuilder = new AppSchemaDataAccessConfigurator(config, sourceDataStoreMap, isInclude);
        Set<FeatureTypeMapping> mappingObjects = mappingsBuilder.buildMappings();
        return mappingObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<FeatureTypeMapping> buildMappings() throws IOException {
        try {
            this.parseGmlSchemas();
            Map<String, DataAccess<FeatureType, Feature>> sourceDataStores = null;
            Set<FeatureTypeMapping> featureTypeMappings = null;
            try {
                sourceDataStores = this.acquireSourceDatastores();
                Set<FeatureTypeMapping> set = featureTypeMappings = this.createFeatureTypeMappings(sourceDataStores, this.isInclude);
                this.disposeUnusedSourceDataStores(sourceDataStores, featureTypeMappings);
                return set;
            }
            catch (Throwable throwable) {
                this.disposeUnusedSourceDataStores(sourceDataStores, featureTypeMappings);
                throw throwable;
            }
        }
        finally {
            if (this.typeRegistry != null) {
                this.typeRegistry.disposeSchemaIndexes();
                this.typeRegistry = null;
            }
        }
    }

    private void disposeUnusedSourceDataStores(Map<String, DataAccess<FeatureType, Feature>> sourceDataStores, Set<FeatureTypeMapping> featureTypeMappings) {
        if (sourceDataStores == null) {
            return;
        }
        if (featureTypeMappings == null) {
            for (DataAccess<FeatureType, Feature> dataAccess : sourceDataStores.values()) {
                dataAccess.dispose();
            }
        } else {
            for (DataAccess<FeatureType, Feature> dataAccess : sourceDataStores.values()) {
                boolean usedDataAccess = false;
                for (FeatureTypeMapping mapping : featureTypeMappings) {
                    if (mapping.getSource().getDataStore() != dataAccess && (mapping.getIndexSource() == null || !Objects.equals(mapping.getIndexSource().getDataStore(), dataAccess))) continue;
                    usedDataAccess = true;
                    break;
                }
                if (usedDataAccess) continue;
                dataAccess.dispose();
            }
        }
    }

    private Set<FeatureTypeMapping> createFeatureTypeMappings(Map<String, DataAccess<FeatureType, Feature>> sourceDataStores, boolean isInclude) throws IOException {
        Set<TypeMapping> mappingsConfigs = this.config.getTypeMappings();
        HashSet<FeatureTypeMapping> featureTypeMappings = new HashSet<FeatureTypeMapping>();
        Iterator<TypeMapping> iterator = mappingsConfigs.iterator();
        while (iterator.hasNext()) {
            TypeMapping mappingsConfig;
            TypeMapping dto = mappingsConfig = iterator.next();
            try {
                CoordinateReferenceSystem crs;
                FeatureSource<? extends FeatureType, ? extends Feature> featureSource = this.getFeatureSource(dto, sourceDataStores);
                try {
                    crs = featureSource.getSchema().getCoordinateReferenceSystem();
                }
                catch (UnsupportedOperationException e) {
                    crs = null;
                }
                AttributeDescriptor target = this.getTargetDescriptor(dto, crs);
                target.getType().getUserData().put("schemaURI", this.schemaURIs);
                target.getType().getUserData().put("declaredNamespacesMap", this.getNamespacesMap());
                boolean isDatabaseBackend = featureSource instanceof JDBCFeatureSource || featureSource instanceof JDBCFeatureStore;
                List<AttributeMapping> attMappings = this.getAttributeMappings(target, dto.getAttributeMappings(), dto.getItemXpath(), crs, isDatabaseBackend);
                FeatureSource<SimpleFeatureType, SimpleFeature> indexFeatureSource = this.getIndexFeatureSource(dto, sourceDataStores);
                FeatureTypeMapping mapping = FeatureTypeMappingFactory.getInstance(featureSource, indexFeatureSource, target, dto.getDefaultGeometryXPath(), attMappings, this.namespaces, dto.getItemXpath(), dto.isXmlDataStore(), dto.isDenormalised(), dto.getSourceDataStore());
                String mappingName = dto.getMappingName();
                if (mappingName != null) {
                    mapping.setName(Types.degloseName((String)mappingName, (NamespaceSupport)this.namespaces));
                }
                mapping.setInclude(isInclude);
                featureTypeMappings.add(mapping);
            }
            catch (Exception e) {
                LOGGER.warning("Error creating app-schema data store for '" + (dto.getMappingName() != null ? dto.getMappingName() : dto.getTargetElementName()) + "', caused by: " + e.getMessage());
                throw new IOException(e);
            }
        }
        return featureTypeMappings;
    }

    private AttributeDescriptor getTargetDescriptor(TypeMapping dto, CoordinateReferenceSystem crs) throws IOException {
        String prefixedTargetName = dto.getTargetElementName();
        Name targetNodeName = Types.degloseName((String)prefixedTargetName, (NamespaceSupport)this.namespaces);
        AttributeDescriptor targetDescriptor = this.typeRegistry.getDescriptor(targetNodeName, crs);
        if (targetDescriptor == null) {
            throw new NoSuchElementException("descriptor " + targetNodeName + " not found in parsed schema");
        }
        String defaultGeomXPath = dto.getDefaultGeometryXPath();
        if (defaultGeomXPath != null && !defaultGeomXPath.isEmpty()) {
            targetDescriptor = this.retypeAddingDefaultGeometry(targetDescriptor, defaultGeomXPath);
        }
        return targetDescriptor;
    }

    private AttributeDescriptor retypeAddingDefaultGeometry(AttributeDescriptor descriptor, String defaultGeomXPath) {
        AttributeDescriptor newDescriptor = descriptor;
        FeatureType type = (FeatureType)descriptor.getType();
        GeometryDescriptor geom = this.getDefaultGeometryDescriptor(type, defaultGeomXPath);
        if (geom == null) {
            throw new IllegalArgumentException(String.format("Default geometry descriptor could not be found for type \"%s\" at x-path \"%s\"", descriptor.getName().toString(), defaultGeomXPath));
        }
        ComplexFeatureTypeFactoryImpl ftf = new ComplexFeatureTypeFactoryImpl();
        String defGeomNamespace = type.getName().getNamespaceURI();
        String defGeomLocalName = "__DEFAULT_GEOMETRY__";
        GeometryDescriptor defGeom = ftf.createGeometryDescriptor(geom.getType(), (Name)new NameImpl(defGeomNamespace, defGeomLocalName), geom.getMinOccurs(), geom.getMaxOccurs(), geom.isNillable(), geom.getDefaultValue());
        HashSet<GeometryDescriptor> descriptors = new HashSet<GeometryDescriptor>(type.getDescriptors());
        descriptors.add(defGeom);
        FeatureType newType = ftf.createFeatureType(type.getName(), descriptors, defGeom, type.isAbstract(), type.getRestrictions(), type.getSuper(), type.getDescription());
        newType.getUserData().putAll(type.getUserData());
        newDescriptor = new AttributeDescriptorImpl((AttributeType)newType, descriptor.getName(), descriptor.getMinOccurs(), descriptor.getMaxOccurs(), descriptor.isNillable(), descriptor.getDefaultValue());
        newDescriptor.getUserData().putAll(descriptor.getUserData());
        return newDescriptor;
    }

    private GeometryDescriptor getDefaultGeometryDescriptor(FeatureType featureType, String xpath) {
        FeaturePropertyAccessorFactory accessorFactory = new FeaturePropertyAccessorFactory();
        Hints hints = new Hints((RenderingHints.Key)PropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces);
        PropertyAccessor accessor = accessorFactory.createPropertyAccessor(featureType.getClass(), xpath, GeometryAttribute.class, hints);
        GeometryDescriptor geom = null;
        if (accessor != null) {
            try {
                geom = (GeometryDescriptor)accessor.get((Object)featureType, xpath, GeometryDescriptor.class);
            }
            catch (Exception e) {
                LOGGER.finest(String.format("Exception occurred retrieving geometry descriptor at x-path \"%s\": %s", xpath, e.getMessage()));
            }
        }
        return geom;
    }

    private List<AttributeMapping> getAttributeMappings(AttributeDescriptor root, List attDtos, String itemXpath, CoordinateReferenceSystem crs, boolean isJDBC) throws IOException {
        LinkedList<AttributeMapping> attMappings = new LinkedList<AttributeMapping>();
        for (Object dto : attDtos) {
            AttributeMapping attMapping;
            String sourceElement;
            AttributeType expectedInstanceOf;
            org.geotools.data.complex.config.AttributeMapping attDto = (org.geotools.data.complex.config.AttributeMapping)dto;
            String idExpr = attDto.getIdentifierExpression();
            String idXpath = null;
            if (idExpr == null && (idXpath = attDto.getIdentifierPath()) != null) {
                XPathUtil.StepList inputXPathSteps = XPath.steps((AttributeDescriptor)root, (String)(itemXpath + "/" + idXpath), (NamespaceSupport)this.namespaces);
                this.validateConfiguredNamespaces(inputXPathSteps);
            }
            String sourceExpr = attDto.getSourceExpression();
            String inputXPath = null;
            if (sourceExpr == null && (inputXPath = attDto.getInputAttributePath()) != null) {
                XPathUtil.StepList inputXPathSteps = XPath.steps((AttributeDescriptor)root, (String)(itemXpath + "/" + inputXPath), (NamespaceSupport)this.namespaces);
                this.validateConfiguredNamespaces(inputXPathSteps);
            }
            String expectedInstanceTypeName = attDto.getTargetAttributeSchemaElement();
            String targetXPath = attDto.getTargetAttributePath();
            XPathUtil.StepList targetXPathSteps = XPath.steps((AttributeDescriptor)root, (String)targetXPath, (NamespaceSupport)this.namespaces);
            this.validateConfiguredNamespaces(targetXPathSteps);
            boolean isMultiValued = attDto.isMultiple();
            AttributeExpressionImpl idExpression = idXpath == null ? this.parseOgcCqlExpression(idExpr) : new AttributeExpressionImpl(idXpath, new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces));
            AttributeExpressionImpl sourceExpression = inputXPath == null ? this.parseOgcCqlExpression(sourceExpr) : new AttributeExpressionImpl(inputXPath, new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces));
            Map<Name, Expression> clientProperties = this.getClientProperties(attDto);
            if (expectedInstanceTypeName != null) {
                Name expectedNodeTypeName = Types.degloseName((String)expectedInstanceTypeName, (NamespaceSupport)this.namespaces);
                expectedInstanceOf = this.typeRegistry.getAttributeType(expectedNodeTypeName, null, crs);
                if (expectedInstanceOf == null) {
                    String msg = "mapping expects and instance of " + expectedNodeTypeName + " for attribute " + targetXPath + " but the attribute descriptor was not found";
                    throw new DataSourceException(msg);
                }
            } else {
                expectedInstanceOf = null;
            }
            if ((sourceElement = attDto.getLinkElement()) != null) {
                NestedAttributeMapping customNestedMapping;
                Expression elementExpr = this.parseOgcCqlExpression(sourceElement);
                String sourceField = attDto.getLinkField();
                XPathUtil.StepList sourceFieldSteps = null;
                if (sourceField != null) {
                    sourceFieldSteps = XPath.steps((AttributeDescriptor)root, (String)sourceField, (NamespaceSupport)this.namespaces);
                }
                attMapping = (customNestedMapping = CustomImplementationsFinder.find(this, (Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, isMultiValued, clientProperties, elementExpr, sourceFieldSteps, this.namespaces)) != null ? customNestedMapping : (AppSchemaDataAccessConfigurator.isJoining() && isJDBC ? new JoiningNestedAttributeMapping((Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, isMultiValued, clientProperties, elementExpr, sourceFieldSteps, this.namespaces) : new NestedAttributeMapping((Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, isMultiValued, clientProperties, elementExpr, sourceFieldSteps, this.namespaces));
            } else {
                attMapping = new AttributeMapping((Expression)idExpression, (Expression)sourceExpression, attDto.getSourceIndex(), targetXPathSteps, expectedInstanceOf, isMultiValued, clientProperties, attDto.getMultipleValue());
            }
            if (attDto.isList()) {
                attMapping.setList(true);
            }
            if (attDto.encodeIfEmpty()) {
                attMapping.setEncodeIfEmpty(true);
            }
            if (attDto.getLabel() != null) {
                attMapping.setLabel(attDto.getLabel());
            }
            if (attDto.getParentLabel() != null) {
                attMapping.setParentLabel(attDto.getParentLabel());
            }
            if (attDto.getInstancePath() != null) {
                attMapping.setInstanceXpath(attDto.getInstancePath());
            }
            attMapping.setIndexField(attDto.getIndexField());
            attMappings.add(attMapping);
        }
        return attMappings;
    }

    private void validateConfiguredNamespaces(XPathUtil.StepList targetXPathSteps) {
        for (XPathUtil.Step step : targetXPathSteps) {
            QName name = step.getName();
            if ("".equals(name.getPrefix()) || !"".equals(name.getNamespaceURI())) continue;
            throw new IllegalArgumentException("location step " + step + " has prefix " + name.getPrefix() + " for which no namespace was set. (Check the Namespaces section in the config file)");
        }
    }

    private Expression parseOgcCqlExpression(String sourceExpr) throws DataSourceException {
        return AppSchemaDataAccessConfigurator.parseOgcCqlExpression(sourceExpr, this.ff);
    }

    public static Expression parseOgcCqlExpression(String sourceExpr, FilterFactory ff) throws DataSourceException {
        Expression expression = Expression.NIL;
        if (sourceExpr != null && !sourceExpr.trim().isEmpty()) {
            try {
                expression = CQL.toExpression((String)sourceExpr, (FilterFactory)ff);
            }
            catch (CQLException e) {
                String formattedErrorMessage = e.getMessage();
                LOGGER.log(Level.SEVERE, formattedErrorMessage, e);
                throw new DataSourceException("Error parsing CQL expression " + sourceExpr + ":\n" + formattedErrorMessage);
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                String msg = "parsing expression " + sourceExpr;
                LOGGER.log(Level.SEVERE, msg, e);
                throw new DataSourceException(msg + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return expression;
    }

    private Map<Name, Expression> getClientProperties(org.geotools.data.complex.config.AttributeMapping dto) throws DataSourceException {
        HashMap<Name, Expression> clientProperties = new HashMap<Name, Expression>();
        if (!dto.getClientProperties().isEmpty()) {
            Iterator<Map.Entry<String, String>> iterator = dto.getClientProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> stringStringEntry;
                Map.Entry<String, String> entry = stringStringEntry = iterator.next();
                String name = entry.getKey();
                Name qName = Types.degloseName((String)name, (NamespaceSupport)this.namespaces);
                String cqlExpression = entry.getValue();
                Expression expression = this.parseOgcCqlExpression(cqlExpression);
                Expression fixedExpr = this.fixClientPropertyIfJDBCMultipleValueIsPresent(dto, expression);
                clientProperties.put(qName, fixedExpr);
            }
        }
        this.addAnonymousAttributes(dto, clientProperties);
        return clientProperties;
    }

    private Expression fixClientPropertyIfJDBCMultipleValueIsPresent(org.geotools.data.complex.config.AttributeMapping dto, Expression clientPropertyExpr) {
        MultipleValue multipleValue = dto.getMultipleValue();
        if (multipleValue instanceof JdbcMultipleValue) {
            final JdbcMultipleValue jdbcMultipleValue = (JdbcMultipleValue)multipleValue;
            DuplicatingFilterVisitor duplicatingFilterVisitor = new DuplicatingFilterVisitor(){

                public Object visit(PropertyName propertyName, Object extraData) {
                    JoinPropertyName joinPn = new JoinPropertyName(null, jdbcMultipleValue.getId(), propertyName.getPropertyName());
                    joinPn.namespaceSupport = propertyName.getNamespaceContext();
                    return joinPn;
                }
            };
            clientPropertyExpr = (Expression)clientPropertyExpr.accept((ExpressionVisitor)duplicatingFilterVisitor, null);
        }
        return clientPropertyExpr;
    }

    private void addAnonymousAttributes(org.geotools.data.complex.config.AttributeMapping dto, Map<Name, Expression> clientProperties) throws DataSourceException {
        for (Map.Entry<String, String> entry : dto.getAnonymousAttributes().entrySet()) {
            Name qname = Types.degloseName((String)entry.getKey(), (NamespaceSupport)this.namespaces);
            ComplexNameImpl complexName = new ComplexNameImpl(qname.getNamespaceURI(), qname.getLocalPart(), true);
            Expression expression = this.parseOgcCqlExpression(entry.getValue());
            clientProperties.put((Name)complexName, expression);
        }
    }

    private FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource(TypeMapping dto, Map<String, DataAccess<FeatureType, Feature>> sourceDataStores) throws IOException {
        String dsId = dto.getSourceDataStore();
        String typeName = dto.getSourceTypeName();
        DataAccess<FeatureType, Feature> sourceDataStore = sourceDataStores.get(dsId);
        if (sourceDataStore == null) {
            throw new DataSourceException("datastore " + dsId + " not found for type mapping " + dto);
        }
        LOGGER.fine("asking datastore " + sourceDataStore + " for source type " + typeName);
        Name name = Types.degloseName((String)typeName, (NamespaceSupport)this.namespaces);
        FeatureSource fSource = sourceDataStore.getFeatureSource(name);
        if (fSource instanceof XmlFeatureSource) {
            ((XmlFeatureSource)fSource).setNamespaces(this.namespaces);
        }
        LOGGER.fine("found feature source for " + typeName);
        return fSource;
    }

    private void parseGmlSchemas() throws IOException {
        LOGGER.finer("about to parse target schemas");
        URL baseUrl = new URL(this.config.getBaseSchemasUrl());
        List<String> schemaFiles = this.config.getTargetSchemasUris();
        EmfComplexFeatureReader schemaParser = EmfComplexFeatureReader.newInstance();
        schemaParser.setResolver(this.buildResolver());
        this.typeRegistry = new AppSchemaFeatureTypeRegistry(this.namespaces);
        this.schemaURIs = new HashMap<String, String>(schemaFiles.size());
        Iterator<String> iterator = schemaFiles.iterator();
        while (iterator.hasNext()) {
            String schemaFile;
            String schemaLocation = schemaFile = iterator.next();
            URL schemaUrl = this.resolveResourceLocation(baseUrl, schemaLocation);
            LOGGER.fine("parsing schema " + schemaUrl.toExternalForm());
            String nameSpace = schemaParser.findSchemaNamespace(schemaUrl);
            schemaLocation = schemaUrl.toExternalForm();
            this.schemaURIs.put(nameSpace, schemaLocation);
            SchemaIndex schemaIndex = schemaParser.parse(nameSpace, schemaLocation);
            this.typeRegistry.addSchemas(schemaIndex);
        }
    }

    private SchemaCatalog buildCatalog() {
        String catalogLocation = this.config.getCatalog();
        if (catalogLocation == null) {
            return null;
        }
        try {
            URL baseUrl = new URL(this.config.getBaseSchemasUrl());
            URL resolvedCatalogLocation = this.resolveResourceLocation(baseUrl, catalogLocation);
            return SchemaCatalog.build((URL)resolvedCatalogLocation);
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Malformed URL encountered while setting OASIS catalog location. Mapping file URL: " + this.config.getBaseSchemasUrl() + " Catalog location: " + this.config.getCatalog() + " Detail: " + e.getMessage());
            return null;
        }
    }

    private SchemaCache buildCache() {
        try {
            return SchemaCache.buildAutomaticallyConfiguredUsingFileUrl((URL)new URL(this.config.getBaseSchemasUrl()));
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Malformed mapping file URL: " + this.config.getBaseSchemasUrl() + " Detail: " + e.getMessage());
            return null;
        }
    }

    private SchemaResolver buildResolver() {
        return new SchemaResolver(this.buildCatalog(), this.buildCache());
    }

    private URL resolveResourceLocation(URL baseUrl, String schemaLocation) throws MalformedURLException {
        URL schemaUrl;
        if (schemaLocation.startsWith("file:") || schemaLocation.startsWith("http:")) {
            LOGGER.fine("using resource location as absolute path: " + schemaLocation);
            schemaUrl = new URL(schemaLocation);
        } else if (baseUrl == null) {
            schemaUrl = new URL(schemaLocation);
            LOGGER.warning("base url not provided, may be unable to locate" + schemaLocation + ". Path resolved to: " + schemaUrl.toExternalForm());
        } else {
            LOGGER.fine("using schema location " + schemaLocation + " as relative to " + baseUrl);
            schemaUrl = new URL(baseUrl, schemaLocation);
        }
        return schemaUrl;
    }

    private Map<String, DataAccess<FeatureType, Feature>> acquireSourceDatastores() throws IOException {
        LOGGER.entering(this.getClass().getName(), "acquireSourceDatastores");
        LinkedHashMap<String, DataAccess<FeatureType, Feature>> datastores = new LinkedHashMap<String, DataAccess<FeatureType, Feature>>();
        List<SourceDataStore> dsParams = this.config.getSourceDataStores();
        for (SourceDataStore dsconfig : dsParams) {
            String id = dsconfig.getId();
            Map<String, Serializable> datastoreParams = dsconfig.getParams();
            datastoreParams = this.resolveRelativePaths(datastoreParams);
            LOGGER.fine("looking for datastore " + id);
            DataAccess dataStore = null;
            if (this.dataStoreMap != null) {
                if (this.dataStoreMap.containsKey(datastoreParams)) {
                    dataStore = (DataAccess)this.dataStoreMap.get(datastoreParams);
                } else {
                    List<CustomSourceDataStore> extensions = CustomSourceDataStore.loadExtensions();
                    dataStore = this.buildDataStore(extensions, dsconfig, this.config);
                    dataStore = dataStore == null ? DataAccessFinder.getDataStore(datastoreParams) : dataStore;
                    this.dataStoreMap.put(datastoreParams, dataStore);
                }
            }
            if (dataStore == null) {
                LOGGER.log(Level.SEVERE, "Cannot find a DataAccess for parameters " + datastoreParams);
                throw new DataSourceException("Cannot find a DataAccess for parameters (some not shown) " + this.filterDatastoreParams(datastoreParams));
            }
            LOGGER.fine("got datastore " + dataStore);
            datastores.put(id, dataStore);
        }
        return datastores;
    }

    private DataAccess<FeatureType, Feature> buildDataStore(List<CustomSourceDataStore> extensions, SourceDataStore dataStoreConfig, AppSchemaDataAccessDTO appSchemaConfig) {
        for (CustomSourceDataStore extension : extensions) {
            DataAccess<? extends FeatureType, ? extends Feature> dataStore = extension.buildDataStore(dataStoreConfig, appSchemaConfig);
            if (dataStore == null) continue;
            return dataStore;
        }
        return null;
    }

    private Map filterDatastoreParams(Map datastoreParams) {
        LinkedHashMap filteredDatastoreParams = new LinkedHashMap();
        for (String key : SAFE_DATASTORE_PARAMS) {
            if (!datastoreParams.containsKey(key)) continue;
            filteredDatastoreParams.put(key, datastoreParams.get(key));
        }
        return filteredDatastoreParams;
    }

    private Map<String, Serializable> resolveRelativePaths(Map<String, Serializable> datastoreParams) {
        HashMap<String, Serializable> resolvedParams = new HashMap<String, Serializable>();
        LOGGER.entering(this.getClass().getName(), "resolveRelativePaths");
        for (Map.Entry<String, Serializable> entry : datastoreParams.entrySet()) {
            String key = entry.getKey();
            Object value = (String)((Object)entry.getValue());
            if (value != null && ((String)value).startsWith("file:")) {
                String resolvedDataPath;
                String oldValue;
                block6: {
                    oldValue = value;
                    resolvedDataPath = null;
                    String inputDataPath = ((String)value).substring("file:".length());
                    File f = new File(inputDataPath);
                    if (!f.isAbsolute()) {
                        LOGGER.fine("resolving original parameter " + (String)value + " for datastore parameter " + key);
                        try {
                            URL mappingFileUrl = new URL(this.config.getBaseSchemasUrl());
                            LOGGER.finer("mapping file URL is " + mappingFileUrl.toString());
                            String mappingFileDirPath = URLs.urlToFile((URL)mappingFileUrl).getParent();
                            LOGGER.finer("mapping file parent directory is " + mappingFileDirPath);
                            resolvedDataPath = FilenameUtils.concat((String)mappingFileDirPath, (String)inputDataPath);
                            if (resolvedDataPath == null) {
                                throw new RuntimeException("Relative path to datastore is incompatible with the base path - check double dot steps.");
                            }
                            break block6;
                        }
                        catch (Exception e) {
                            LOGGER.throwing(this.getClass().getName(), "resolveRelativePaths", e);
                            throw new RuntimeException(e);
                        }
                    }
                    resolvedDataPath = inputDataPath;
                }
                LOGGER.finer("Path to data has been resolved to " + resolvedDataPath);
                value = "url".equals(key) || key.startsWith("WSDataStoreFactory") ? "file:" + resolvedDataPath : resolvedDataPath;
                LOGGER.fine("Resolved " + oldValue + " -> " + (String)value);
            }
            resolvedParams.put(key, (Serializable)value);
        }
        return resolvedParams;
    }

    private FeatureSource<SimpleFeatureType, SimpleFeature> getIndexFeatureSource(TypeMapping dto, Map<String, DataAccess<FeatureType, Feature>> sourceDataStores) throws IOException {
        String dsId = dto.getIndexDataStore();
        String typeName = dto.getIndexTypeName();
        if (StringUtils.isEmpty((CharSequence)dsId) || StringUtils.isEmpty((CharSequence)typeName)) {
            return null;
        }
        DataAccess<FeatureType, Feature> sourceDataStore = sourceDataStores.get(dsId);
        if (sourceDataStore == null) {
            throw new DataSourceException("datastore " + dsId + " not found for type mapping " + dto);
        }
        Name name = Types.degloseName((String)typeName, (NamespaceSupport)this.namespaces);
        SimpleFeatureSource fSource = (SimpleFeatureSource)sourceDataStore.getFeatureSource(name);
        if (fSource == null) {
            throw new RuntimeException("Feature source not found '" + typeName + "'.");
        }
        if (fSource instanceof XmlFeatureSource) {
            ((XmlFeatureSource)fSource).setNamespaces(this.namespaces);
        }
        return fSource;
    }

    private Map<String, String> getNamespacesMap() {
        HashMap<String, String> namespacesMap = new HashMap<String, String>();
        Enumeration<String> prefixes = this.namespaces.getPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            String uri = this.namespaces.getURI(prefix);
            namespacesMap.put(prefix, uri);
        }
        return namespacesMap;
    }

    public static class ComplexNameImpl
    extends NameImpl {
        private boolean isNestedElement;

        public ComplexNameImpl(String namespace, String local, boolean isNestedElement) {
            super(namespace, local);
            this.isNestedElement = isNestedElement;
        }

        public String getLocalPart() {
            return super.getLocalPart();
        }

        public String getNamespaceURI() {
            return super.getNamespaceURI();
        }

        public boolean isNestedElement() {
            return this.isNestedElement;
        }
    }
}

