/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.FeatureTypeFactory;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.appschema.feature.AppSchemaAttributeBuilder;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.data.complex.feature.type.UniqueNameFeatureTypeFactoryImpl;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.PropertyImpl;
import org.geotools.feature.ValidatingFeatureFactoryImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.feature.type.Types;
import org.geotools.gml3.GML;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XSSchema;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.Attributes;

public class XPath
extends XPathUtil {
    private static final Logger LOGGER = Logging.getLogger(XPath.class);
    private FilterFactory FF;
    private FeatureFactory featureFactory;
    private CoordinateReferenceSystem crs;
    private FeatureTypeFactory descriptorFactory;

    public XPath() {
        this.FF = CommonFactoryFinder.getFilterFactory(null);
        this.featureFactory = new ValidatingFeatureFactoryImpl();
        this.descriptorFactory = new UniqueNameFeatureTypeFactoryImpl();
    }

    public XPath(FilterFactory ff, FeatureFactory featureFactory) {
        this.setFilterFactory(ff);
        this.setFeatureFactory(featureFactory);
    }

    public void setFilterFactory(FilterFactory ff) {
        this.FF = ff;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void setFeatureFactory(FeatureFactory featureFactory) {
        this.featureFactory = featureFactory;
    }

    public Attribute set(Attribute att, XPathUtil.StepList xpath, Object value, String id, AttributeType targetNodeType, boolean isXlinkRef, Expression sourceExpression) {
        return this.set(att, xpath, value, id, targetNodeType, isXlinkRef, null, sourceExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Attribute set(Attribute att, XPathUtil.StepList xpath, Object value, String id, AttributeType targetNodeType, boolean isXlinkRef, AttributeDescriptor targetDescriptor, Expression sourceExpression) {
        XPathUtil.Step rootStep;
        QName stepName;
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.entering("XPath", "set", new Object[]{att, xpath, value, id, targetNodeType});
        }
        XPathUtil.StepList steps = new XPathUtil.StepList(xpath);
        Attribute parent = att;
        Name rootName = null;
        AttributeDescriptor parentDescriptor = parent.getDescriptor();
        if (parentDescriptor != null && org.geotools.data.complex.feature.type.Types.equals((Name)(rootName = parentDescriptor.getName()), (QName)(stepName = (rootStep = (XPathUtil.Step)steps.get(0)).getName()))) {
            if (steps.size() > 1) {
                steps.remove(0);
            } else {
                if (org.geotools.data.complex.feature.type.Types.isSimpleContentType((PropertyType)parent.getType()) || org.geotools.data.complex.feature.type.Types.canHaveTextContent((PropertyType)parent.getType())) {
                    return this.setSimpleContentValue(parent, value);
                }
                if (org.geotools.data.complex.feature.type.Types.isGeometryType((AttributeType)parent.getType())) {
                    ComplexFeatureTypeFactoryImpl typeFactory = new ComplexFeatureTypeFactoryImpl();
                    GeometryType geomType = parent.getType() instanceof GeometryType ? (GeometryType)parent.getType() : (GeometryType)((NonFeatureTypeProxy)parent.getType()).getSubject();
                    GeometryDescriptor geomDescriptor = typeFactory.createGeometryDescriptor(geomType, rootName, parentDescriptor.getMinOccurs(), parentDescriptor.getMaxOccurs(), parentDescriptor.isNillable(), parentDescriptor.getDefaultValue());
                    GeometryAttributeImpl geom = new GeometryAttributeImpl(value, geomDescriptor, null);
                    parent.setValue(List.of(geom));
                    return geom;
                }
            }
        }
        Iterator stepsIterator = steps.iterator();
        while (stepsIterator.hasNext()) {
            XPathUtil.Step currStep = (XPathUtil.Step)stepsIterator.next();
            AttributeDescriptor currStepDescriptor = null;
            boolean isLastStep = !stepsIterator.hasNext();
            QName stepName2 = currStep.getName();
            Name attributeName = Types.toTypeName((QName)stepName2);
            AttributeType _parentType = parent.getType();
            if (_parentType.getName().equals((Object)XSSchema.ANYTYPE_TYPE.getName()) && targetDescriptor != null) {
                currStepDescriptor = targetDescriptor;
            } else {
                ComplexType parentType = (ComplexType)_parentType;
                if (!isLastStep || targetNodeType == null) {
                    String prefixedStepName;
                    PropertyName name;
                    Attribute child;
                    currStepDescriptor = null == attributeName.getNamespaceURI() ? (AttributeDescriptor)org.geotools.data.complex.feature.type.Types.findDescriptor((ComplexType)parentType, (String)attributeName.getLocalPart()) : (AttributeDescriptor)org.geotools.data.complex.feature.type.Types.findDescriptor((ComplexType)parentType, (Name)attributeName);
                    if (currStepDescriptor == null && (child = (Attribute)(name = this.FF.property(prefixedStepName = currStep.toString())).evaluate((Object)parent)) != null) {
                        currStepDescriptor = child.getDescriptor();
                    }
                } else {
                    AttributeDescriptor actualDescriptor = null == attributeName.getNamespaceURI() ? (AttributeDescriptor)org.geotools.data.complex.feature.type.Types.findDescriptor((ComplexType)parentType, (String)attributeName.getLocalPart()) : (AttributeDescriptor)org.geotools.data.complex.feature.type.Types.findDescriptor((ComplexType)parentType, (Name)attributeName);
                    if (actualDescriptor != null) {
                        int minOccurs = actualDescriptor.getMinOccurs();
                        int maxOccurs = actualDescriptor.getMaxOccurs();
                        boolean nillable = actualDescriptor.isNillable();
                        if (actualDescriptor instanceof GeometryDescriptor) {
                            if (!Geometry.class.isAssignableFrom(targetNodeType.getBinding())) throw new IllegalArgumentException("Can't set targetNodeType: " + targetNodeType.toString() + " for attribute mapping: " + attributeName + " as it is not a Geometry type!");
                            if (!(targetNodeType instanceof GeometryType)) {
                                targetNodeType = new GeometryTypeImpl(targetNodeType.getName(), targetNodeType.getBinding(), ((GeometryDescriptor)actualDescriptor).getCoordinateReferenceSystem(), targetNodeType.isIdentified(), targetNodeType.isAbstract(), targetNodeType.getRestrictions(), targetNodeType.getSuper(), targetNodeType.getDescription());
                            }
                            currStepDescriptor = this.descriptorFactory.createGeometryDescriptor((GeometryType)targetNodeType, attributeName, minOccurs, maxOccurs, nillable, null);
                        } else {
                            currStepDescriptor = this.descriptorFactory.createAttributeDescriptor(targetNodeType, attributeName, minOccurs, maxOccurs, nillable, null);
                        }
                    }
                }
                if (currStepDescriptor == null) {
                    StringBuffer parentAtts = new StringBuffer();
                    Collection properties = parentType.getDescriptors();
                    Iterator it = properties.iterator();
                    while (it.hasNext()) {
                        PropertyDescriptor desc = (PropertyDescriptor)it.next();
                        Name name = desc.getName();
                        parentAtts.append(name.getNamespaceURI());
                        parentAtts.append("#");
                        parentAtts.append(name.getLocalPart());
                        if (!it.hasNext()) continue;
                        parentAtts.append(", ");
                    }
                    throw new IllegalArgumentException(currStep + " is not a valid location path for type " + parentType.getName() + ". " + currStep + " ns: " + currStep.getName().getNamespaceURI() + ", " + parentType.getName().getLocalPart() + " properties: " + parentAtts);
                }
            }
            if (isLastStep) {
                assert (currStepDescriptor != null);
                return this.setLeafAttribute(currStepDescriptor, currStep, id, value, parent, targetNodeType, isXlinkRef);
            }
            int index = currStep.isIndexed() ? currStep.getIndex() : -1;
            parent = this.setValue(currStepDescriptor, null, List.of(), index, parent, null, false);
        }
        throw new IllegalStateException();
    }

    private Attribute setSimpleContentValue(Attribute attribute, Object value) {
        Property simpleContent = null;
        if (attribute instanceof ComplexAttribute) {
            simpleContent = ((ComplexAttribute)attribute).getProperty(ComplexFeatureConstants.SIMPLE_CONTENT);
        }
        if (simpleContent == null) {
            simpleContent = this.buildSimpleContent(attribute.getType(), value);
            List<Property> contents = List.of(simpleContent);
            ComplexAttributeImpl nestedAtt = new ComplexAttributeImpl(contents, attribute.getDescriptor(), attribute.getIdentifier());
            List<ComplexAttributeImpl> nestedAttContents = List.of(nestedAtt);
            attribute.setValue(nestedAttContents);
            return nestedAtt;
        }
        AttributeType simpleContentType = XPath.getSimpleContentType((AttributeType)simpleContent.getType());
        Object convertedValue = this.FF.literal(value).evaluate(value, simpleContentType.getBinding());
        simpleContent.setValue(convertedValue);
        return attribute;
    }

    private Attribute setLeafAttribute(AttributeDescriptor currStepDescriptor, XPathUtil.Step currStep, String id, Object value, Attribute parent, AttributeType targetNodeType, boolean isXlinkRef) {
        int index = currStep.isIndexed() ? currStep.getIndex() : -1;
        Attribute attribute = this.setValue(currStepDescriptor, id, value, index, parent, targetNodeType, isXlinkRef);
        return attribute;
    }

    private Attribute setValue(AttributeDescriptor descriptor, String id, Object value, int index, Attribute parent, AttributeType targetNodeType, boolean isXlinkRef) {
        Attribute leafAttribute;
        Object convertedValue = null;
        Map simpleContentProperties = null;
        if (this.isFeatureChainedSimpleContent(descriptor, value)) {
            List<Property> nestedPropList = this.getSimpleContentList(value);
            if (!nestedPropList.isEmpty()) {
                Property nestedProp = nestedPropList.iterator().next();
                convertedValue = org.geotools.data.complex.feature.type.Types.isGeometryType((AttributeType)descriptor.getType()) || nestedProp.getName().equals((Object)descriptor.getName()) ? nestedProp.getValue() : nestedPropList;
                simpleContentProperties = nestedProp.getUserData();
            }
        } else {
            convertedValue = this.convertValue(descriptor, value);
        }
        Name attributeName = descriptor.getName();
        Attribute attribute = leafAttribute = parent instanceof ComplexAttribute ? this.findLeafAttribute((ComplexAttribute)parent, attributeName, index, isXlinkRef, convertedValue) : null;
        if (leafAttribute == null || descriptor.getMaxOccurs() > 1 && leafAttribute.getUserData().containsKey(Attributes.class) && ((Map)leafAttribute.getUserData().get(Attributes.class)).containsKey(AbstractMappingFeatureIterator.XLINK_HREF_NAME)) {
            AppSchemaAttributeBuilder builder = new AppSchemaAttributeBuilder(this.featureFactory);
            if (this.crs != null) {
                builder.setCRS(this.crs);
            }
            builder.setDescriptor(parent.getDescriptor());
            builder.setType(parent.getType());
            leafAttribute = targetNodeType != null ? (parent.getType().getName().equals((Object)XSSchema.ANYTYPE_TYPE.getName()) ? builder.addAnyTypeValue(convertedValue, targetNodeType, descriptor, id) : builder.add(id, convertedValue, attributeName, targetNodeType)) : (descriptor.getType().getName().equals((Object)XSSchema.ANYTYPE_TYPE.getName()) && (value == null || value instanceof Collection && ((Collection)value).isEmpty()) ? builder.addComplexAnyTypeAttribute(convertedValue, descriptor, id) : builder.add(id, convertedValue, attributeName));
            if (index > -1) {
                leafAttribute.getUserData().put("MAPPED_ATTRIBUTE_INDEX", index);
            }
            this.addProperty(parent, leafAttribute);
        }
        if (!this.isEmpty(convertedValue)) {
            leafAttribute.setValue(convertedValue);
        }
        if (simpleContentProperties != null) {
            this.mergeClientProperties(leafAttribute, simpleContentProperties);
        }
        return leafAttribute;
    }

    private void addProperty(Attribute parent, Attribute attribute) {
        if (parent instanceof ComplexAttributeImpl) {
            ((ComplexAttributeImpl)parent).addValue((Property)attribute);
        } else {
            Collection currValue = (Collection)parent.getValue();
            ArrayList<Attribute> newValue = new ArrayList<Attribute>(currValue);
            newValue.add(attribute);
            parent.setValue(newValue);
        }
    }

    private Attribute findLeafAttribute(ComplexAttribute parent, Name attributeName, int index, boolean isXlinkRef, Object convertedValue) {
        Attribute leafAttribute = null;
        if (isXlinkRef || this.isUnboundedMultivalue((Attribute)parent)) {
            return null;
        }
        if (parent instanceof ComplexAttributeImpl ? ((ComplexAttributeImpl)parent).findLast(attributeName).isEmpty() : parent.getProperties(attributeName).isEmpty()) {
            return null;
        }
        if (this.isEmpty(convertedValue)) {
            leafAttribute = this.getAttributeMatchingIndex(parent, attributeName, index);
        } else {
            Predicate<Attribute> valueFilter = att -> att != null && Objects.equals(att.getValue(), convertedValue);
            if (index > -1) {
                boolean checkMappedAttributeIndexOnly = true;
                Attribute sameIndex = this.getAttributeWithMappedIndex(parent, attributeName, index, true);
                if (valueFilter.test(sameIndex)) {
                    leafAttribute = sameIndex;
                }
            } else {
                leafAttribute = this.findFirst(parent, attributeName, valueFilter);
            }
        }
        return leafAttribute;
    }

    private Attribute getAttributeMatchingIndex(ComplexAttribute parent, Name attributeName, int index) {
        Attribute leafAttribute;
        if (index > -1) {
            boolean checkMappedAttributeIndexOnly = false;
            leafAttribute = this.getAttributeWithMappedIndex(parent, attributeName, index, false);
        } else {
            leafAttribute = this.getLastAttribute(parent, attributeName);
        }
        return leafAttribute;
    }

    private Attribute findFirst(ComplexAttribute parent, Name attributeName, Predicate<Attribute> filter) {
        Optional<Attribute> found;
        if (parent instanceof ComplexAttributeImpl) {
            Predicate<Property> nameFilter = p -> attributeName.equals((Object)p.getName());
            Predicate<Property> attFilter = p -> Attribute.class.isInstance(p);
            found = ((ComplexAttributeImpl)parent).findAll(attFilter.and(nameFilter)).map(Attribute.class::cast).filter(filter).findFirst();
        } else {
            List<Attribute> values = this.getAttributes(parent, attributeName);
            Predicate<Attribute> nameFilter = p -> attributeName.equals((Object)p.getName());
            found = values.stream().filter(nameFilter.and(filter)).findFirst();
        }
        return found.map(Attribute.class::cast).orElse(null);
    }

    private Attribute getAttributeWithMappedIndex(ComplexAttribute parent, Name attributeName, int index, boolean checkMappedAttributeIndexOnly) {
        Predicate<Attribute> filter = stepValue -> {
            int valueIndex = 1;
            if (attributeName.equals((Object)stepValue.getName())) {
                Object mappedIndex = stepValue instanceof PropertyImpl ? ((PropertyImpl)stepValue).getUserData((Object)"MAPPED_ATTRIBUTE_INDEX") : stepValue.getUserData().get("MAPPED_ATTRIBUTE_INDEX");
                if (null == mappedIndex) {
                    if (checkMappedAttributeIndexOnly) {
                        return false;
                    }
                    mappedIndex = valueIndex;
                }
                if (!(mappedIndex instanceof Number)) {
                    mappedIndex = Integer.parseInt(String.valueOf(mappedIndex));
                }
                if (index == ((Number)mappedIndex).intValue()) {
                    return true;
                }
                ++valueIndex;
            }
            return false;
        };
        return this.findFirst(parent, attributeName, filter);
    }

    private Attribute getLastAttribute(ComplexAttribute parent, Name attributeName) {
        if (parent instanceof ComplexAttributeImpl) {
            return ((ComplexAttributeImpl)parent).findLast(attributeName).map(Attribute.class::cast).orElse(null);
        }
        List<Attribute> values = this.getAttributes(parent, attributeName);
        return values.isEmpty() ? null : values.get(values.size() - 1);
    }

    private List<Attribute> getAttributes(ComplexAttribute parent, Name attributeName) {
        Collection currStepValue = parent.getProperties(attributeName);
        if (currStepValue.isEmpty()) {
            return List.of();
        }
        if (currStepValue instanceof List) {
            return (List)currStepValue;
        }
        return new ArrayList<Attribute>(currStepValue);
    }

    private List<Property> getSimpleContentList(Object value) {
        if (value == null || !(value instanceof Collection)) {
            return null;
        }
        Collection list = (Collection)value;
        if (list.size() != 1) {
            throw new IllegalArgumentException("Expecting only 1 feature in the list!");
        }
        Object f = list.iterator().next();
        if (!(f instanceof Feature)) {
            throw new IllegalArgumentException("Expecting a feature!");
        }
        Feature feature = (Feature)f;
        Collection featureProps = feature.getProperties();
        ArrayList<Property> properties = new ArrayList<Property>(featureProps.size());
        for (Property prop : featureProps) {
            if (ComplexFeatureConstants.FEATURE_CHAINING_LINK_NAME.equals((Object)prop.getName())) continue;
            properties.add(prop);
        }
        return properties;
    }

    private void mergeClientProperties(Attribute leafAttribute, Map<Object, Object> simpleContentProperties) {
        Map origData = leafAttribute.getUserData();
        for (Object key : simpleContentProperties.keySet()) {
            if (key.equals(Attributes.class)) {
                Map inputMap = (Map)simpleContentProperties.get(key);
                if (origData.containsKey(Attributes.class)) {
                    Map existingMap = (Map)origData.get(key);
                    for (Object mapKey : inputMap.keySet()) {
                        if (existingMap.containsKey(mapKey)) continue;
                        existingMap.put(mapKey, inputMap.get(mapKey));
                    }
                    continue;
                }
                origData.put(Attributes.class, inputMap);
                continue;
            }
            if (origData.containsKey(key)) continue;
            origData.put(key, simpleContentProperties.get(key));
        }
    }

    private boolean isFeatureChainedSimpleContent(AttributeDescriptor descriptor, Object value) {
        Name featureName;
        Object f;
        boolean isFeatureChainedSimpleContent = false;
        if (value instanceof Collection && !this.isEmpty(value) && (f = ((Collection)value).iterator().next()) instanceof Feature && ((Feature)f).getProperty(featureName = ((Feature)f).getDescriptor().getName()) != null) {
            isFeatureChainedSimpleContent = true;
        }
        return isFeatureChainedSimpleContent;
    }

    private boolean isEmpty(Object convertedValue) {
        if (convertedValue == null) {
            return true;
        }
        if (convertedValue instanceof Collection) {
            return ((Collection)convertedValue).isEmpty();
        }
        return false;
    }

    private Object convertValue(AttributeDescriptor descriptor, Object value) {
        AttributeType type = descriptor.getType();
        Class binding = type.getBinding();
        if (type instanceof ComplexType && binding == Collection.class) {
            boolean isSimpleContent = org.geotools.data.complex.feature.type.Types.isSimpleContentType((PropertyType)type);
            boolean canHaveTextContent = org.geotools.data.complex.feature.type.Types.canHaveTextContent((PropertyType)type);
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                if (!isSimpleContent && !canHaveTextContent) {
                    return value;
                }
                return values.stream().map(v -> {
                    if (v instanceof Property) {
                        return (Property)v;
                    }
                    if (isSimpleContent) {
                        return this.buildSimpleContent(type, v);
                    }
                    if (canHaveTextContent) {
                        return this.buildTextContent(type, v);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (isSimpleContent || canHaveTextContent) {
                if (value == null && !descriptor.isNillable()) {
                    return List.of();
                }
                if (isSimpleContent) {
                    return List.of(this.buildSimpleContent(type, value));
                }
                if (canHaveTextContent) {
                    return List.of(this.buildTextContent(type, value));
                }
                return List.of();
            }
        }
        if (binding == String.class && value instanceof Collection) {
            String collectionString = value.toString();
            return collectionString.substring(1, collectionString.length() - 1);
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            return literal.evaluate(literal.getValue(), binding);
        }
        return this.FF.literal(value).evaluate(value, binding);
    }

    static AttributeType getSimpleContentType(AttributeType type) {
        Class binding = type.getBinding();
        if (binding == Collection.class) {
            return XPath.getSimpleContentType(type.getSuper());
        }
        return type;
    }

    Attribute buildSimpleContent(AttributeType type, Object value) {
        AttributeType simpleContentType = XPath.getSimpleContentType(type);
        return this.buildSimpleContentInternal(simpleContentType, value);
    }

    Attribute buildTextContent(AttributeType type, Object value) {
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.setName(ComplexFeatureConstants.SIMPLE_CONTENT.getLocalPart());
        atb.setBinding(String.class);
        AttributeType textContentType = atb.buildType();
        return this.buildSimpleContentInternal(textContentType, value);
    }

    private Attribute buildSimpleContentInternal(AttributeType simpleContentType, Object value) {
        Object convertedValue = this.FF.literal(value).evaluate(value, simpleContentType.getBinding());
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(simpleContentType, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        return new AttributeImpl(convertedValue, (AttributeDescriptor)descriptor, null);
    }

    public boolean isComplexType(XPathUtil.StepList attrXPath, AttributeDescriptor featureType) {
        PropertyName attExp = this.FF.property(attrXPath.toString());
        Object type = attExp.evaluate((Object)featureType);
        if (type == null) {
            type = attExp.evaluate((Object)featureType);
            throw new IllegalArgumentException("path not found: " + attrXPath);
        }
        AttributeDescriptor node = (AttributeDescriptor)type;
        return node.getType() instanceof ComplexType;
    }

    public static boolean isId(XPathUtil.Step step) {
        return step.isXmlAttribute() && step.getName().equals(GML.id);
    }

    private boolean isUnboundedMultivalue(Attribute parent) {
        Object value = parent.getUserData().get("multi_value_type");
        if (value instanceof String) {
            return "unbounded-multi-value".equals(value);
        }
        return false;
    }
}

