/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.complex.IndexQueryManager;
import org.geotools.data.complex.IndexesTest;
import org.geotools.data.complex.TestFeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.feature.FeatureCollection;
import org.junit.Assert;
import org.junit.Test;

public class PartialIndexQueryManagerTest
extends IndexesTest {
    @Test
    public void testIndexQuery() throws IOException, URISyntaxException {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            Filter filter = this.partialIndexedFilter_2idxfilterResults();
            Query query = new Query("stationsIndexed", filter);
            IndexQueryManager.PartialIndexQueryManager piqm = new IndexQueryManager.PartialIndexQueryManager(fsource.getMappedSource().getMapping(), query);
            Query indexQuery = piqm.getIndexQuery();
            Assert.assertNotNull((Object)indexQuery);
            List<Filter> filters = Arrays.asList(this.totallyIndexedFilter(), this.totallyIndexedFilter2());
            And expectedFilter = this.ff.and(filters);
            Assert.assertEquals((Object)expectedFilter, (Object)indexQuery.getFilter());
            Query combQuery = piqm.buildCombinedQuery(this.indexFeatureCollection());
            Assert.assertNotNull((Object)combQuery);
            Filter ultimateFilter = combQuery.getFilter();
            Assert.assertNotEquals((Object)filter, (Object)ultimateFilter);
            Assert.assertTrue((boolean)(ultimateFilter instanceof And));
            And mainAnd = (And)ultimateFilter;
            Assert.assertEquals(mainAnd.getChildren().get(0), (Object)this.buildIdInExpression(Arrays.asList("st.2", "st.3"), fsource.getMappedSource().getMapping()));
        }
    }

    private FeatureCollection<? extends FeatureType, ? extends Feature> indexFeatureCollection() throws IOException, URISyntaxException {
        File dir = new File(this.getClass().getResource("/test-data/index/").toURI());
        PropertyDataStore datastore = new PropertyDataStore(dir);
        FilterFactory ff1 = datastore.getFilterFactory();
        Query query = new Query("stationsIndex", (Filter)ff1.or((Filter)ff1.equals((Expression)ff1.property("NAME"), (Expression)ff1.literal((Object)"station2")), (Filter)ff1.equals((Expression)ff1.property("NAME"), (Expression)ff1.literal((Object)"station3"))));
        return datastore.getFeatureSource("stationsIndex").getFeatures(query);
    }
}

