/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.net.URL;
import java.util.HashMap;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class SweValuesTest {
    public static final String OM_NS = "http://www.opengis.net/om/2.0";
    public static final String SWE_NS = "http://www.opengis.net/swe/2.0";
    public static final String GML_NS = "http://www.opengis.net/gml/3.2";
    public static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    public static final Name OBSERVATION_TYPE = Types.typeName((String)"http://www.opengis.net/om/2.0", (String)"OM_ObservationType");
    public static final Name OBSERVATION_FEATURE = Types.typeName((String)"http://www.opengis.net/om/2.0", (String)"OM_Observation");
    public static final String SWE_VALUES_MAPPING = "/test-data/sweValuesAsList.xml";
    private static FilterFactory ff;
    private static FeatureSource<FeatureType, Feature> obsSource;
    private static FeatureCollection<FeatureType, Feature> obsFeatures;
    private NamespaceSupport namespaces = new NamespaceSupport();

    public SweValuesTest() {
        this.namespaces.declarePrefix("om", OM_NS);
        this.namespaces.declarePrefix("swe", SWE_NS);
        this.namespaces.declarePrefix("gml", GML_NS);
        this.namespaces.declarePrefix("xlink", XLINK_NS);
        ff = new FilterFactoryImplNamespaceAware(this.namespaces);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        SweValuesTest.loadDataAccesses();
    }

    private static void loadDataAccesses() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = SweValuesTest.class.getResource(SWE_VALUES_MAPPING);
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess omsoDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)omsoDataAccess);
        FeatureType observationFeatureType = omsoDataAccess.getSchema(OBSERVATION_FEATURE);
        Assert.assertNotNull((Object)observationFeatureType);
        obsSource = omsoDataAccess.getFeatureSource(OBSERVATION_FEATURE);
        obsFeatures = obsSource.getFeatures();
        Assert.assertEquals((long)2L, (long)SweValuesTest.size(obsFeatures));
    }

    static int size(FeatureCollection features) {
        int size = 0;
        try (FeatureIterator iterator = features.features();){
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
            int n = size;
            return n;
        }
    }

    @Test
    public void testSweValues() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("ID1.2", "missing missing 8.9 7.9 14.2 15.4 18.1 19.1 21.7 20.8 19.6 14.9 10.8 8.8 8.5 10.4");
        expected.put("ID2.2", "16.2 17.1 22.0 25.1 23.9 22.8 17.0 10.2 9.2 7.1 12.3 12.9 17.2 23.6 21.6 21.9 17.6 14.0 9.3 3.8");
        try (FeatureIterator featIt = obsFeatures.features();){
            while (featIt.hasNext()) {
                Feature f = featIt.next();
                PropertyName pf = ff.property("om:result/swe:DataArray/swe:values", this.namespaces);
                Object sweValues = pf.evaluate((Object)f);
                Assert.assertNotNull((Object)sweValues);
                Assert.assertTrue((boolean)(sweValues instanceof ComplexAttribute));
                ComplexAttribute sweValuesAttr = (ComplexAttribute)sweValues;
                Assert.assertEquals(expected.get(f.getIdentifier().getID()), (Object)sweValuesAttr.getProperty(ComplexFeatureConstants.SIMPLE_CONTENT).getValue());
            }
        }
    }
}

