/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.IOException;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.config.AppSchemaFeatureTypeRegistry;
import org.geotools.data.complex.util.EmfComplexFeatureReader;
import org.geotools.feature.NameImpl;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.xml.resolver.SchemaResolver;
import org.geotools.xsd.SchemaIndex;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaFeatureTypeRegistryTest
extends AppSchemaTestSupport {
    private static final String BOREHOLE_NS = "http://xmlns.geosciml.org/Borehole/3.2";
    private static final Name BOREHOLE_TYPE = new NameImpl("http://xmlns.geosciml.org/Borehole/3.2", "BoreholeType");
    private static SchemaIndex schemaIndex;
    private static NamespaceSupport gml32NS;

    @BeforeClass
    public static void oneTimeSetUp() throws IOException {
        SchemaResolver resolver = new SchemaResolver();
        String schemalocation = SchemaResolver.resolveClasspathLocation((String)"http://schemas.geosciml.org/borehole/3.2/borehole.xsd");
        EmfComplexFeatureReader schemaParser = EmfComplexFeatureReader.newInstance();
        schemaParser.setResolver(resolver);
        schemaIndex = schemaParser.parse(BOREHOLE_NS, schemalocation);
        gml32NS = new NamespaceSupport();
        gml32NS.declarePrefix("gml", "http://www.opengis.net/gml/3.2");
    }

    @Test
    public void testGML32Declared() {
        AppSchemaFeatureTypeRegistry registry = new AppSchemaFeatureTypeRegistry(gml32NS);
        registry.addSchemas(schemaIndex);
        AttributeType type = registry.getAttributeType(BOREHOLE_TYPE);
        Assert.assertTrue((boolean)(type instanceof FeatureType));
    }

    @Test
    public void testGML32Undeclared() {
        AppSchemaFeatureTypeRegistry registry = new AppSchemaFeatureTypeRegistry();
        registry.addSchemas(schemaIndex);
        AttributeType type = registry.getAttributeType(BOREHOLE_TYPE);
        Assert.assertTrue((boolean)(type instanceof FeatureType));
    }
}

