/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.util.URLs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AppSchemaFileDataTest
extends AppSchemaTestSupport {
    private static final String testData = "/test-data/";
    private static final File testDir = new File("target/test/" + AppSchemaFileDataTest.class.getSimpleName());

    @Before
    public void setUp() throws IOException {
        FileUtils.deleteDirectory((File)testDir);
        AppSchemaFileDataTest.copyTestData("ArchSite.xsd", testDir);
        AppSchemaFileDataTest.copyTestData("ArchSiteNillable.xml", testDir);
        AppSchemaFileDataTest.copyTestData("AppSchemaFileDataTest.xml", testDir);
        AppSchemaFileDataTest.copyTestData("PointFeatureGeomPropertyfile.properties", new File(testDir, "directory"));
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)testDir);
        AppSchemaDataAccessRegistry.unregisterAndDisposeAll();
    }

    private static void copyTestData(String baseFileName, File destDir) throws IOException {
        destDir.mkdirs();
        FileUtils.copyFileToDirectory((File)URLs.urlToFile((URL)AppSchemaFileDataTest.class.getResource(testData + baseFileName)), (File)destDir);
    }

    private static String getTestDirPath(String baseFileName) {
        return new File(testDir, baseFileName).getPath();
    }

    @Test
    public void testShapeMappings() throws Exception {
        String mappingFileNameRelativeShape = "ArchSiteNillable.xml";
        AppSchemaDataAccess dSRelative = null;
        try {
            dSRelative = this.buildDataAccess(mappingFileNameRelativeShape);
            Assert.assertEquals((long)1L, (long)dSRelative.getNames().size());
            Assert.assertEquals((long)25L, (long)this.countFeatures(dSRelative));
        }
        finally {
            if (dSRelative != null) {
                dSRelative.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShapeMappingsAbsolute() throws Exception {
        String mappingFileNameRelativeShape = "ArchSiteNillable.xml";
        String configFilePathRelativeShape = AppSchemaFileDataTest.getTestDirPath(mappingFileNameRelativeShape);
        String mappingFileNameAbsoluteShape = "ArchSiteAbsolute.xml";
        String configFilePathAbsoluteShape = AppSchemaFileDataTest.getTestDirPath(mappingFileNameAbsoluteShape);
        AppSchemaDataAccess dSAbsolute = null;
        try {
            this.copyRelativeToAbsolute(configFilePathRelativeShape, configFilePathAbsoluteShape);
            dSAbsolute = this.buildDataAccess(mappingFileNameAbsoluteShape);
            Assert.assertEquals((long)1L, (long)dSAbsolute.getNames().size());
            Assert.assertEquals((long)25L, (long)this.countFeatures(dSAbsolute));
        }
        finally {
            if (dSAbsolute != null) {
                dSAbsolute.dispose();
            }
        }
    }

    @Test
    public void testPropertiesMappings() throws Exception {
        String mappingFileNameRelativeProperties = "AppSchemaFileDataTest.xml";
        AppSchemaDataAccess dSRelative = null;
        try {
            dSRelative = this.buildDataAccess(mappingFileNameRelativeProperties);
            Assert.assertEquals((long)1L, (long)dSRelative.getNames().size());
            Assert.assertEquals((long)2L, (long)this.countFeatures(dSRelative));
        }
        finally {
            if (dSRelative != null) {
                dSRelative.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesMappingsAbsolute() throws Exception {
        String mappingFileNameRelativeProperties = "AppSchemaFileDataTest.xml";
        String configFilePathRelativeProperties = AppSchemaFileDataTest.getTestDirPath(mappingFileNameRelativeProperties);
        String mappingFileNameAbsoluteProperties = "AppSchemaFileDataTestAbsolute.xml";
        String configFilePathAbsoluteProperties = AppSchemaFileDataTest.getTestDirPath(mappingFileNameAbsoluteProperties);
        AppSchemaDataAccess dSAbsolute = null;
        try {
            this.copyRelativeToAbsolute(configFilePathRelativeProperties, configFilePathAbsoluteProperties);
            dSAbsolute = this.buildDataAccess(mappingFileNameAbsoluteProperties);
            Assert.assertEquals((long)1L, (long)dSAbsolute.getNames().size());
            Assert.assertEquals((long)2L, (long)this.countFeatures(dSAbsolute));
        }
        finally {
            if (dSAbsolute != null) {
                dSAbsolute.dispose();
            }
        }
    }

    private int countFeatures(AppSchemaDataAccess dS) throws Exception {
        Name[] dSNameArray = dS.getTypeNames();
        String testType = dSNameArray[0].toString();
        FeatureSource featureSource = dS.getFeatureSourceByName(dSNameArray[0]);
        int numFeatures = featureSource.getCount(new Query(testType));
        return numFeatures;
    }

    private AppSchemaDataAccess buildDataAccess(String mappingsFileName) throws Exception {
        String configFilePath = this.extendFilename(testDir.getPath(), mappingsFileName);
        URL configFileUrl = URLs.fileToUrl((File)new File(configFilePath));
        XMLConfigDigester configReader = new XMLConfigDigester();
        AppSchemaDataAccessDTO config = configReader.parse(configFileUrl);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        AppSchemaDataAccess datastore = new AppSchemaDataAccess(mappings);
        return datastore;
    }

    private String copyRelativeToAbsolute(String filePathIn, String filePathOut) throws Exception {
        String absolutePath = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePathIn));
             PrintWriter writer = new PrintWriter(new FileWriter(filePathOut));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("<value>file:")) {
                    String relativePath = line.split("<value>file:|</value>")[1];
                    String resolvedPath = this.extendFilename(testDir.getPath(), relativePath);
                    absolutePath = new File(resolvedPath).getAbsolutePath();
                    line = line.replace(relativePath, absolutePath);
                }
                if (line.trim().startsWith("<OCQL>")) {
                    line = line.replace("if_then_else(equalTo(CAT_DESC, 'No Name'), Expression.Nil , CAT_DESC)", "CAT_DESC");
                }
                writer.println(line);
            }
        }
        return absolutePath;
    }

    private String extendFilename(String baseFilename, String relativePath) throws RuntimeException {
        String extendedFilename = FilenameUtils.concat((String)(baseFilename = new File(baseFilename).getAbsolutePath()), (String)relativePath);
        if (extendedFilename == null) {
            throw new RuntimeException("Relative path to datastore is incompatible with the base path - check double dot steps.");
        }
        return extendedFilename;
    }
}

