/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.jndi;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.geotools.arcsde.logging.Loggers;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.ISessionPoolFactory;
import org.geotools.arcsde.session.UnavailableConnectionException;

public final class SharedSessionPool
implements ISessionPool {
    private static final Logger LOGGER = Loggers.getLogger("org.geotools.arcsde.session");
    private static final AtomicInteger instanceCounter = new AtomicInteger();
    private final int instanceNumber;
    private final ISessionPool delegate;
    private static final Map<ArcSDEConnectionConfig, SharedSessionPool> instances = Collections.synchronizedMap(new WeakHashMap());

    protected SharedSessionPool(ISessionPool delegate) throws IOException {
        this.delegate = delegate;
        this.instanceNumber = instanceCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISessionPool getInstance(ArcSDEConnectionConfig config, ISessionPoolFactory factory) throws IOException {
        LOGGER.info("Getting shared session pool for " + config);
        if (!instances.containsKey(config)) {
            Map<ArcSDEConnectionConfig, SharedSessionPool> map = instances;
            synchronized (map) {
                if (!instances.containsKey(config)) {
                    LOGGER.info("Creating shared session pool for " + config);
                    ISessionPool pool = factory.createPool(config);
                    SharedSessionPool sharedPool = new SharedSessionPool(pool);
                    instances.put(config, sharedPool);
                    LOGGER.info("Created shared pool " + sharedPool);
                }
            }
        }
        SharedSessionPool sharedPool = instances.get(config);
        LOGGER.info("Returning shared session pool " + sharedPool);
        return sharedPool;
    }

    protected void finalize() {
        LOGGER.info("Destroying session pool for " + this.getConfig());
        this.delegate.close();
    }

    @Override
    public void close() {
        LOGGER.info("Ignoring SessionPool close, this is a shared pool");
    }

    @Override
    public int getAvailableCount() {
        return this.delegate.getAvailableCount();
    }

    @Override
    public ArcSDEConnectionConfig getConfig() {
        return this.delegate.getConfig();
    }

    @Override
    public int getInUseCount() {
        return this.delegate.getInUseCount();
    }

    @Override
    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    @Override
    public ISession getSession() throws IOException, UnavailableConnectionException {
        return this.getSession(true);
    }

    @Override
    public ISession getSession(boolean transactional) throws IOException, UnavailableConnectionException {
        return this.delegate.getSession(transactional);
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[(").append(this.instanceNumber).append("), ");
        sb.append("delegate=").append(this.delegate).append("]");
        return sb.toString();
    }
}

