/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeDBMSInfo;
import com.esri.sde.sdk.client.SeDelete;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeRasterColumn;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRelease;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeStreamOp;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeUpdate;
import com.esri.sde.sdk.geom.GeometryFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.logging.Loggers;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.Commands;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.SdeRow;
import org.geotools.arcsde.session.SessionPool;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;

class Session
implements ISession {
    private static final Logger LOGGER = Loggers.getLogger("org.geotools.arcsde.session");
    private static final int AUTO_CLOSE_COUNTER_THRESHOLD;
    private int autoCloseCounter;
    protected static final long TEST_SERVER_ROUNDTRIP_INTERVAL_SECONDS = 5L;
    private final SeConnection connection;
    private final SessionPool pool;
    private final ArcSDEConnectionConfig config;
    private static final AtomicInteger sessionCounter;
    private final int sessionId;
    private boolean transactionInProgress;
    private boolean isPassivated;
    private Map<String, SeTable> cachedTables = new WeakHashMap<String, SeTable>();
    private Map<String, SeLayer> cachedLayers = new WeakHashMap<String, SeLayer>();
    private final AtomicInteger referenceCounter = new AtomicInteger();

    Session(SessionPool pool, ArcSDEConnectionConfig config) throws IOException {
        this.sessionId = sessionCounter.incrementAndGet();
        this.config = config;
        this.pool = pool;
        CreateSeConnectionCommand connectionCommand = new CreateSeConnectionCommand(config, this.sessionId);
        try {
            this.connection = this.issue(connectionCommand);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException shouldntHappen) {
            throw shouldntHappen;
        }
    }

    @Override
    public synchronized <T> T issue(Command<T> command) throws IOException {
        try {
            if (this.connection == null) {
                return command.execute(this, null);
            }
            return command.execute(this, this.connection);
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
    }

    @Override
    public final void testServer() throws IOException {
        long secondsSinceLastServerRoundTrip = this.connection.getTimeSinceLastRT();
        if (5L < secondsSinceLastServerRoundTrip) {
            this.issue(Commands.TEST_SERVER);
        }
    }

    @Override
    public final boolean isClosed() {
        return this.connection.isClosed();
    }

    void markActive() {
        this.referenceCounter.incrementAndGet();
        this.isPassivated = false;
    }

    void markInactive() {
        if (this.referenceCounter.get() != 0) {
            throw new IllegalStateException("referenceCount = " + this.referenceCounter);
        }
        this.isPassivated = true;
    }

    @Override
    public boolean isDisposed() {
        return this.isPassivated;
    }

    private void checkActive() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Unrecoverable error: " + this.toString() + " is passivated, shall not be used!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeLayer getLayer(String layerName) throws IOException {
        SeLayer seLayer;
        this.checkActive();
        if (!this.cachedLayers.containsKey(layerName)) {
            Map<String, SeLayer> map = this.cachedLayers;
            synchronized (map) {
                SeTable table;
                SeLayer layer;
                if (!this.cachedLayers.containsKey(layerName) && (layer = this.issue(new Commands.GetLayerCommand(table = this.getTable(layerName)))) != null) {
                    this.cachedLayers.put(layerName, layer);
                }
            }
        }
        if ((seLayer = this.cachedLayers.get(layerName)) == null) {
            throw new NoSuchElementException("Layer '" + layerName + "' not found");
        }
        return seLayer;
    }

    @Override
    public synchronized SeRasterColumn getRasterColumn(String rasterName) throws IOException {
        throw new UnsupportedOperationException("Waiting for a proper implementation");
    }

    @Override
    public List<String> getRasterColumns() throws IOException {
        this.checkActive();
        List<String> rasterNames = this.issue(Commands.GET_RASTER_COLUMN_NAMES);
        return rasterNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeTable getTable(String tableName) throws IOException {
        this.checkActive();
        if (!this.cachedTables.containsKey(tableName)) {
            Map<String, SeTable> map = this.cachedTables;
            synchronized (map) {
                if (!this.cachedTables.containsKey(tableName)) {
                    SeTable table = this.issue(new Commands.GetTableCommand(tableName));
                    this.cachedTables.put(tableName, table);
                }
            }
        }
        SeTable seTable = this.cachedTables.get(tableName);
        return seTable;
    }

    @Override
    public void startTransaction() throws IOException {
        this.checkActive();
        this.issue(Commands.START_TRANSACTION);
        this.transactionInProgress = true;
    }

    @Override
    public void commitTransaction() throws IOException {
        this.checkActive();
        this.issue(Commands.COMMIT_TRANSACTION);
        this.transactionInProgress = false;
    }

    @Override
    public boolean isTransactionActive() {
        this.checkActive();
        return this.transactionInProgress;
    }

    @Override
    public void rollbackTransaction() throws IOException {
        this.checkActive();
        try {
            this.issue(Commands.ROLLBACK_TRANSACTION);
        }
        finally {
            this.transactionInProgress = false;
        }
    }

    @Override
    public void dispose() throws IllegalStateException {
        this.checkActive();
        int refCount = this.referenceCounter.decrementAndGet();
        if (refCount > 0) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("---------> Ignoring disposal, ref count is still " + refCount + " for " + this);
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("  -> RefCount is " + refCount + ". Disposing " + this);
        }
        if (this.transactionInProgress) {
            throw new IllegalStateException("Transaction is in progress, should commit or rollback before closing");
        }
        if (this.autoCloseCounter >= AUTO_CLOSE_COUNTER_THRESHOLD) {
            LOGGER.warning("Auto-closing " + this + " to avoid memory leak in ESRI Java API (see GEOT-3227)");
            this.destroy();
        }
        try {
            this.pool.returnObject(this);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public String toString() {
        return "Session[" + this.sessionId + "]";
    }

    void destroy() {
        LOGGER.fine("Destroying connection " + this.toString());
        try {
            this.issue(Commands.CLOSE_CONNECTION);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "closing connection " + this.toString(), e);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public int hashCode() {
        return 0x11 ^ this.config.hashCode();
    }

    @Override
    public List<SeLayer> getLayers() throws IOException {
        return this.issue(Commands.GET_LAYERS);
    }

    @Override
    public String getUser() throws IOException {
        return this.issue(Commands.GET_USER);
    }

    @Override
    public SeRelease getRelease() throws IOException {
        return this.issue(Commands.GET_RELEASE);
    }

    @Override
    public String getDatabaseName() throws IOException {
        return this.issue(Commands.GET_DATABASENAME);
    }

    @Override
    public SeDBMSInfo getDBMSInfo() throws IOException {
        return this.issue(Commands.GET_DBMS_INFO);
    }

    @Override
    public SeRegistration createSeRegistration(String typeName) throws IOException {
        return this.issue(new Commands.CreateSeRegistrationCommand(typeName));
    }

    @Override
    public SeTable createSeTable(String qualifiedName) throws IOException {
        return this.issue(new Commands.CreateSeTableCommand(qualifiedName));
    }

    @Override
    public SeInsert createSeInsert() throws IOException {
        return this.issue(Commands.CREATE_SEINSERT);
    }

    @Override
    public SeUpdate createSeUpdate() throws IOException {
        return this.issue(Commands.CREATE_SEUPDATE);
    }

    @Override
    public SeDelete createSeDelete() throws IOException {
        return this.issue(Commands.CREATE_SEDELETE);
    }

    @Override
    public SeColumnDefinition[] describe(String tableName) throws IOException {
        SeTable table = this.getTable(tableName);
        return this.describe(table);
    }

    @Override
    public SeColumnDefinition[] describe(SeTable table) throws IOException {
        return this.issue(new Commands.DescribeTableCommand(table));
    }

    @Override
    public SdeRow fetch(SeQuery query) throws IOException {
        return this.fetch(query, new SdeRow((GeometryFactory)null));
    }

    @Override
    public SdeRow fetch(SeQuery query, SdeRow currentRow) throws IOException {
        return this.issue(new Commands.FetchRowCommand(query, currentRow));
    }

    @Override
    public void close(SeState state) throws IOException {
        this.issue(new Commands.CloseStateCommand(state));
    }

    @Override
    public void close(SeStreamOp stream) throws IOException {
        this.issue(new Commands.CloseStreamCommand(stream));
    }

    @Override
    public SeState createState(SeObjectId stateId) throws IOException {
        return this.issue(new Commands.CreateSeStateCommand(stateId));
    }

    @Override
    public SeQuery createAndExecuteQuery(String[] propertyNames, SeSqlConstruct sql) throws IOException {
        ++this.autoCloseCounter;
        return this.issue(new Commands.CreateAndExecuteQueryCommand(propertyNames, sql));
    }

    @Override
    public SeState createChildState(long parentStateId) throws IOException {
        return this.issue(new Commands.CreateVersionStateCommand(parentStateId));
    }

    @Override
    public SeQuery prepareQuery(SeQueryInfo qInfo, SeFilter[] spatialConstraints, ArcSdeVersionHandler version) throws IOException {
        ++this.autoCloseCounter;
        return this.issue(new Commands.PrepareQueryCommand(qInfo, spatialConstraints, version));
    }

    static {
        Integer systemPropValue = Integer.getInteger("org.geotools.arcsde.session.AutoCloseThreshold");
        AUTO_CLOSE_COUNTER_THRESHOLD = systemPropValue == null ? 500 : systemPropValue;
        LOGGER.info("Session auto-close threshold set to " + AUTO_CLOSE_COUNTER_THRESHOLD);
        sessionCounter = new AtomicInteger();
    }

    private static final class CreateSeConnectionCommand
    extends Command<SeConnection> {
        private final ArcSDEConnectionConfig config;
        private final int sessionId;

        private CreateSeConnectionCommand(ArcSDEConnectionConfig config, int sessionId) {
            this.config = config;
            this.sessionId = sessionId;
        }

        @Override
        public SeConnection execute(ISession session, SeConnection connection) throws SeException, IOException {
            String serverName = this.config.getServerName();
            String portNumber = this.config.getPortNumber();
            String databaseName = this.config.getDatabaseName();
            String userName = this.config.getUserName();
            String userPassword = this.config.getPassword();
            NegativeArraySizeException cause = null;
            SeConnection conn = null;
            try {
                for (int i = 0; i < 3; ++i) {
                    try {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Creating connection for session #" + this.sessionId + "(try " + (i + 1) + " of 3)");
                        }
                        conn = new SeConnection(serverName, portNumber, databaseName, userName, userPassword);
                        break;
                    }
                    catch (NegativeArraySizeException nase) {
                        LOGGER.warning("Strange failed ArcSDE connection error.  Trying again (try " + (i + 1) + " of 3). SessionId: " + this.sessionId);
                        cause = nase;
                        continue;
                    }
                }
            }
            catch (SeException e) {
                throw new ArcSdeException("Can't create connection to " + serverName + " for Session #" + this.sessionId, e);
            }
            catch (RuntimeException e) {
                throw (IOException)new IOException("Can't create connection to " + serverName + " for Session #" + this.sessionId).initCause(e);
            }
            if (cause != null) {
                throw (IOException)new IOException("Couldn't create ArcSDE connection to " + serverName + " for Session #" + this.sessionId + " because of strange SDE internal exception.  Tried 3 times, giving up.").initCause(cause);
            }
            return conn;
        }
    }
}

