/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.awt.Color;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.styling.ColorMapEntry;
import org.geotools.util.Converters;
import org.opengis.filter.expression.Expression;

public class ColorMapEntryBuilder
extends AbstractStyleBuilder<ColorMapEntry> {
    String label;
    Expression color;
    Expression opacity;
    Expression quantity;

    public ColorMapEntryBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public ColorMapEntryBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public ColorMapEntryBuilder color(Expression color) {
        this.color = color;
        return this;
    }

    public ColorMapEntryBuilder color(Color color) {
        return this.color(this.literal(color));
    }

    public ColorMapEntryBuilder colorHex(String hex) {
        Color color = (Color)Converters.convert((Object)hex, Color.class);
        if (color == null) {
            throw new IllegalArgumentException("The provided expression could not be turned into a color: " + hex);
        }
        return this.color(color);
    }

    public ColorMapEntryBuilder color(String cqlExpression) {
        return this.color(this.cqlExpression(cqlExpression));
    }

    public ColorMapEntryBuilder colorAsLiteral(String color) {
        return this.color(this.literal(color));
    }

    public ColorMapEntryBuilder opacity(Expression opacity) {
        this.opacity = opacity;
        return this;
    }

    public ColorMapEntryBuilder opacity(double opacity) {
        return this.opacity(this.literal(opacity));
    }

    public ColorMapEntryBuilder opacity(String cqlExpression) {
        return this.opacity(this.cqlExpression(cqlExpression));
    }

    public ColorMapEntryBuilder opacityAsLiteral(String opacity) {
        return this.opacity(this.literal(opacity));
    }

    public ColorMapEntryBuilder quantity(Expression quantity) {
        this.quantity = quantity;
        return this;
    }

    public ColorMapEntryBuilder quantity(double quantity) {
        return this.quantity(this.literal(quantity));
    }

    public ColorMapEntryBuilder quantityAsLiteral(String quantity) {
        return this.quantity(this.literal(quantity));
    }

    public ColorMapEntryBuilder quantity(String cqlExpression) {
        return this.quantity(this.cqlExpression(cqlExpression));
    }

    public ColorMapEntryBuilder label(String label) {
        this.label = label;
        return this;
    }

    public ColorMapEntryBuilder reset() {
        this.label = null;
        this.color = null;
        this.opacity = this.literal(1.0);
        this.quantity = null;
        this.unset = false;
        return this;
    }

    public ColorMapEntryBuilder reset(ColorMapEntry original) {
        if (original == null) {
            return this.unset();
        }
        this.label = original.getLabel();
        this.color = original.getColor();
        this.opacity = original.getOpacity();
        this.quantity = original.getQuantity();
        this.unset = false;
        return this;
    }

    @Override
    public ColorMapEntry build() {
        if (this.unset) {
            return null;
        }
        ColorMapEntry entry = this.sf.createColorMapEntry();
        entry.setLabel(this.label);
        entry.setColor(this.color);
        entry.setOpacity(this.opacity);
        entry.setQuantity(this.quantity);
        if (this.parent == null) {
            this.reset();
        }
        return entry;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().raster().colorMap().entry().init(this);
    }

    @Override
    public ColorMapEntryBuilder unset() {
        return (ColorMapEntryBuilder)super.unset();
    }
}

