/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.brewer.styling.builder.AbstractSLDBuilder;
import org.geotools.brewer.styling.builder.Builder;
import org.geotools.brewer.styling.builder.FillBuilder;
import org.geotools.brewer.styling.builder.FontBuilder;
import org.geotools.brewer.styling.builder.GraphicBuilder;
import org.geotools.brewer.styling.builder.HaloBuilder;
import org.geotools.brewer.styling.builder.LinePlacementBuilder;
import org.geotools.brewer.styling.builder.PointPlacementBuilder;
import org.geotools.brewer.styling.builder.RuleBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.brewer.styling.builder.SymbolizerBuilder;
import org.geotools.styling.Font;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.Halo;

public class TextSymbolizerBuilder
extends SymbolizerBuilder<TextSymbolizer> {
    FillBuilder fill = new FillBuilder(this).unset();
    List<FontBuilder> fonts = new ArrayList<FontBuilder>();
    FontBuilder font;
    HaloBuilder halo = new HaloBuilder(this).unset();
    Expression label;
    Expression geometry = null;
    Unit<Length> uom;
    GraphicBuilder shield = new GraphicBuilder(this).unset();
    Builder<? extends LabelPlacement> placement = new PointPlacementBuilder(this).unset();
    private Expression priority;

    public TextSymbolizerBuilder() {
        this((RuleBuilder)null);
    }

    public TextSymbolizerBuilder(RuleBuilder parent) {
        super((AbstractSLDBuilder)parent);
        this.reset();
    }

    public TextSymbolizerBuilder geometry(Expression geometry) {
        this.geometry = geometry;
        return this;
    }

    public TextSymbolizerBuilder geometry(String cqlExpression) {
        return this.geometry(this.cqlExpression(cqlExpression));
    }

    public HaloBuilder halo() {
        this.unset = false;
        return this.halo;
    }

    public FillBuilder fill() {
        this.unset = false;
        return this.fill;
    }

    public FontBuilder newFont() {
        this.unset = false;
        FontBuilder font = new FontBuilder(this);
        this.fonts.add(font);
        return font;
    }

    public LinePlacementBuilder linePlacement() {
        if (!(this.placement instanceof LinePlacementBuilder)) {
            this.placement = new LinePlacementBuilder(this);
        }
        this.unset = false;
        return (LinePlacementBuilder)this.placement;
    }

    public PointPlacementBuilder pointPlacement() {
        if (!(this.placement instanceof PointPlacementBuilder)) {
            this.placement = new PointPlacementBuilder(this);
        }
        this.unset = false;
        return (PointPlacementBuilder)this.placement;
    }

    public TextSymbolizerBuilder uom(Unit<Length> uom) {
        this.unset = false;
        this.uom = uom;
        return this;
    }

    public GraphicBuilder shield() {
        this.unset = false;
        return this.shield;
    }

    @Override
    public TextSymbolizer build() {
        if (this.unset) {
            return null;
        }
        Font[] array = null;
        if (!this.fonts.isEmpty()) {
            array = new Font[this.fonts.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.fonts.get(i).build();
            }
        }
        TextSymbolizer ts = this.sf.createTextSymbolizer(this.fill.build(), array, this.halo.build(), this.label, this.placement.build(), null);
        ts.setGeometry(this.geometry);
        if (this.uom != null) {
            ts.setUnitOfMeasure(this.uom);
        }
        ts.getOptions().putAll(this.options);
        ts.setPriority(this.priority);
        if (ts instanceof TextSymbolizer2) {
            TextSymbolizer2 ts2 = (TextSymbolizer2)ts;
            if (!this.shield.isUnset()) {
                ts2.setGraphic(this.shield.build());
            }
        }
        this.reset();
        return ts;
    }

    @Override
    public TextSymbolizerBuilder unset() {
        return (TextSymbolizerBuilder)super.unset();
    }

    public TextSymbolizerBuilder reset() {
        this.fill.reset();
        this.halo.unset();
        this.label = null;
        this.geometry = null;
        this.placement.reset();
        this.placement.unset();
        this.options.clear();
        this.uom = null;
        this.priority = null;
        this.unset = false;
        return this;
    }

    public TextSymbolizerBuilder reset(TextSymbolizer symbolizer) {
        this.fill.reset((Fill)symbolizer.getFill());
        this.halo.reset((Halo)symbolizer.getHalo());
        this.label = symbolizer.getLabel();
        this.geometry = null;
        LabelPlacement otherPlacement = symbolizer.getLabelPlacement();
        if (symbolizer.getLabelPlacement() instanceof PointPlacement) {
            PointPlacementBuilder builder = new PointPlacementBuilder(this);
            builder.reset((PointPlacement)otherPlacement);
            this.placement = builder;
        } else if (symbolizer.getLabelPlacement() instanceof LabelPlacement) {
            LinePlacementBuilder builder = new LinePlacementBuilder(this);
            builder.reset((LinePlacement)otherPlacement);
            this.placement = builder;
        } else {
            throw new IllegalArgumentException("Unrecognized label placement: " + otherPlacement);
        }
        this.priority = symbolizer.getPriority();
        this.unset = false;
        return this;
    }

    public TextSymbolizerBuilder option(String name, Object value) {
        this.options.put(name, value.toString());
        this.unset = false;
        return this;
    }

    public TextSymbolizerBuilder label(Expression label) {
        this.unset = false;
        this.label = label;
        return this;
    }

    public TextSymbolizerBuilder label(String cqlExpression) {
        return this.label(this.cqlExpression(cqlExpression));
    }

    public TextSymbolizerBuilder labelText(String text) {
        return this.label(this.literal(text));
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().text().init(this);
    }

    public TextSymbolizerBuilder priority(Expression priority) {
        this.unset = false;
        this.priority = priority;
        return this;
    }

    public TextSymbolizerBuilder priority(String cql) {
        return this.priority(this.cqlExpression(cql));
    }

    public TextSymbolizerBuilder priority(int priority) {
        return this.priority(this.literal(priority));
    }
}

