/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.wrapper;

import java.io.InvalidClassException;
import java.util.ArrayList;
import org.geotools.ExceptionChecker;
import org.geotools.data.complex.feature.wrapper.FeatureWrapper;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FakeTypes;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.wrapper.MineType;
import org.geotools.feature.wrapper.MineType2;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;

public class FeatureWrapperTest {
    private static Feature getFeature() {
        AttributeImpl mineName = new AttributeImpl((Object)"Pieces of Eight - Admiral Hill", FakeTypes.Mine.mineNAME_DESCRIPTOR, (Identifier)new GmlObjectIdImpl("mineName"));
        AttributeImpl isPreferred = new AttributeImpl((Object)true, FakeTypes.Mine.ISPREFERRED_DESCRIPTOR, (Identifier)new GmlObjectIdImpl("isPreferred"));
        ArrayList<AttributeImpl> MineNameTypeProperties = new ArrayList<AttributeImpl>();
        MineNameTypeProperties.add(mineName);
        MineNameTypeProperties.add(isPreferred);
        ComplexAttributeImpl MineNameType2 = new ComplexAttributeImpl(MineNameTypeProperties, FakeTypes.Mine.MINENAMETYPE_TYPE, null);
        ArrayList<ComplexAttributeImpl> MineNameProperties = new ArrayList<ComplexAttributeImpl>();
        MineNameProperties.add(MineNameType2);
        ComplexAttributeImpl MineName = new ComplexAttributeImpl(MineNameProperties, FakeTypes.Mine.MINENAME_DESCRIPTOR, (Identifier)new GmlObjectIdImpl("MineName"));
        ArrayList<ComplexAttributeImpl> MineNamePropertyProperties = new ArrayList<ComplexAttributeImpl>();
        MineNamePropertyProperties.add(MineName);
        ComplexAttributeImpl MineNamePropertyType2 = new ComplexAttributeImpl(MineNamePropertyProperties, FakeTypes.Mine.MINENAMEPROPERTYTYPE_TYPE, null);
        ArrayList<ComplexAttributeImpl> MineProperties = new ArrayList<ComplexAttributeImpl>();
        MineProperties.add(MineNamePropertyType2);
        FeatureImpl mine = new FeatureImpl(MineProperties, FakeTypes.Mine.MINETYPE_TYPE, (FeatureId)new FeatureIdImpl("Mine"));
        return mine;
    }

    @Test
    public void wrap_validFeature_returnsWrappedFeature() throws Exception {
        Feature mine = FeatureWrapperTest.getFeature();
        MineType wrappedMine = (MineType)FeatureWrapper.wrap((ComplexAttribute)mine, MineType.class);
        Assert.assertEquals((Object)"Pieces of Eight - Admiral Hill", (Object)wrappedMine.MineNameProperties.get((int)0).MineName.mineName);
    }

    @Test
    public void wrap_validFeature_canAccessPathDefinedVariables() throws Exception {
        Feature mine = FeatureWrapperTest.getFeature();
        MineType wrappedMine = (MineType)FeatureWrapper.wrap((ComplexAttribute)mine, MineType.class);
        Assert.assertEquals((Object)"Pieces of Eight - Admiral Hill", (Object)wrappedMine.firstName);
    }

    @Test(expected=InvalidClassException.class)
    public void wrap_invalidFeatureCannotResolvePath_throwsInvalidClassException() throws Exception {
        ArrayList properties = new ArrayList();
        FeatureImpl mine = new FeatureImpl(properties, FakeTypes.Mine.MINETYPE_TYPE, (FeatureId)new FeatureIdImpl("Invalid mine."));
        try {
            FeatureWrapper.wrap((ComplexAttribute)mine, MineType.class);
        }
        catch (InvalidClassException ice) {
            ExceptionChecker.assertExceptionMessage((Exception)ice, (String)"Unable to wrap attribute in class 'class org.geotools.feature.wrapper.MineType'. Reference to mineName could not be found in the attribute.");
        }
    }

    @Test(expected=InvalidClassException.class)
    public void wrap_invalidFeatureMissingAttribute_throwsInvalidClassException() throws Exception {
        AttributeImpl isPreferred = new AttributeImpl((Object)true, FakeTypes.Mine.ISPREFERRED_DESCRIPTOR, (Identifier)new GmlObjectIdImpl("isPreferred"));
        ArrayList<AttributeImpl> MineNameTypeProperties = new ArrayList<AttributeImpl>();
        MineNameTypeProperties.add(isPreferred);
        ComplexAttributeImpl MineNameType2 = new ComplexAttributeImpl(MineNameTypeProperties, FakeTypes.Mine.MINENAMETYPE_TYPE, null);
        ArrayList<ComplexAttributeImpl> MineNameProperties = new ArrayList<ComplexAttributeImpl>();
        MineNameProperties.add(MineNameType2);
        ComplexAttributeImpl MineName = new ComplexAttributeImpl(MineNameProperties, FakeTypes.Mine.MINENAME_DESCRIPTOR, (Identifier)new GmlObjectIdImpl("MineName"));
        ArrayList<ComplexAttributeImpl> MineNamePropertyProperties = new ArrayList<ComplexAttributeImpl>();
        MineNamePropertyProperties.add(MineName);
        ComplexAttributeImpl MineNamePropertyType2 = new ComplexAttributeImpl(MineNamePropertyProperties, FakeTypes.Mine.MINENAMEPROPERTYTYPE_TYPE, null);
        ArrayList<ComplexAttributeImpl> MineProperties = new ArrayList<ComplexAttributeImpl>();
        MineProperties.add(MineNamePropertyType2);
        FeatureImpl mine = new FeatureImpl(MineProperties, FakeTypes.Mine.MINETYPE_TYPE, (FeatureId)new FeatureIdImpl("Invalid Mine"));
        try {
            FeatureWrapper.wrap((ComplexAttribute)mine, MineType2.class);
        }
        catch (InvalidClassException ice) {
            ExceptionChecker.assertExceptionMessage((Exception)ice, (String)"Unable to wrap attribute in class 'class org.geotools.feature.wrapper.MineNameType'. urn:org:example:mineName could not be found in the attribute.");
        }
    }

    @Test(expected=InvalidClassException.class)
    public void wrap_invalidFeatureMissingMineNameTypeProperty_throwsInvalidClassException() throws Exception {
        ArrayList MineNameProperties = new ArrayList();
        ComplexAttributeImpl MineName = new ComplexAttributeImpl(MineNameProperties, FakeTypes.Mine.MINENAME_DESCRIPTOR, (Identifier)new GmlObjectIdImpl("MineName"));
        ArrayList<ComplexAttributeImpl> MineNamePropertyProperties = new ArrayList<ComplexAttributeImpl>();
        MineNamePropertyProperties.add(MineName);
        ComplexAttributeImpl MineNamePropertyType2 = new ComplexAttributeImpl(MineNamePropertyProperties, FakeTypes.Mine.MINENAMEPROPERTYTYPE_TYPE, null);
        ArrayList<ComplexAttributeImpl> MineProperties = new ArrayList<ComplexAttributeImpl>();
        MineProperties.add(MineNamePropertyType2);
        FeatureImpl mine = new FeatureImpl(MineProperties, FakeTypes.Mine.MINETYPE_TYPE, (FeatureId)new FeatureIdImpl("Invalid Mine"));
        try {
            FeatureWrapper.wrap((ComplexAttribute)mine, MineType2.class);
        }
        catch (InvalidClassException ice) {
            ExceptionChecker.assertExceptionMessage((Exception)ice, (String)"Unable to wrap attribute in class 'org.geotools.feature.wrapper.MineNamePropertyType'. 'urn:org:example:MineName' doesn't have required property 'urn:org:example:MineNameType'.");
        }
    }

    @Test(expected=InvalidClassException.class)
    public void wrap_invalidFeatureMissingMineName_throwsInvalidClassException() throws Exception {
        ArrayList MineNamePropertyProperties = new ArrayList();
        ComplexAttributeImpl MineNamePropertyType2 = new ComplexAttributeImpl(MineNamePropertyProperties, FakeTypes.Mine.MINENAMEPROPERTYTYPE_TYPE, null);
        ArrayList<ComplexAttributeImpl> MineProperties = new ArrayList<ComplexAttributeImpl>();
        MineProperties.add(MineNamePropertyType2);
        FeatureImpl mine = new FeatureImpl(MineProperties, FakeTypes.Mine.MINETYPE_TYPE, (FeatureId)new FeatureIdImpl("Invalid Mine"));
        try {
            FeatureWrapper.wrap((ComplexAttribute)mine, MineType2.class);
        }
        catch (InvalidClassException ice) {
            ExceptionChecker.assertExceptionMessage((Exception)ice, (String)"Unable to wrap attribute in class 'org.geotools.feature.wrapper.MineNamePropertyType'. 'urn:org:example:MineNamePropertyType' doesn't have required property 'urn:org:example:MineName'.");
        }
    }
}

