/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.awt.RenderingHints;
import java.util.ArrayList;
import org.geotools.data.complex.expression.FeaturePropertyAccessorFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.ComplexFeatureBuilder;
import org.geotools.feature.FakeTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

public class AttributeCountFunctionTest
extends FunctionTestSupport {
    Feature complexFeature;
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ArrayList<AttributeDescriptorImpl> childSchema = new ArrayList<AttributeDescriptorImpl>();
        NameImpl attOne = new NameImpl("ns", "att1");
        AttributeDescriptorImpl attOneDescriptor = new AttributeDescriptorImpl(FakeTypes.STRING_TYPE, (Name)attOne, 0, -1, false, null);
        childSchema.add(attOneDescriptor);
        FeatureTypeImpl childType = new FeatureTypeImpl((Name)new NameImpl("ns", "childType"), childSchema, null, false, null, null, null);
        ArrayList<AttributeDescriptorImpl> parentSchema = new ArrayList<AttributeDescriptorImpl>();
        parentSchema.add(attOneDescriptor);
        NameImpl attTwo = new NameImpl("ns", "att2");
        AttributeDescriptorImpl attTwoDescriptor = new AttributeDescriptorImpl((AttributeType)childType, (Name)attTwo, 1, -1, false, null);
        parentSchema.add(attTwoDescriptor);
        FeatureTypeImpl parentType = new FeatureTypeImpl((Name)new NameImpl("ns", "parentType"), parentSchema, null, false, null, null, null);
        ComplexFeatureBuilder builder = new ComplexFeatureBuilder((FeatureType)childType);
        builder.append((Name)attOne, (Property)new AttributeImpl((Object)"test1", (AttributeDescriptor)attOneDescriptor, null));
        builder.append((Name)attOne, (Property)new AttributeImpl((Object)"test2", (AttributeDescriptor)attOneDescriptor, null));
        Feature childFeature = builder.buildFeature("childFeature");
        builder = new ComplexFeatureBuilder((FeatureType)parentType);
        ArrayList<Feature> childFeatures = new ArrayList<Feature>();
        childFeatures.add(childFeature);
        builder.append((Name)attTwo, (Property)new ComplexAttributeImpl(childFeatures, (AttributeDescriptor)attTwoDescriptor, null));
        this.complexFeature = builder.buildFeature("parentFeature");
    }

    @Test
    public void testComplexFeature() {
        NamespaceSupport ns = new NamespaceSupport();
        ns.declarePrefix("ns", "ns");
        Hints hints = new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)ns);
        AttributeExpressionImpl att1 = new AttributeExpressionImpl("ns:att1", hints);
        this.ff.function("attributeCount", new Expression[]{att1});
        Assert.assertEquals((Object)0, (Object)this.ff.function("attributeCount", new Expression[]{att1}).evaluate((Object)this.complexFeature));
        AttributeExpressionImpl att2 = new AttributeExpressionImpl("ns:att2", hints);
        this.ff.function("attributeCount", new Expression[]{att2});
        Assert.assertEquals((Object)1, (Object)this.ff.function("attributeCount", new Expression[]{att2}).evaluate((Object)this.complexFeature));
        AttributeExpressionImpl nestedPath = new AttributeExpressionImpl("ns:att2/ns:childType/ns:att1", hints);
        this.ff.function("attributeCount", new Expression[]{nestedPath});
        Assert.assertEquals((Object)2, (Object)this.ff.function("attributeCount", new Expression[]{nestedPath}).evaluate((Object)this.complexFeature));
    }

    @Test
    public void testSimpleFeature() {
        SimpleFeature f = (SimpleFeature)this.featureCollection.features().next();
        AttributeExpressionImpl foo = new AttributeExpressionImpl("foo");
        Assert.assertEquals((Object)1, (Object)this.ff.function("attributeCount", new Expression[]{foo}).evaluate((Object)f));
        AttributeExpressionImpl att1 = new AttributeExpressionImpl("att1");
        Assert.assertEquals((Object)0, (Object)this.ff.function("attributeCount", new Expression[]{att1}).evaluate((Object)f));
    }
}

