/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.expression;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;

public class LiterateFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("literate", FunctionNameImpl.parameter((String)"result", List.class, (String)"Result", (String)"List of items resulted from iteration."), new Parameter[]{FunctionNameImpl.parameter((String)"index", Object.class, (String)"Index", (String)"The index identifier in the expression"), FunctionNameImpl.parameter((String)"times", Integer.class, (String)"Times", (String)"Number of iterations"), FunctionNameImpl.parameter((String)"expression", Object.class, (String)"Expression", (String)"Expression to be applied to each index of the iteration.")});

    public LiterateFunction() {
        super(NAME);
    }

    public Object evaluate(Object feature) {
        if (!(this.getExpression(0) instanceof PropertyName)) {
            throw new IllegalArgumentException("literate function first argument must be index property name");
        }
        final PropertyName indexName = (PropertyName)this.getExpression(0);
        Integer size = (Integer)this.getExpression(1).evaluate(feature, Integer.class);
        if (size == null || size < 0) {
            throw new IllegalArgumentException("literate function requires non-null, positive size");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            final int index = i++;
            DuplicatingFilterVisitor indexVisitor = new DuplicatingFilterVisitor(){

                public Object visit(PropertyName name, Object data) {
                    if (name.equals(indexName)) {
                        return new LiteralExpressionImpl((Object)index);
                    }
                    return name;
                }
            };
            Expression indexedExpression = (Expression)this.getExpression(2).accept((ExpressionVisitor)indexVisitor, null);
            result.add(indexedExpression.evaluate(feature));
        }
        return result;
    }
}

