/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.api.feature.type.FeatureTypeFactory;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.Schema;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.data.complex.feature.type.FeatureTypeRegistry;
import org.geotools.feature.NameImpl;
import org.geotools.gml3.complex.GmlFeatureTypeRegistryConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.complex.FeatureTypeRegistryConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class FeatureTypeRegistryTest {
    private static final Name PolygonPropertyType = new NameImpl("http://www.opengis.net/gml", "PolygonPropertyType");

    @Test
    public void testMultiple() {
        boolean exception;
        FeatureTypeRegistry registry1 = new FeatureTypeRegistry((FeatureTypeFactory)new ComplexFeatureTypeFactoryImpl(), (FeatureTypeRegistryConfiguration)new GmlFeatureTypeRegistryConfiguration("http://www.opengis.net/gml"));
        Assert.assertNotNull((Object)registry1.getAttributeType(PolygonPropertyType));
        FeatureTypeRegistry registry2 = new FeatureTypeRegistry((FeatureTypeFactory)new ComplexFeatureTypeFactoryImpl(), (FeatureTypeRegistryConfiguration)new EmptyFeatureTypeRegistryConfiguration());
        try {
            registry2.getAttributeType(PolygonPropertyType);
            exception = false;
        }
        catch (IllegalArgumentException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testTypeRegistryThreadSafe() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        ArrayList<Future<FeatureTypeRegistry>> futures = new ArrayList<Future<FeatureTypeRegistry>>();
        for (int i = 0; i < 5; ++i) {
            futures.add(executor.submit(() -> new FeatureTypeRegistry((FeatureTypeFactory)new ComplexFeatureTypeFactoryImpl(), (FeatureTypeRegistryConfiguration)new GmlFeatureTypeRegistryConfiguration(null))));
        }
        for (Future future : futures) {
            Assert.assertNotNull(future.get());
        }
        executor.shutdown();
    }

    private class EmptyFeatureTypeRegistryConfiguration
    implements FeatureTypeRegistryConfiguration {
        private EmptyFeatureTypeRegistryConfiguration() {
        }

        public Collection<Schema> getSchemas() {
            return Collections.emptySet();
        }

        public Collection<Configuration> getConfigurations() {
            return Collections.emptySet();
        }

        public boolean isFeatureType(XSDTypeDefinition typeDefinition) {
            return false;
        }

        public boolean isGeometryType(XSDTypeDefinition typeDefinition) {
            return false;
        }

        public boolean isIdentifiable(XSDComplexTypeDefinition typeDefinition) {
            return false;
        }
    }
}

