/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.catalog;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.h2.H2DataStoreFactory;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;

public class DataStoreConfiguration {
    private static final H2DataStoreFactory INTERNAL_STORE_SPI = new H2DataStoreFactory();
    private DataStoreFactorySpi datastoreSpi;
    private Map<String, Serializable> params;
    private boolean shared = false;
    private String storeName;

    public DataStoreConfiguration(Map<String, Serializable> datastoreParams) {
        this((DataStoreFactorySpi)INTERNAL_STORE_SPI, datastoreParams);
    }

    public DataStoreConfiguration(DataStoreFactorySpi datastoreSpi, Map<String, Serializable> datastoreParams) {
        this.datastoreSpi = datastoreSpi;
        this.params = datastoreParams;
    }

    public DataStoreConfiguration(String storeName) {
        this.storeName = storeName;
        this.shared = true;
    }

    public DataStoreFactorySpi getDatastoreSpi() {
        return this.datastoreSpi;
    }

    public void setDatastoreSpi(DataStoreFactorySpi datastoreSpi) {
        this.datastoreSpi = datastoreSpi;
    }

    public Map<String, Serializable> getParams() {
        if (this.params == null) {
            this.params = new HashMap<String, Serializable>();
        }
        return this.params;
    }

    public void setParams(Map<String, Serializable> params) {
        this.params = params;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public static Map<String, Serializable> getDefaultParams(String database, File parentLocation) {
        Utilities.ensureNonNull((String)"database", (Object)database);
        Utilities.ensureNonNull((String)"parentLocation", (Object)parentLocation);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        String url = URLs.fileToUrl((File)parentLocation).toExternalForm();
        try {
            String updatedDB = "file:" + new File(URLs.urlToFile((URL)new URL(url)), database).getPath();
            params.put("ParentLocation", (Serializable)((Object)url));
            params.put("database", (Serializable)((Object)updatedDB));
            params.put("dbtype", (Serializable)((Object)"h2"));
            params.put("user", (Serializable)((Object)"geotools"));
            params.put("passwd", (Serializable)((Object)"geotools"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return params;
    }
}

