/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio;

import it.geosolutions.imageio.core.InitializingReader;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.data.Query;
import org.geotools.api.data.Repository;
import org.geotools.api.feature.type.Name;
import org.geotools.coverage.grid.io.FileSetManager;
import org.geotools.coverage.io.CoverageSourceDescriptor;
import org.geotools.coverage.io.catalog.CoverageSlice;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.coverage.io.catalog.DataStoreConfiguration;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.factory.Hints;

public abstract class GeoSpatialImageReader
extends ImageReader
implements FileSetManager,
InitializingReader {
    protected File file;
    CoverageSlicesCatalog slicesCatalog;
    protected int numImages = -1;
    private String auxiliaryFilesPath = null;
    private String auxiliaryDatastorePath = null;
    Repository repository;

    protected GeoSpatialImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            if (this.slicesCatalog != null) {
                this.slicesCatalog.dispose();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.slicesCatalog = null;
        }
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @SuppressFBWarnings(value={"INT_BAD_COMPARISON_WITH_NONNEGATIVE_VALUE"})
    protected void checkImageIndex(int imageIndex) {
        if (imageIndex < 0 || imageIndex >= this.numImages) {
            throw new IndexOutOfBoundsException("Invalid imageIndex " + imageIndex + ", it should " + (String)(this.numImages > 0 ? "belong the range [0," + (this.numImages - 1) : "be 0"));
        }
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return this.numImages;
    }

    public abstract Collection<Name> getCoveragesNames();

    public abstract int getCoveragesNumber();

    public abstract CoverageSourceDescriptor getCoverageDescriptor(Name var1);

    protected void setCatalog(CoverageSlicesCatalog catalog) {
        if (this.slicesCatalog != null) {
            this.slicesCatalog.dispose();
        }
        this.slicesCatalog = catalog;
    }

    public List<Integer> getImageIndex(Query filterQuery) throws IOException {
        List<CoverageSlice> descs = this.slicesCatalog.getGranules(filterQuery);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (CoverageSlice desc : descs) {
            Integer index = (Integer)desc.getOriginator().getAttribute("imageindex");
            indexes.add(index);
        }
        return indexes;
    }

    public String getAuxiliaryFilesPath() {
        return this.auxiliaryFilesPath;
    }

    public void setAuxiliaryFilesPath(String auxiliaryFilesPath) {
        this.auxiliaryFilesPath = auxiliaryFilesPath;
    }

    public String getAuxiliaryDatastorePath() {
        return this.auxiliaryDatastorePath;
    }

    public void setAuxiliaryDatastorePath(String auxiliaryDatastorePath) {
        this.auxiliaryDatastorePath = auxiliaryDatastorePath;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public CoverageSlicesCatalog getCatalog() {
        return this.slicesCatalog;
    }

    protected void initCatalog(DataStoreConfiguration datastoreConfig) throws IOException {
        this.slicesCatalog = datastoreConfig.isShared() ? new CoverageSlicesCatalog.WrappedCoverageSlicesCatalog(datastoreConfig, this.file, this.repository) : new CoverageSlicesCatalog(datastoreConfig, this.repository);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public boolean init(RenderingHints hints) {
        if (hints != null && (hints.containsKey(Utils.AUXILIARY_FILES_PATH) || hints.containsKey(Utils.AUXILIARY_DATASTORE_PATH))) {
            Repository repository;
            String path;
            if (hints.containsKey(Utils.AUXILIARY_FILES_PATH) && (path = this.getPath(hints, Utils.AUXILIARY_FILES_PATH)) != null) {
                this.setAuxiliaryFilesPath(path);
            }
            if (hints.containsKey(Utils.AUXILIARY_DATASTORE_PATH) && (path = this.getPath(hints, Utils.AUXILIARY_DATASTORE_PATH)) != null) {
                this.setAuxiliaryDatastorePath(path);
            }
            if ((repository = (Repository)hints.get(Hints.REPOSITORY)) != null) {
                this.setRepository(repository);
            }
            return true;
        }
        return false;
    }

    private String getPath(RenderingHints hints, Hints.Key key) {
        Object filePath = (String)hints.get(key);
        if (filePath != null && hints.containsKey(Utils.PARENT_DIR)) {
            String parentDir = (String)hints.get(Utils.PARENT_DIR);
            if (!new File((String)filePath).isAbsolute()) {
                filePath = parentDir + File.separatorChar + (String)filePath;
            }
        }
        return filePath;
    }
}

