/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.CategoryList;
import org.geotools.coverage.TypeMap;
import org.geotools.image.util.ColorUtilities;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.ClassChanger;
import org.geotools.util.Classes;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.XArray;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.util.InternationalString;

public class GridSampleDimension
implements SampleDimension,
Serializable {
    private static final long serialVersionUID = 6026936545776852758L;
    private static final double DELTA = 1.0E-10;
    public static final Logger LOGGER = Logging.getLogger(GridSampleDimension.class);
    final CategoryList categories;
    private final boolean hasQualitative;
    private final boolean hasQuantitative;
    private double scale = 1.0;
    private double offset = 0.0;
    private final InternationalString description;
    private Unit units;

    public GridSampleDimension(CharSequence description) {
        this(description, null, 1.0, 0.0);
    }

    public GridSampleDimension(CharSequence description, CharSequence[] categoriesNames) {
        this(description, GridSampleDimension.list(categoriesNames), 1.0, 0.0);
    }

    private static CategoryList list(CharSequence[] names) {
        int length = names.length;
        Color[] colors = new Color[length];
        double scale = 255.0 / (double)length;
        for (int i = 0; i < length; ++i) {
            int r = (int)Math.round(scale * (double)i);
            colors[i] = new Color(r, r, r);
        }
        return GridSampleDimension.list(names, colors);
    }

    public GridSampleDimension(CharSequence description, CharSequence[] names, Color[] colors) {
        this(description, GridSampleDimension.list(names, colors), 1.0, 0.0);
    }

    private static CategoryList list(CharSequence[] names, Color[] colors) {
        if (names.length != colors.length) {
            throw new IllegalArgumentException(Errors.format((int)91));
        }
        int length = names.length;
        Category[] categories = new Category[length];
        for (int i = 0; i < length; ++i) {
            categories[i] = new Category(names[i], colors[i], i);
        }
        return GridSampleDimension.list(categories, null);
    }

    public GridSampleDimension(CharSequence description, SampleDimensionType type, ColorInterpretation color, Color[] palette, CharSequence[] categories, double[] nodata, double minimum, double maximum, double scale, double offset, Unit<?> unit) {
        this(description, GridSampleDimension.list(description, type, color, palette, categories, nodata, minimum, maximum, unit), scale, offset);
    }

    public GridSampleDimension(CharSequence description, SampleDimensionType type, CharSequence[] categories, double[] nodata, double minimum, double maximum, double scale, double offset, Unit<?> unit) {
        this(description, GridSampleDimension.list(description, type, null, null, categories, nodata, minimum, maximum, unit), scale, offset);
    }

    private static CategoryList list(CharSequence description, SampleDimensionType type, ColorInterpretation color, Color[] palette, CharSequence[] categories, double[] nodata, double minimum, double maximum, Unit<?> unit) {
        Object max;
        if (description == null) {
            description = Vocabulary.formatInternational((int)232);
        }
        if (Double.isInfinite(minimum) || Double.isInfinite(maximum) || !(minimum < maximum)) {
            throw new IllegalArgumentException(Errors.format((int)14, (Object)minimum, (Object)maximum));
        }
        if (type == null) {
            type = TypeMap.getSampleDimensionType(minimum, maximum);
        }
        if (color == null) {
            color = ColorInterpretation.PALETTE_INDEX;
        }
        int nameCount = categories != null ? categories.length : 0;
        int nodataCount = nodata != null ? nodata.length : 0;
        ArrayList<Category> categoryList = new ArrayList<Category>(nameCount + nodataCount + 2);
        for (int i = 0; i < nodataCount; ++i) {
            CharSequence name = null;
            double padValue = nodata[i];
            int intValue = (int)Math.floor(padValue);
            if (intValue >= 0 && intValue < nameCount) {
                if ((double)intValue == padValue) continue;
                name = categories[intValue];
            }
            Number value = TypeMap.wrapSample(padValue, type, false);
            if (name == null) {
                name = value.toString();
            }
            NumberRange range = new NumberRange(value.getClass(), value, value);
            Color[] colors = ColorUtilities.subarray(palette, intValue, intValue + 1);
            categoryList.add(new Category(name, colors, (NumberRange<? extends Number>)range, false));
        }
        if (nameCount != 0) {
            int lower = 0;
            int length = categories.length;
            for (int upper = 1; upper <= length; ++upper) {
                Class<?> classe;
                String nameUpper;
                String nameLower;
                if (upper != length && (nameLower = categories[lower].toString().trim()).equalsIgnoreCase(nameUpper = categories[upper].toString().trim())) continue;
                CharSequence name = categories[lower];
                Object min = TypeMap.wrapSample(lower, type, false);
                if (min.equals(max = TypeMap.wrapSample(upper - 1, type, false))) {
                    min = max;
                    classe = max.getClass();
                } else {
                    classe = ClassChanger.getWidestClass((Number)min, (Number)max);
                    min = ClassChanger.cast((Number)min, classe);
                    max = ClassChanger.cast((Number)max, classe);
                }
                NumberRange range = new NumberRange(classe, (Number)min, (Number)max);
                Color[] colors = ColorUtilities.subarray(palette, lower, upper);
                categoryList.add(new Category(name, colors, (NumberRange<? extends Number>)range, false));
                lower = upper;
            }
        }
        boolean needQuantitative = false;
        if (nodataCount != 0 || categoryList.size() <= 1) {
            needQuantitative = true;
            int i = categoryList.size();
            while (--i >= 0) {
                double xmax;
                double xmin;
                NumberRange<? extends Number> range;
                Comparable min;
                int c;
                Category category = (Category)categoryList.get(i);
                if (category.isQuantitative() || (c = (min = (range = category.getRange()).getMinValue()).compareTo(max = range.getMaxValue())) == 0 || GridSampleDimension.rangeContains(xmin = ((Number)((Object)min)).doubleValue(), xmax = ((Number)max).doubleValue(), nodata)) continue;
                InternationalString name = category.getName();
                Color[] colors = category.getColors();
                category = new Category((CharSequence)name, colors, range);
                categoryList.set(i, category);
                needQuantitative = false;
            }
        }
        if (needQuantitative) {
            boolean minIncluded = true;
            boolean maxIncluded = true;
            int i = categoryList.size();
            while (--i >= 0) {
                NumberRange<? extends Number> range = ((Category)categoryList.get(i)).getRange();
                double min = range.getMinimum();
                double max2 = range.getMaximum();
                if (max2 - minimum < maximum - min) {
                    if (!(max2 >= minimum)) continue;
                    minimum = max2;
                    minIncluded = !range.isMaxIncluded();
                    continue;
                }
                if (!(min <= maximum)) continue;
                maximum = min;
                maxIncluded = !range.isMinIncluded();
            }
            boolean bl = !minIncluded || !maxIncluded;
            if (maximum - minimum > (double)bl) {
                Number min = TypeMap.wrapSample(minimum, type, false);
                Number max3 = TypeMap.wrapSample(maximum, type, false);
                Class classe = ClassChanger.getWidestClass((Number)min, (Number)max3);
                min = ClassChanger.cast((Number)min, (Class)classe);
                max3 = ClassChanger.cast((Number)max3, (Class)classe);
                NumberRange range = new NumberRange(classe, min, minIncluded, max3, maxIncluded);
                Color[] colors = ColorUtilities.subarray(palette, (int)Math.ceil(minimum), (int)Math.floor(maximum));
                categoryList.add(new Category(description, colors, (NumberRange<? extends Number>)range));
                needQuantitative = false;
            }
        }
        Category[] cl = categoryList.toArray(new Category[categoryList.size()]);
        if (ColorInterpretation.PALETTE_INDEX.equals((Object)color) || ColorInterpretation.GRAY_INDEX.equals((Object)color)) {
            return GridSampleDimension.list(cl, unit);
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public GridSampleDimension(CharSequence description, Category[] categories, Unit<?> units) throws IllegalArgumentException {
        this(description, GridSampleDimension.list(categories, units), 1.0, 0.0);
        this.units = units;
    }

    private static CategoryList list(Category[] categories, Unit<?> units) {
        if (categories == null || categories.length == 0) {
            return null;
        }
        CategoryList list = new CategoryList(categories, units);
        return list;
    }

    private GridSampleDimension(CharSequence description, CategoryList list, double scale, double offset) {
        this.description = description != null ? SimpleInternationalString.wrap((CharSequence)description) : (list != null ? list.getName() : Vocabulary.formatInternational((int)232));
        boolean qualitative = false;
        int quantitative = 0;
        this.scale = scale;
        this.offset = offset;
        if (list != null) {
            int i = list.size();
            while (--i >= 0) {
                Category category = list.get(i);
                if (!category.isQuantitative()) {
                    qualitative = true;
                    continue;
                }
                ++quantitative;
            }
        }
        this.categories = list;
        this.hasQualitative = qualitative;
        this.hasQuantitative = quantitative > 0;
    }

    protected GridSampleDimension(GridSampleDimension other) {
        if (other != null) {
            this.categories = other.categories;
            this.hasQualitative = other.hasQualitative;
            this.hasQuantitative = other.hasQuantitative;
            this.scale = other.scale;
            this.offset = other.offset;
            this.description = other.getDescription();
            this.units = other.units;
        } else {
            this.categories = null;
            this.hasQualitative = false;
            this.hasQuantitative = false;
            this.description = Vocabulary.formatInternational((int)232);
        }
    }

    public GridSampleDimension(String description, Category[] categories, double scale, double offset) {
        this((CharSequence)description, GridSampleDimension.list(categories, null), scale, offset);
    }

    public static GridSampleDimension wrap(SampleDimension sd) {
        if (sd instanceof GridSampleDimension) {
            return (GridSampleDimension)sd;
        }
        return new GridSampleDimension((CharSequence)sd.getDescription(), sd.getSampleDimensionType(), (CharSequence[])sd.getCategoryNames(), sd.getNoDataValues(), sd.getMinimumValue(), sd.getMaximumValue(), sd.getScale(), sd.getOffset(), sd.getUnits());
    }

    public SampleDimensionType getSampleDimensionType() {
        NumberRange<? extends Number> range = this.getRange();
        if (range == null) {
            return SampleDimensionType.REAL_32BITS;
        }
        return TypeMap.getSampleDimensionType(range);
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public InternationalString[] getCategoryNames() throws IllegalStateException {
        if (this.categories == null) {
            return null;
        }
        if (this.categories.isEmpty()) {
            return new InternationalString[0];
        }
        Object[] names = null;
        int i = this.categories.size();
        while (--i >= 0) {
            Category category = this.categories.get(i);
            int lower = (int)category.minimum;
            int upper = (int)category.maximum;
            if ((double)lower != category.minimum || lower < 0 || (double)upper != category.maximum || upper < 0) {
                throw new IllegalStateException(Errors.format((int)111));
            }
            if (names == null) {
                names = new InternationalString[upper + 1];
            }
            Arrays.fill(names, lower, upper + 1, category.getName());
        }
        return names;
    }

    public List<Category> getCategories() {
        if (this.categories == null) {
            return Collections.emptyList();
        }
        return this.categories;
    }

    public Category getCategory(double sample) {
        return this.categories != null ? this.categories.getCategory(sample) : null;
    }

    public double[] getNoDataValues() throws IllegalStateException {
        if (!this.hasQuantitative) {
            return null;
        }
        int count = 0;
        double[] padValues = null;
        int size = this.categories.size();
        for (int i = 0; i < size; ++i) {
            double max;
            double min;
            Category category = this.categories.get(i);
            if (category.getName().equals(Category.NODATA.getName())) {
                min = category.minimum;
                max = category.maximum;
                if (Double.isNaN(min) && Double.isNaN(max)) {
                    return new double[]{min};
                }
                if (Math.abs(min - max) < 1.0E-10) {
                    return new double[]{min};
                }
                return new double[]{min, max};
            }
            if (category.isQuantitative()) continue;
            min = category.minimum;
            max = category.maximum;
            if (Double.isNaN(min) && Double.isNaN(max)) continue;
            if (padValues == null) {
                padValues = new double[size - i];
            }
            if (count >= padValues.length) {
                padValues = XArray.resize((double[])padValues, (int)(count * 2));
            }
            padValues[count++] = min;
            if (max == min) continue;
            int lower = (int)min;
            int upper = (int)max;
            if ((double)lower != min || (double)upper != max || !Classes.isInteger((Class)category.getRange().getElementClass())) {
                throw new IllegalStateException(Errors.format((int)111));
            }
            int requiredLength = count + (upper - lower);
            if (requiredLength > padValues.length) {
                padValues = XArray.resize((double[])padValues, (int)(requiredLength * 2));
            }
            while (++lower <= upper) {
                padValues[count++] = lower;
            }
        }
        if (padValues != null) {
            padValues = XArray.resize(padValues, (int)count);
        }
        return padValues;
    }

    public double getMinimumValue() {
        if (this.categories != null && !this.categories.isEmpty()) {
            for (Category cat : this.categories) {
                double value;
                if (Category.NODATA.getName().equals(cat.getName()) || Double.isNaN(value = cat.minimum)) continue;
                return value;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getMaximumValue() {
        if (this.categories != null && !this.categories.isEmpty()) {
            int i = this.categories.size();
            while (--i >= 0) {
                double value;
                Category cat = this.categories.get(i);
                if (Category.NODATA.getName().equals(cat.getName()) || Double.isNaN(value = cat.maximum)) continue;
                return value;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public NumberRange<? extends Number> getRange() {
        return this.categories != null ? this.categories.getRange() : null;
    }

    private static boolean rangeContains(double lower, double upper, double[] values) {
        if (values != null) {
            for (double v : values) {
                if (!(v >= lower) || !(v < upper)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLabel(double value, Locale locale) {
        if (this.categories != null) {
            return this.categories.format(value, locale);
        }
        return null;
    }

    public Unit<?> getUnits() {
        return this.categories != null ? this.categories.getUnits() : this.units;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getScale() {
        return this.scale;
    }

    public ColorInterpretation getColorInterpretation() {
        boolean band = false;
        boolean numBands = true;
        return TypeMap.getColorInterpretation(this.getColorModel(0, 1), 0);
    }

    public ColorModel getColorModel() {
        boolean band = false;
        boolean numBands = true;
        return this.getColorModel(0, 1);
    }

    public ColorModel getColorModel(int visibleBand, int numBands) {
        if (this.categories != null) {
            if (this.hasQualitative) {
                return this.categories.getColorModel(visibleBand, numBands, 4);
            }
            return this.categories.getColorModel(visibleBand, numBands);
        }
        return null;
    }

    public ColorModel getColorModel(int visibleBand, int numBands, int type) {
        if (this.categories != null) {
            return this.categories.getColorModel(visibleBand, numBands, type);
        }
        return null;
    }

    public int hashCode() {
        return this.categories != null ? this.categories.hashCode() : 920215318;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridSampleDimension) {
            GridSampleDimension that = (GridSampleDimension)object;
            return this.description.equals(that.description) && Utilities.equals((Object)this.categories, (Object)that.categories);
        }
        return false;
    }

    public String toString() {
        if (this.categories != null) {
            return this.categories.toString(this, this.description);
        }
        return Classes.getShortClassName((Object)this) + "[\"" + String.valueOf(this.description) + "\"]";
    }
}

