/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.test;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.CompareImageDialog;
import org.geotools.image.test.ImageComparator;
import org.geotools.image.test.ReferenceImageDialog;
import org.geotools.util.logging.Logging;

public class ImageAssert {
    static final boolean INTERACTIVE = Boolean.getBoolean("org.geotools.image.test.interactive");
    static final boolean SKIP = Boolean.getBoolean("org.geotools.image.test.skip");
    static final Logger LOGGER = Logging.getLogger(Logger.class);

    public static void assertEquals(File expectedFile, RenderedImage actualImage, int threshold) throws IOException {
        if (SKIP) {
            return;
        }
        ImageAssert.assertImagesResemble(expectedFile, actualImage, ImageComparator.Mode.IgnoreAntialiasing, threshold, true);
    }

    public static void assertEquals(RenderedImage expectedImage, RenderedImage actualImage, int threshold) {
        ImageComparator comparator = new ImageComparator(ImageComparator.Mode.IgnoreAntialiasing, expectedImage, actualImage);
        if (comparator.getMismatchCount() > (long)threshold) {
            if (INTERACTIVE) {
                CompareImageDialog.show(expectedImage, actualImage, false);
            }
            throw new AssertionError((Object)("Images are visibly different, found " + comparator.getMismatchCount() + " different pixels, against a threshold of " + threshold + "\nYou can add -Dorg.geotools.image.test.interactive=true to show a dialog comparing them (requires GUI support)"));
        }
    }

    public static void assertEquals(File expectedImage, RenderedImage actualImage, int threshold, ImageComparator.Mode mode) throws IOException {
        ImageAssert.assertImagesResemble(expectedImage, actualImage, mode, threshold, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void assertImagesResemble(File expectedFile, RenderedImage actualImage, ImageComparator.Mode mode, int threshold, boolean actualReferenceFile) throws IOException {
        if (!expectedFile.exists()) {
            boolean useAsReference;
            boolean bl = useAsReference = actualReferenceFile && INTERACTIVE && ReferenceImageDialog.show(ImageAssert.realignImage(actualImage));
            if (!useAsReference) throw new AssertionError((Object)("Reference image is missing: " + String.valueOf(expectedFile) + ", add -Dorg.geotools.image.test.interactive=true to show a dialog comparing them (requires GUI support)"));
            try {
                File parent = expectedFile.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new AssertionError((Object)("Could not create directory that will contain :" + expectedFile.getParent()));
                }
                new ImageWorker(actualImage).writePNG(expectedFile, "FILTERED", 0.9f, false, false);
                return;
            }
            catch (IOException e) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Failed to write the image to disk"))).initCause(e);
            }
        }
        BufferedImage expectedImage = ImageIO.read(expectedFile);
        ImageComparator comparator = new ImageComparator(mode, expectedImage, actualImage);
        if (comparator.getMismatchCount() > (long)threshold) {
            boolean overwrite = false;
            if (INTERACTIVE) {
                overwrite = CompareImageDialog.show(ImageAssert.realignImage(expectedImage), ImageAssert.realignImage(actualImage), actualReferenceFile);
            } else {
                Object message = "Images are different, add -Dorg.geotools.image.test.interactive=true to show a dialog comparing them (requires GUI support)";
                try {
                    File actualFile = ImageAssert.writeActualImage(expectedFile, actualImage);
                    message = (String)message + "\n Actual image saved at " + actualFile.getCanonicalPath();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failure while saving actual image on file", e);
                }
                LOGGER.info((String)message);
            }
            if (!overwrite) throw new AssertionError((Object)("Images are visibly different, found " + comparator.getMismatchCount() + " different pixels, against a threshold of " + threshold + "\nYou can add -Dorg.geotools.image.test.interactive=true to show a dialog comparing them (requires GUI support)"));
            ImageIO.write(actualImage, "PNG", expectedFile);
            return;
        }
        LOGGER.fine("Images are not visibly different, found " + comparator.getMismatchCount() + " different pixels, against a threshold of " + threshold);
    }

    private static File writeActualImage(File expectedFile, RenderedImage actualImage) throws IOException {
        File failureDir = new File("./target/image-compare-fails");
        if (!failureDir.exists()) {
            failureDir.mkdir();
        }
        File file = new File(failureDir, expectedFile.getName());
        ImageIO.write(actualImage, "PNG", file);
        return file;
    }

    static String getFormat(File expectedImage) {
        String loName = expectedImage.getName().toLowerCase();
        if (loName.endsWith(".png")) {
            return "PNG";
        }
        if (loName.endsWith(".tif") || loName.endsWith(".tiff")) {
            return "TIFF";
        }
        throw new IllegalArgumentException("Expected image file should be a png or a tiff");
    }

    static final RenderedImage realignImage(RenderedImage image) {
        if (image.getMinX() > 0 || image.getMinY() > 0) {
            return new BufferedImage(image.getColorModel(), ((WritableRaster)image.getData()).createWritableTranslatedChild(0, 0), image.getColorModel().isAlphaPremultiplied(), null);
        }
        return image;
    }
}

