/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class MultiplyConst
extends OperationJAI {
    private static final long serialVersionUID = -1077713495023498436L;

    public MultiplyConst() {
        super("MultiplyConst", MultiplyConst.getOperationDescriptor(JAIExt.getOperationName((String)"MultiplyConst")));
    }

    @Override
    public String getName() {
        return "MultiplyConst";
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        double[] constants = (double[])parameters.parameters.getObjectParameter("constants");
        if (constants.length == 1) {
            double c = constants[0];
            NumberRange<? extends Number> range = ranges[0];
            double min = range.getMinimum() * c;
            double max = range.getMaximum() * c;
            return max < min ? NumberRange.create((double)max, (double)min) : NumberRange.create((double)min, (double)max);
        }
        return super.deriveRange(ranges, parameters);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        GridCoverage2D source = (GridCoverage2D)((Object)parameters2.parameter("source0").getValue());
        if (JAIExt.isJAIExtOperation((String)"operationConst")) {
            parameters.set((Object)AlgebraDescriptor.Operator.MULTIPLY, 1);
        }
        MultiplyConst.handleROINoDataInternal(parameters, source, "operationConst", 2, 3);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return MultiplyConst.handleROINoDataProperties(null, parameters.parameters, sources[0], "operationConst", 2, 3, 4);
    }
}

