/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.text.MessageFormat;
import javax.media.jai.Interpolation;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotReprojectException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.coverage.processing.operation.Resampler2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.GeneralBounds;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class Resample
extends Operation2D {
    private static final long serialVersionUID = -2022393087647420577L;
    public static final ParameterDescriptor<Object> INTERPOLATION_TYPE = new DefaultParameterDescriptor(Citations.OGC, "InterpolationType", Object.class, null, (Object)"NearestNeighbor", null, null, null, false);
    public static final ParameterDescriptor<CoordinateReferenceSystem> COORDINATE_REFERENCE_SYSTEM = new DefaultParameterDescriptor(Citations.OGC, "CoordinateReferenceSystem", CoordinateReferenceSystem.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<GridGeometry> GRID_GEOMETRY = new DefaultParameterDescriptor(Citations.OGC, "GridGeometry", GridGeometry.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<double[]> BACKGROUND_VALUES = new DefaultParameterDescriptor(Citations.JAI, "BackgroundValues", double[].class, null, null, null, null, null, false);
    public static final String OPERATION = "method";
    public static final String WARP_TYPE = "warpType";
    public static final String GRID_DIMENSIONS = "gridDimensions";

    public Resample() {
        super((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(Citations.OGC, "Resample", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, INTERPOLATION_TYPE, COORDINATE_REFERENCE_SYSTEM, GRID_GEOMETRY, BACKGROUND_VALUES}));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        GridCoverage2D source = (GridCoverage2D)((Object)parameters.parameter("Source").getValue());
        Interpolation interpolation = ImageUtilities.toInterpolation(parameters.parameter("InterpolationType").getValue());
        CoordinateReferenceSystem targetCRS = (CoordinateReferenceSystem)parameters.parameter("CoordinateReferenceSystem").getValue();
        if (targetCRS == null) {
            targetCRS = source.getCoordinateReferenceSystem();
        }
        GridGeometry2D targetGG = GridGeometry2D.wrap((GridGeometry)parameters.parameter("GridGeometry").getValue());
        ParameterValue bgValueParam = parameters.parameter("BackgroundValues");
        double[] bgValues = bgValueParam != null && bgValueParam instanceof Parameter ? (double[])((Parameter)bgValueParam).getValue() : null;
        try {
            return Resampler2D.reproject(source, targetCRS, targetGG, interpolation, hints instanceof Hints ? hints : new Hints((RenderingHints)hints), bgValues);
        }
        catch (FactoryException | TransformException exception) {
            InternationalString arg0 = source.getName();
            throw new CannotReprojectException(MessageFormat.format("Can't reproject grid coverage \"{0}\".", arg0), exception);
        }
    }

    public static GridGeometry computeGridGeometry(GridCoverage source, Bounds target) throws TransformException {
        CoordinateReferenceSystem targetCRS = target.getCoordinateReferenceSystem();
        CoordinateReferenceSystem sourceCRS = source.getCoordinateReferenceSystem();
        CoordinateReferenceSystem reducedCRS = target.getDimension() == 2 && sourceCRS.getCoordinateSystem().getDimension() != 2 ? CoverageUtilities.getCRS2D((Coverage)source) : sourceCRS;
        GridGeometry gridGeometry = source.getGridGeometry();
        if (targetCRS == null || CRS.equalsIgnoreMetadata((Object)reducedCRS, (Object)targetCRS)) {
            Object gridToCRS = reducedCRS == sourceCRS ? gridGeometry.getGridToCRS() : GridGeometry2D.wrap(gridGeometry).getGridToCRS2D();
            gridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)gridToCRS, target, null);
        } else {
            try {
                MathTransform gridToCRS;
                Bounds reduced;
                GeneralBounds transformed = CRS.transform((CoordinateOperation)CRS.getCoordinateOperationFactory((boolean)true).createOperation(targetCRS, reducedCRS), (Bounds)target);
                if (reducedCRS == sourceCRS) {
                    reduced = source.getEnvelope();
                    gridToCRS = gridGeometry.getGridToCRS();
                } else {
                    reduced = CoverageUtilities.getEnvelope2D((Coverage)source);
                    gridToCRS = GridGeometry2D.wrap(gridGeometry).getGridToCRS2D();
                }
                transformed.intersect(reduced);
                gridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, gridToCRS, (Bounds)transformed, null);
            }
            catch (FactoryException | TransformException exception) {
                Resample.recoverableException("resample", (Exception)exception);
            }
            GridEnvelope gridRange = gridGeometry.getGridRange();
            gridGeometry = new GridGeometry2D(gridRange, target);
        }
        return gridGeometry;
    }

    private static void recoverableException(String method, Exception exception) {
        Logging.recoverableException(Resample.class, (String)method, (Throwable)exception);
    }
}

